/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.exceptions;

public class IndexBoundsException
extends IndexOutOfBoundsException {
    private final long startIndex;
    private final long indexBound;
    private final long index;
    private static final long serialVersionUID = 1489211066951377456L;

    public static final String messageBody() {
        return "Index out of bounds";
    }

    public IndexBoundsException(long indexBound) {
        this(indexBound, null);
    }

    public IndexBoundsException(long indexBound, String message) {
        this(0L, indexBound, indexBound, message);
    }

    public IndexBoundsException(long indexBound, long index) {
        this(0L, indexBound, index, null);
    }

    public IndexBoundsException(long indexBound, long index, String message) {
        this(0L, indexBound, index, message);
    }

    public IndexBoundsException(long startIndex, long indexBound, long index) {
        this(startIndex, indexBound, index, null);
    }

    public IndexBoundsException(long startIndex, long indexBound, long index, String message) {
        super(message);
        this.startIndex = startIndex;
        this.indexBound = indexBound;
        this.index = index;
    }

    public final long startIndex() {
        return this.startIndex;
    }

    public final long indexBound() {
        return this.indexBound;
    }

    public final long index() {
        return this.index;
    }

    public final String message() {
        return super.getMessage();
    }

    public String assembleDetailString() {
        return String.valueOf(IndexBoundsException.messageBody()) + ": " + this.index + " not in [" + this.startIndex + ";" + this.indexBound + "[";
    }

    protected String assembleExplicitMessageAddon() {
        String explicitMessage = super.getMessage();
        return explicitMessage != null ? " (" + explicitMessage + ")" : "";
    }

    public String assembleOutputString() {
        return String.valueOf(this.assembleDetailString()) + this.assembleExplicitMessageAddon();
    }

    @Override
    public String getMessage() {
        return this.assembleOutputString();
    }
}

