/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.functional;

import java.util.Comparator;
import one.microstream.functional.Aggregator;

public final class AggregateMax<E>
implements Aggregator<E, E> {
    private final Comparator<? super E> comparator;
    private E currentMax;

    public AggregateMax(Comparator<? super E> comparator) {
        this.comparator = comparator;
    }

    @Override
    public final void accept(E element) {
        if (this.comparator.compare(element, this.currentMax) >= 0) {
            this.currentMax = element;
        }
    }

    @Override
    public final E yield() {
        return this.currentMax;
    }
}

