/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.functional;

import one.microstream.X;
import one.microstream.functional.Aggregator;

public final class AggregateOffsetLength<E, R>
implements Aggregator<E, R> {
    private long offset;
    private long length;
    private final Aggregator<? super E, R> aggregate;

    public AggregateOffsetLength(long offset, long length, Aggregator<? super E, R> aggregate) {
        this.offset = offset;
        this.length = length;
        this.aggregate = aggregate;
    }

    @Override
    public final void accept(E element) {
        if (this.offset > 0L) {
            --this.offset;
            return;
        }
        this.aggregate.accept(element);
        if (--this.length == 0L) {
            throw X.BREAK();
        }
    }

    @Override
    public final R yield() {
        return this.aggregate.yield();
    }
}

