/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.math;

import java.awt.Point;
import one.microstream.math.IntCoordinateManipulator;
import one.microstream.math.InvalidCoordinateException;

public class Bresenham {
    public static final int stepCountDistance(int x1, int y1, int x2, int y2) {
        return Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2));
    }

    public static final Point[] linePoints(int x1, int y1, int x2, int y2) {
        int x = x1;
        int y = y1;
        int d = 0;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int xInc = 1;
        int yInc = 1;
        Point[] points = new Point[Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)) + 1];
        int idx = 0;
        if (hx < 0) {
            xInc = -1;
            hx = -hx;
        }
        if (hy < 0) {
            yInc = -1;
            hy = -hy;
        }
        if (hy <= hx) {
            int c = 2 * hx;
            int m = 2 * hy;
            while (true) {
                points[idx++] = new Point(x, y);
                if (x != x2) {
                    x += xInc;
                    if ((d += m) <= hx) continue;
                    y += yInc;
                    d -= c;
                    continue;
                }
                break;
            }
        } else {
            int c = 2 * hy;
            int m = 2 * hx;
            while (true) {
                points[idx++] = new Point(x, y);
                if (y == y2) break;
                y += yInc;
                if ((d += m) <= hy) continue;
                x += xInc;
                d -= c;
            }
        }
        return points;
    }

    public static final int[] linePointsInt1D(int x1, int y1, int x2, int y2) {
        int x = x1;
        int y = y1;
        int d = 0;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int xInc = 1;
        int yInc = 1;
        int[] points = new int[(Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)) + 1) * 2];
        int idx = 0;
        if (hx < 0) {
            xInc = -1;
            hx = -hx;
        }
        if (hy < 0) {
            yInc = -1;
            hy = -hy;
        }
        if (hy <= hx) {
            int c = 2 * hx;
            int m = 2 * hy;
            while (true) {
                points[idx++] = x;
                points[idx++] = y;
                if (x != x2) {
                    x += xInc;
                    if ((d += m) <= hx) continue;
                    y += yInc;
                    d -= c;
                    continue;
                }
                break;
            }
        } else {
            int c = 2 * hy;
            int m = 2 * hx;
            while (true) {
                points[idx++] = x;
                points[idx++] = y;
                if (y == y2) break;
                y += yInc;
                if ((d += m) <= hy) continue;
                x += xInc;
                d -= c;
            }
        }
        return points;
    }

    public static final int[][] linePointsInt2D(int x1, int y1, int x2, int y2) {
        int x = x1;
        int y = y1;
        int d = 0;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int xInc = 1;
        int yInc = 1;
        int[][] points = new int[Math.max(Math.abs(x1 - x2), Math.abs(y1 - y2)) + 1][];
        int idx = 0;
        if (hx < 0) {
            xInc = -1;
            hx = -hx;
        }
        if (hy < 0) {
            yInc = -1;
            hy = -hy;
        }
        if (hy <= hx) {
            int c = 2 * hx;
            int m = 2 * hy;
            while (true) {
                points[idx++] = new int[]{x, y};
                if (x != x2) {
                    x += xInc;
                    if ((d += m) <= hx) continue;
                    y += yInc;
                    d -= c;
                    continue;
                }
                break;
            }
        } else {
            int c = 2 * hy;
            int m = 2 * hx;
            while (true) {
                points[idx++] = new int[]{x, y};
                if (y == y2) break;
                y += yInc;
                if ((d += m) <= hy) continue;
                x += xInc;
                d -= c;
            }
        }
        return points;
    }

    public static final void line(int x1, int y1, int x2, int y2, IntCoordinateManipulator manipulator) throws InvalidCoordinateException {
        int x = x1;
        int y = y1;
        int d = 0;
        int hx = x2 - x1;
        int hy = y2 - y1;
        int xInc = 1;
        int yInc = 1;
        if (hx < 0) {
            xInc = -1;
            hx = -hx;
        }
        if (hy < 0) {
            yInc = -1;
            hy = -hy;
        }
        if (hy <= hx) {
            int c = 2 * hx;
            int m = 2 * hy;
            while (true) {
                manipulator.manipulateCoordinate(x, y);
                if (x != x2) {
                    x += xInc;
                    if ((d += m) <= hx) continue;
                    y += yInc;
                    d -= c;
                    continue;
                }
                break;
            }
        } else {
            int c = 2 * hy;
            int m = 2 * hx;
            while (true) {
                manipulator.manipulateCoordinate(x, y);
                if (y == y2) break;
                y += yInc;
                if ((d += m) <= hy) continue;
                x += xInc;
                d -= c;
            }
        }
    }

    private Bresenham() {
        throw new UnsupportedOperationException();
    }
}

