/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.math;

public enum DirectionCardinal {
    NORTH_WEST(16),
    NORTH(1),
    NORTH_EAST(32),
    WEST(8),
    CENTER(0),
    EAST(2),
    SOUTH_WEST(128),
    SOUTH(4),
    SOUTH_EAST(64);

    private static final DirectionCardinal[][] MATRIX;
    private final int directionBit;
    private transient DirectionCardinal cachedOpposite;

    static {
        MATRIX = new DirectionCardinal[][]{{NORTH_WEST, NORTH, NORTH_EAST}, {WEST, CENTER, EAST}, {SOUTH_WEST, SOUTH, SOUTH_EAST}};
    }

    public static final DirectionCardinal translateNeighborVector(int difX, int difY) throws IllegalArgumentException {
        if (difX == 0 && difY == 0 || Math.abs(difX) != 1 && Math.abs(difY) != 1) {
            throw new IllegalArgumentException("Vector does not point to a neighbor: (" + difX + ',' + difY + ')');
        }
        return MATRIX[difY + 1][difX + 1];
    }

    private DirectionCardinal(int bit) {
        this.directionBit = bit;
    }

    public int getBit() {
        return this.directionBit;
    }

    private final DirectionCardinal determineOpposite() {
        switch (this) {
            case NORTH_WEST: {
                return SOUTH_EAST;
            }
            case NORTH: {
                return SOUTH;
            }
            case NORTH_EAST: {
                return SOUTH_WEST;
            }
            case WEST: {
                return EAST;
            }
            case EAST: {
                return WEST;
            }
            case SOUTH_WEST: {
                return NORTH_EAST;
            }
            case SOUTH: {
                return NORTH;
            }
            case SOUTH_EAST: {
                return NORTH_WEST;
            }
            case CENTER: {
                return CENTER;
            }
        }
        throw new RuntimeException("Unknown " + DirectionCardinal.class.getSimpleName() + ": " + (Object)((Object)this));
    }

    public DirectionCardinal opposite() {
        if (this.cachedOpposite == null) {
            this.cachedOpposite = this.determineOpposite();
        }
        return this.cachedOpposite;
    }

    public final boolean isSet(int bits) {
        return (bits & this.directionBit) > 0;
    }

    public final boolean isMainDirection() {
        int bit = this.directionBit;
        return bit != 0 && bit <= DirectionCardinal.WEST.directionBit;
    }

    public final boolean isIntermediateDirection() {
        int bit = this.directionBit;
        return bit != 0 && bit > DirectionCardinal.WEST.directionBit;
    }
}

