/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Random;
import one.microstream.exceptions.NumberRangeException;
import one.microstream.functional.To_double;
import one.microstream.math._longRange;

public final class XMath {
    private static final transient Random RANDOM = new Random();
    private static final transient int MAX_POW_2_INT = 0x40000000;
    private static final transient int PERCENT = 100;
    private static final transient Double ZERO = 0.0;
    private static final transient Double ONE = 1.0;

    public static Double zero() {
        return ZERO;
    }

    public static Double one() {
        return ONE;
    }

    public static final int pow(int base, int exponent) throws IllegalArgumentException {
        if (exponent < 0) {
            throw new IllegalArgumentException("exponent may not be negative: " + exponent);
        }
        if (exponent == 0) {
            return 1;
        }
        if (base == 0 || base == 1) {
            return base;
        }
        int result = 1;
        int e = exponent;
        while (e-- > 0) {
            result *= base;
        }
        return result;
    }

    public static final int pow10(int exponent) throws IllegalArgumentException {
        if (exponent < 0) {
            throw new IllegalArgumentException("exponent may not be negative: " + exponent);
        }
        if (exponent == 0) {
            return 1;
        }
        int result = 1;
        int e = exponent;
        while (e-- > 0) {
            result *= 10;
        }
        return result;
    }

    public static final double pow10_double(int exponent) throws IllegalArgumentException {
        if (exponent < 0) {
            throw new IllegalArgumentException("exponent may not be negative: " + exponent);
        }
        if (exponent == 0) {
            return 1.0;
        }
        double result = 1.0;
        int e = exponent;
        while (e-- > 0) {
            result *= 10.0;
        }
        return result;
    }

    public static final long pow10_long(int exponent) throws IllegalArgumentException {
        if (exponent < 0) {
            throw new IllegalArgumentException("exponent may not be negative: " + exponent);
        }
        if (exponent == 0) {
            return 1L;
        }
        long result = 1L;
        int e = exponent;
        while (e-- > 0) {
            result *= 10L;
        }
        return result;
    }

    public static final int pow2BoundMaxed(int n) {
        if (n > 0x40000000) {
            return Integer.MAX_VALUE;
        }
        int i = 1;
        while (i < n) {
            i <<= 1;
        }
        return i;
    }

    public static final int pow2BoundCapped(int n) {
        if (n >= 0x40000000) {
            return 0x40000000;
        }
        int i = 1;
        while (i < n) {
            i <<= 1;
        }
        return i;
    }

    public static final int pow2Bound(int n) {
        if (n > 0x40000000) {
            throw new IllegalArgumentException();
        }
        int i = 1;
        while (i < n) {
            i <<= 1;
        }
        return i;
    }

    public static final int log2pow2(int pow2Value) {
        switch (pow2Value) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 16: {
                return 4;
            }
            case 32: {
                return 5;
            }
            case 64: {
                return 6;
            }
            case 128: {
                return 7;
            }
            case 256: {
                return 8;
            }
            case 512: {
                return 9;
            }
            case 1024: {
                return 10;
            }
            case 2048: {
                return 11;
            }
            case 4096: {
                return 12;
            }
            case 8192: {
                return 13;
            }
            case 16384: {
                return 14;
            }
            case 32768: {
                return 15;
            }
            case 65536: {
                return 16;
            }
            case 131072: {
                return 17;
            }
            case 262144: {
                return 18;
            }
            case 524288: {
                return 19;
            }
            case 0x100000: {
                return 20;
            }
            case 0x200000: {
                return 21;
            }
            case 0x400000: {
                return 22;
            }
            case 0x800000: {
                return 23;
            }
            case 0x1000000: {
                return 24;
            }
            case 0x2000000: {
                return 25;
            }
            case 0x4000000: {
                return 26;
            }
            case 0x8000000: {
                return 27;
            }
            case 0x10000000: {
                return 28;
            }
            case 0x20000000: {
                return 29;
            }
            case 0x40000000: {
                return 30;
            }
        }
        throw new IllegalArgumentException("Not a power-of-2 value: " + pow2Value);
    }

    public static final boolean isPow2(int value) {
        switch (value) {
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
            case 16: {
                return true;
            }
            case 32: {
                return true;
            }
            case 64: {
                return true;
            }
            case 128: {
                return true;
            }
            case 256: {
                return true;
            }
            case 512: {
                return true;
            }
            case 1024: {
                return true;
            }
            case 2048: {
                return true;
            }
            case 4096: {
                return true;
            }
            case 8192: {
                return true;
            }
            case 16384: {
                return true;
            }
            case 32768: {
                return true;
            }
            case 65536: {
                return true;
            }
            case 131072: {
                return true;
            }
            case 262144: {
                return true;
            }
            case 524288: {
                return true;
            }
            case 0x100000: {
                return true;
            }
            case 0x200000: {
                return true;
            }
            case 0x400000: {
                return true;
            }
            case 0x800000: {
                return true;
            }
            case 0x1000000: {
                return true;
            }
            case 0x2000000: {
                return true;
            }
            case 0x4000000: {
                return true;
            }
            case 0x8000000: {
                return true;
            }
            case 0x10000000: {
                return true;
            }
            case 0x20000000: {
                return true;
            }
            case 0x40000000: {
                return true;
            }
        }
        return false;
    }

    public static final int log10discrete(int value) throws IllegalArgumentException {
        if (value >= 10000) {
            if (value >= 10000000) {
                return value >= 1000000000 ? 9 : (value >= 100000000 ? 8 : 7);
            }
            return value >= 1000000 ? 6 : (value >= 100000 ? 5 : 4);
        }
        if (value >= 100) {
            return value >= 1000 ? 3 : 2;
        }
        if (value >= 10) {
            return 1;
        }
        if (value >= 1) {
            return 0;
        }
        throw new IllegalArgumentException("Cannot calculate log10() of value " + value);
    }

    public static final int stringLength(int value) {
        if (value > 0) {
            return XMath.log10discrete(value) + 1;
        }
        if (value < 0) {
            return XMath.log10discrete(-value) + 2;
        }
        return 1;
    }

    public static final float pow(float base, int exponent) throws IllegalArgumentException {
        if (exponent < 0) {
            throw new IllegalArgumentException("exponent may not be negative: " + exponent);
        }
        if (exponent == 0) {
            return 1.0f;
        }
        if (base == 0.0f || base == 1.0f) {
            return base;
        }
        float result = 1.0f;
        int e = exponent;
        while (e-- > 0) {
            result *= base;
        }
        return result;
    }

    public static final double pow(double base, int exponent) throws IllegalArgumentException {
        if (exponent < 0) {
            throw new IllegalArgumentException("exponent may not be negative: " + exponent);
        }
        if (exponent == 0) {
            return 1.0;
        }
        if (base == 0.0 || base == 1.0) {
            return base;
        }
        double result = 1.0;
        int e = exponent;
        while (e-- > 0) {
            result *= base;
        }
        return result;
    }

    public static final float square(float f) {
        return f * f;
    }

    public static final long square(long l) {
        return l * l;
    }

    public static final int square(int i) {
        return i * i;
    }

    public static final double square(double d) {
        return d * d;
    }

    public static final float cube(float f) {
        return f * f * f;
    }

    public static final long cube(long l) {
        return l * l * l;
    }

    public static final int cube(int i) {
        return i * i * i;
    }

    public static final double cube(double d) {
        return d * d * d;
    }

    public static final double round0(double value) {
        return StrictMath.floor(value + 0.5);
    }

    public static final double round1(double value) {
        return StrictMath.floor(value * 10.0 + 0.5) / 10.0;
    }

    public static final double round2(double value) {
        return StrictMath.floor(value * 100.0 + 0.5) / 100.0;
    }

    public static final double round3(double value) {
        return StrictMath.floor(value * 1000.0 + 0.5) / 1000.0;
    }

    public static final double round4(double value) {
        return StrictMath.floor(value * 10000.0 + 0.5) / 10000.0;
    }

    public static final double round5(double value) {
        return StrictMath.floor(value * 100000.0 + 0.5) / 100000.0;
    }

    public static final double round6(double value) {
        return StrictMath.floor(value * 1000000.0 + 0.5) / 1000000.0;
    }

    public static final double round7(double value) {
        return StrictMath.floor(value * 1.0E7 + 0.5) / 1.0E7;
    }

    public static final double round8(double value) {
        return StrictMath.floor(value * 1.0E8 + 0.5) / 1.0E8;
    }

    public static final double round9(double value) {
        return StrictMath.floor(value * 1.0E9 + 0.5) / 1.0E9;
    }

    public static final double round(double value, int decimals) {
        switch (decimals) {
            case 0: {
                return StrictMath.floor(value + 0.5);
            }
            case 1: {
                return StrictMath.floor(value * 10.0 + 0.5) / 10.0;
            }
            case 2: {
                return StrictMath.floor(value * 100.0 + 0.5) / 100.0;
            }
            case 3: {
                return StrictMath.floor(value * 1000.0 + 0.5) / 1000.0;
            }
            case 4: {
                return StrictMath.floor(value * 10000.0 + 0.5) / 10000.0;
            }
            case 5: {
                return StrictMath.floor(value * 100000.0 + 0.5) / 100000.0;
            }
            case 6: {
                return StrictMath.floor(value * 1000000.0 + 0.5) / 1000000.0;
            }
        }
        return XMath.internalRound(value, decimals);
    }

    private static final double internalRound(double value, int decimals) {
        if (decimals < 0) {
            throw new IllegalArgumentException("No negative values allowed for decimals: " + decimals);
        }
        if (decimals > 323) {
            throw new IllegalArgumentException("decimals value out of range: " + decimals);
        }
        double factor = 1.0;
        int d = decimals;
        while (d-- > 0) {
            factor *= 10.0;
        }
        return StrictMath.floor(value * factor + 0.5) / factor;
    }

    public static _longRange range(int start, int bound) {
        return _longRange.New(start, bound);
    }

    public static byte[] sequence(byte from, byte to) {
        byte[] range;
        if (from < to) {
            range = new byte[to - from + 1];
            byte f = from;
            int i = 0;
            while (i < range.length) {
                f = (byte)(f + 1);
                ++i;
            }
        } else {
            range = new byte[from - to + 1];
            byte f = from;
            int i = 0;
            while (i < range.length) {
                f = (byte)(f - 1);
                ++i;
            }
        }
        return range;
    }

    public static short[] sequence(short from, short to) {
        short[] range;
        if (from < to) {
            range = new short[to - from + 1];
            short f = from;
            int i = 0;
            while (i < range.length) {
                f = (short)(f + 1);
                ++i;
            }
        } else {
            range = new short[from - to + 1];
            short f = from;
            int i = 0;
            while (i < range.length) {
                f = (short)(f - 1);
                ++i;
            }
        }
        return range;
    }

    public static int[] sequence(int lastValue) {
        int[] sequence;
        if (lastValue >= 0) {
            int size = lastValue + 1;
            sequence = new int[size];
            int i = 0;
            while (i < size) {
                sequence[i] = i;
                ++i;
            }
        } else {
            int size = -lastValue + 1;
            sequence = new int[size];
            int i = 0;
            int v = 0;
            while (i < size) {
                sequence[i] = v--;
                ++i;
            }
        }
        return sequence;
    }

    public static int[] randoming(int length) {
        int[] ints = new int[length];
        int bound = length;
        int i = length;
        while (i-- > 0) {
            ints[i] = RANDOM.nextInt(bound);
        }
        return ints;
    }

    public static int[] randoming(int length, int bound) {
        int[] ints = new int[length];
        int i = length;
        while (i-- > 0) {
            ints[i] = RANDOM.nextInt(bound);
        }
        return ints;
    }

    public static int[] randoming(int length, int lowestValue, int bound) {
        int[] ints = new int[length];
        int randomBound = bound - lowestValue;
        int i = length;
        while (i-- > 0) {
            ints[i] = RANDOM.nextInt(randomBound) + lowestValue;
        }
        return ints;
    }

    public static Integer[] sequence(Integer lastValue) {
        Integer[] sequence;
        if (lastValue >= 0) {
            int size = lastValue + 1;
            sequence = new Integer[size];
            int i = 0;
            while (i < size) {
                sequence[i] = i;
                ++i;
            }
        } else {
            int size = -lastValue.intValue() + 1;
            sequence = new Integer[size];
            int i = 0;
            int v = 0;
            while (i < size) {
                sequence[i] = v--;
                ++i;
            }
        }
        return sequence;
    }

    public static int[] sequence(int from, int to) {
        int[] range;
        if (from < to) {
            range = new int[to - from + 1];
            int f = from;
            int i = 0;
            while (i < range.length) {
                range[i] = f++;
                ++i;
            }
        } else {
            range = new int[from - to + 1];
            int f = from;
            int i = 0;
            while (i < range.length) {
                range[i] = f--;
                ++i;
            }
        }
        return range;
    }

    public static long[] sequence(long from, long to) throws IllegalArgumentException {
        long[] range;
        if (from < to) {
            long elementCount = to - from + 1L;
            if (elementCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Range [" + from + ";" + to + "] exceeds array range limit: " + elementCount + " > " + Integer.MAX_VALUE);
            }
            range = new long[(int)elementCount];
            long f = from;
            int i = 0;
            while (i < range.length) {
                ++f;
                ++i;
            }
        } else {
            long elementCount = from - to + 1L;
            if (elementCount > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("Range [" + from + ";" + to + "] exceeds array range limit: " + elementCount + " > " + Integer.MAX_VALUE);
            }
            range = new long[(int)elementCount];
            long f = from;
            int i = 0;
            while (i < range.length) {
                --f;
                ++i;
            }
        }
        return range;
    }

    public static final double max(double ... values) {
        if (values == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        double currentMax = -4.9E-324;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d > currentMax) {
                currentMax = d;
            }
            ++n2;
        }
        return currentMax;
    }

    public static final float max(float ... values) {
        if (values == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        float currentMax = -1.4E-45f;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (f > currentMax) {
                currentMax = f;
            }
            ++n2;
        }
        return currentMax;
    }

    public static final int max(int ... values) {
        if (values == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        int currentMax = Integer.MIN_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i > currentMax) {
                currentMax = i;
            }
            ++n2;
        }
        return currentMax;
    }

    public static final long max(long ... values) {
        if (values == null) {
            throw new IllegalArgumentException("values may not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        long currentMax = Long.MIN_VALUE;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            if (l > currentMax) {
                currentMax = l;
            }
            ++n2;
        }
        return currentMax;
    }

    public static final double min(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        double currentMin = -1.7976931348623157E308;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            if (d < currentMin) {
                currentMin = d;
            }
            ++n2;
        }
        return currentMin;
    }

    public static final float min(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        float currentMin = -3.4028235E38f;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            if (f < currentMin) {
                currentMin = f;
            }
            ++n2;
        }
        return currentMin;
    }

    public static final int min(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        int currentMin = Integer.MAX_VALUE;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            if (i < currentMin) {
                currentMin = i;
            }
            ++n2;
        }
        return currentMin;
    }

    public static final long min(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException("values may not be empty");
        }
        long currentMin = Long.MAX_VALUE;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            if (l < currentMin) {
                currentMin = l;
            }
            ++n2;
        }
        return currentMin;
    }

    public static final long sum(byte ... values) {
        long sum = 0L;
        byte[] byArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            byte i = byArray[n2];
            sum += (long)i;
            ++n2;
        }
        return sum;
    }

    public static final long sum(short ... values) {
        long sum = 0L;
        short[] sArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            short i = sArray[n2];
            sum += (long)i;
            ++n2;
        }
        return sum;
    }

    public static final long sum(int ... values) {
        long sum = 0L;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sum += (long)i;
            ++n2;
        }
        return sum;
    }

    public static final double sum(float ... values) {
        double sum = 0.0;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            sum += (double)f;
            ++n2;
        }
        return sum;
    }

    public static final long sum(long ... values) {
        long sum = 0L;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            sum += l;
            ++n2;
        }
        return sum;
    }

    public static final double sum(double ... values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum;
    }

    public static final double columnSum(int columnIndex, double[] ... matrix) {
        int rowCount = matrix.length;
        double sum = 0.0;
        int r = rowCount;
        while (r-- > 0) {
            sum += matrix[r][columnIndex];
        }
        return sum;
    }

    public static final double columnSum(int columnIndex, Double[] ... matrix) {
        int rowCount = matrix.length;
        double sum = 0.0;
        int r = rowCount;
        while (r-- > 0) {
            if (matrix[r][columnIndex] == null) continue;
            sum += matrix[r][columnIndex].doubleValue();
        }
        return sum;
    }

    public static final double avg(double ... values) {
        double sum = 0.0;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum / (double)values.length;
    }

    public static final float avg(float ... values) {
        float sum = 0.0f;
        float[] fArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            sum += f;
            ++n2;
        }
        return sum / (float)values.length;
    }

    public static final int avg(int ... values) {
        int sum = 0;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            sum += i;
            ++n2;
        }
        return sum / values.length;
    }

    public static final long avg(long ... values) {
        long sum = 0L;
        long[] lArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            sum += l;
            ++n2;
        }
        return sum / (long)values.length;
    }

    public static final double lowerRatio(double a, double b) {
        if (a > 0.0 && b > 0.0) {
            return a < b ? a / b : b / a;
        }
        return Math.abs(Math.abs(a) < Math.abs(b) ? a / b : b / a);
    }

    public static final int factorial(int n) throws IllegalArgumentException {
        switch (n) {
            case 12: {
                return 479001600;
            }
            case 11: {
                return 39916800;
            }
            case 10: {
                return 3628800;
            }
            case 9: {
                return 362880;
            }
            case 8: {
                return 40320;
            }
            case 7: {
                return 5040;
            }
            case 6: {
                return 720;
            }
            case 5: {
                return 120;
            }
            case 4: {
                return 24;
            }
            case 3: {
                return 6;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 1;
            }
            case 0: {
                return 1;
            }
        }
        throw new IllegalArgumentException("n not in [0;12]: " + n);
    }

    public static final long factorial(long n) throws IllegalArgumentException {
        switch ((int)n) {
            case 20: {
                return 2432902008176640000L;
            }
            case 19: {
                return 121645100408832000L;
            }
            case 18: {
                return 6402373705728000L;
            }
            case 17: {
                return 355687428096000L;
            }
            case 16: {
                return 20922789888000L;
            }
            case 15: {
                return 1307674368000L;
            }
            case 14: {
                return 87178291200L;
            }
            case 13: {
                return 6227020800L;
            }
            case 12: {
                return 479001600L;
            }
            case 11: {
                return 39916800L;
            }
            case 10: {
                return 3628800L;
            }
            case 9: {
                return 362880L;
            }
            case 8: {
                return 40320L;
            }
            case 7: {
                return 5040L;
            }
            case 6: {
                return 720L;
            }
            case 5: {
                return 120L;
            }
            case 4: {
                return 24L;
            }
            case 3: {
                return 6L;
            }
            case 2: {
                return 2L;
            }
            case 1: {
                return 1L;
            }
            case 0: {
                return 1L;
            }
        }
        throw new IllegalArgumentException("n not in [0;20]: " + n);
    }

    public static final BigInteger factorial(BigInteger n) throws IllegalArgumentException {
        long nValue = n.longValue();
        if (nValue < 0L) {
            throw new IllegalArgumentException("n may not be negative: " + nValue);
        }
        if (nValue <= 20L) {
            return BigInteger.valueOf(XMath.factorial(nValue));
        }
        BigInteger result = BigInteger.valueOf(XMath.factorial(20L));
        BigInteger value = n;
        while (n.longValue() > 20L) {
            result = result.multiply(value);
            value = value.subtract(BigInteger.ONE);
        }
        return result;
    }

    public static final BigInteger bigInt(int value) {
        return BigInteger.valueOf(value);
    }

    public static final BigInteger bigInt(long value) {
        return BigInteger.valueOf(value);
    }

    public static final BigDecimal bigDec(long value) {
        return BigDecimal.valueOf(value);
    }

    public static final BigDecimal bigDec(double value) {
        return BigDecimal.valueOf(value);
    }

    public static final Random random() {
        return RANDOM;
    }

    public static final int random(int n) {
        return RANDOM.nextInt(n);
    }

    public static int even(int value) {
        if ((value & 1) != 0) {
            throw new IllegalArgumentException("Not an even number: " + value);
        }
        return value;
    }

    public static long even(long value) {
        if ((value & 1L) != 0L) {
            throw new IllegalArgumentException("Not an even number: " + value);
        }
        return value;
    }

    public static int odd(int value) {
        if ((value & 1) != 1) {
            throw new IllegalArgumentException("Not an odd number: " + value);
        }
        return value;
    }

    public static long odd(long value) {
        if ((value & 1L) != 1L) {
            throw new IllegalArgumentException("Not an odd number: " + value);
        }
        return value;
    }

    public static int positive(int value) throws NumberRangeException {
        if (value > 0) {
            return value;
        }
        throw new NumberRangeException("Value is not positive: " + value);
    }

    public static int notNegative(int value) throws NumberRangeException {
        if (value < 0) {
            throw new NumberRangeException("Value is negative: " + value);
        }
        return value;
    }

    public static Integer notNegative(Integer value) throws NumberRangeException {
        if (value != null && value < 0) {
            throw new NumberRangeException("Value is negative: " + value);
        }
        return value;
    }

    public static int negative(int value) throws NumberRangeException {
        if (value < 0) {
            return value;
        }
        throw new NumberRangeException("Value is not negative: " + value);
    }

    public static long positive(long value) throws NumberRangeException {
        if (value > 0L) {
            return value;
        }
        throw new NumberRangeException("Value is not positive: " + value);
    }

    public static long notNegative(long value) throws NumberRangeException {
        if (value < 0L) {
            throw new NumberRangeException("Value is negative: " + value);
        }
        return value;
    }

    public static Long notNegative(Long value) throws NumberRangeException {
        if (value != null && value < 0L) {
            throw new NumberRangeException("Value is negative: " + value);
        }
        return value;
    }

    public static long negative(long value) throws NumberRangeException {
        if (value < 0L) {
            return value;
        }
        throw new NumberRangeException("Value is not negative: " + value);
    }

    public static double positive(double value) throws NumberRangeException {
        if (value > 0.0) {
            return value;
        }
        throw new NumberRangeException("Value is not positive: " + value);
    }

    public static double notNegative(double value) throws NumberRangeException {
        if (value < 0.0) {
            throw new NumberRangeException("Value is negative: " + value);
        }
        return value;
    }

    public static double positiveMax1(double value) throws NumberRangeException {
        if (value <= 1.0) {
            return XMath.positive(value);
        }
        throw new NumberRangeException("Value is bigger than 1: " + value);
    }

    public static double notNegativeMax1(double value) throws NumberRangeException {
        if (value <= 1.0) {
            return XMath.notNegative(value);
        }
        throw new NumberRangeException("Value is bigger than 1: " + value);
    }

    public static float positive(float value) throws NumberRangeException {
        if (value > 0.0f) {
            return value;
        }
        throw new NumberRangeException("Value is not positive: " + value);
    }

    public static long equal(long value1, long value2) throws IllegalArgumentException {
        if (value1 == value2) {
            return value1;
        }
        throw new IllegalArgumentException("Unequal values: " + value1 + " != " + value2);
    }

    public static double[] column(int columnIndex, double[] ... matrix) {
        int rowCount = matrix.length;
        double[] column = new double[rowCount];
        int r = rowCount;
        while (r-- > 0) {
            column[r] = matrix[r][columnIndex];
        }
        return column;
    }

    public static final int cap_int(long value) {
        return value >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)value;
    }

    public static final boolean isGreaterThanOrEqualHighestPowerOf2(long value) {
        return value >= 0x40000000L;
    }

    public static final boolean isGreaterThanHighestPowerOf2(long value) {
        return value > 0x40000000L;
    }

    public static final boolean isGreaterThanOrEqualHighestPowerOf2(int value) {
        return value >= 0x40000000;
    }

    public static final boolean isGreaterThanHighestPowerOf2(int value) {
        return value > 0x40000000;
    }

    public static final int highestPowerOf2_int() {
        return 0x40000000;
    }

    public static final double fractionToPercent(double decimalFractionValue) {
        return decimalFractionValue * 100.0;
    }

    public static final double percentToFraction(double decimalPercentValue) {
        return decimalPercentValue / 100.0;
    }

    public static final boolean isIn(int value, int ... searchValues) {
        if (searchValues == null) {
            return false;
        }
        int[] nArray = searchValues;
        int n = searchValues.length;
        int n2 = 0;
        while (n2 < n) {
            int s = nArray[n2];
            if (value == s) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static long addCapped(long l1, long l2) {
        return Long.MAX_VALUE - l1 < l2 ? Long.MAX_VALUE : l1 + l2;
    }

    public static <E> Double minDouble(Iterable<E> elements, To_double<? super E> getter) {
        double minimum = XMath.min_double(elements, getter);
        return Double.isNaN(minimum) ? null : Double.valueOf(minimum);
    }

    public static <E> double min_double(Iterable<E> elements, To_double<? super E> getter) {
        return XMath.min_double(elements, getter, Double.NaN);
    }

    public static <E> double min_double(Iterable<E> elements, To_double<? super E> getter, double defaultValue) {
        Iterator<E> iterator = elements.iterator();
        if (!iterator.hasNext()) {
            return defaultValue;
        }
        double minimum = Double.MAX_VALUE;
        while (iterator.hasNext()) {
            double value = getter.apply(iterator.next());
            if (!(value < minimum)) continue;
            minimum = value;
        }
        return minimum;
    }

    public static boolean isMathematicalInteger(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value) && value == Math.rint(value);
    }

    private XMath() {
        throw new UnsupportedOperationException();
    }
}

