/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.memory;

import one.microstream.memory.MemoryStatistics;
import one.microstream.memory.XMemory;

public interface MemoryStatisticsProvider {
    public MemoryStatistics heapMemoryUsage();

    public MemoryStatistics nonHeapMemoryUsage();

    public static MemoryStatisticsProvider set(MemoryStatisticsProvider memoryStatisticsProvider) {
        return Static.set(memoryStatisticsProvider);
    }

    public static MemoryStatisticsProvider get() {
        return Static.get();
    }

    public static MemoryStatisticsProvider New(long updateInterval) {
        return new Default(updateInterval);
    }

    public static class Default
    implements MemoryStatisticsProvider {
        private final long updateInterval;
        private final Object heapMemoryLock = new Object();
        private MemoryStatistics heapMemoryUsage;
        private long heapMemoryUsageTimestamp;
        private final Object nonHeapMemoryLock = new Object();
        private MemoryStatistics nonHeapMemoryUsage;
        private long nonHeapMemoryUsageTimestamp;

        Default(long updateInterval) {
            this.updateInterval = updateInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MemoryStatistics heapMemoryUsage() {
            long now = System.currentTimeMillis();
            Object object = this.heapMemoryLock;
            synchronized (object) {
                if (this.heapMemoryUsage == null || now - this.updateInterval >= this.heapMemoryUsageTimestamp) {
                    this.heapMemoryUsageTimestamp = now;
                    this.heapMemoryUsage = XMemory.memoryAccessor().createHeapMemoryStatistics();
                }
                return this.heapMemoryUsage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public MemoryStatistics nonHeapMemoryUsage() {
            long now = System.currentTimeMillis();
            Object object = this.nonHeapMemoryLock;
            synchronized (object) {
                if (this.nonHeapMemoryUsage == null || now - this.updateInterval >= this.nonHeapMemoryUsageTimestamp) {
                    this.nonHeapMemoryUsageTimestamp = now;
                    this.nonHeapMemoryUsage = XMemory.memoryAccessor().createNonHeapMemoryStatistics();
                }
                return this.nonHeapMemoryUsage;
            }
        }
    }

    public static final class Static {
        static MemoryStatisticsProvider globalMemoryStatisticsProvider = MemoryStatisticsProvider.New(Static.defaultUpdateInterval());

        public static final long defaultUpdateInterval() {
            return 1000L;
        }

        static synchronized MemoryStatisticsProvider set(MemoryStatisticsProvider memoryStatisticsProvider) {
            MemoryStatisticsProvider old = globalMemoryStatisticsProvider;
            globalMemoryStatisticsProvider = memoryStatisticsProvider;
            return old;
        }

        static synchronized MemoryStatisticsProvider get() {
            return globalMemoryStatisticsProvider;
        }

        private Static() {
            throw new UnsupportedOperationException();
        }
    }
}

