/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.reflect;

import one.microstream.X;

@FunctionalInterface
public interface ClassLoaderProvider {
    public ClassLoader provideClassLoader(String var1);

    public static ClassLoader systemClassLoader() {
        return ClassLoader.getSystemClassLoader();
    }

    public static ClassLoaderProvider New(ClassLoader classLoader) {
        return new Default(X.notNull(classLoader));
    }

    public static ClassLoaderProvider System() {
        return new System();
    }

    public static final class Default
    implements ClassLoaderProvider {
        private final ClassLoader subject;

        Default(ClassLoader subject) {
            this.subject = subject;
        }

        @Override
        public ClassLoader provideClassLoader(String typeName) {
            return this.subject;
        }
    }

    public static final class System
    implements ClassLoaderProvider {
        System() {
        }

        @Override
        public ClassLoader provideClassLoader(String typeName) {
            return ClassLoaderProvider.systemClassLoader();
        }
    }
}

