/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util;

import one.microstream.math.XMath;
import one.microstream.memory.XMemory;
import one.microstream.typing.Immutable;
import one.microstream.typing.Stateless;
import one.microstream.util.BufferSizeProviderIncremental;

public interface BufferSizeProvider {
    default public long provideBufferSize() {
        return XMemory.defaultBufferSize();
    }

    public static BufferSizeProvider New() {
        return new Default();
    }

    public static BufferSizeProvider New(long bufferSize) {
        return new Sized(XMath.positive(bufferSize));
    }

    public static final class Default
    implements BufferSizeProvider,
    Stateless {
        Default() {
        }
    }

    public static final class Sized
    implements BufferSizeProviderIncremental,
    Immutable {
        private final long bufferSize;

        Sized(long bufferSize) {
            this.bufferSize = bufferSize;
        }

        @Override
        public final long provideBufferSize() {
            return this.bufferSize;
        }

        @Override
        public final long provideIncrementalBufferSize() {
            return this.bufferSize;
        }
    }
}

