/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util;

public interface Flag {
    public boolean set(boolean var1);

    public boolean on();

    public boolean off();

    public boolean isOn();

    public boolean isOff();

    public boolean toggle();

    public static Flag New() {
        return Flag.New(false);
    }

    public static Flag New(boolean state) {
        return new Simple(state);
    }

    public static final class Simple
    implements Flag {
        private boolean state;

        Simple(boolean state) {
            this.state = state;
        }

        @Override
        public final boolean set(boolean state) {
            if (state) {
                this.on();
                return false;
            }
            this.off();
            return true;
        }

        @Override
        public final boolean isOn() {
            return this.state;
        }

        @Override
        public final boolean isOff() {
            return !this.state;
        }

        @Override
        public final boolean on() {
            boolean current = this.state;
            this.state = true;
            return current;
        }

        @Override
        public final boolean off() {
            boolean current = this.state;
            this.state = false;
            return current;
        }

        @Override
        public final boolean toggle() {
            this.state = !this.state;
            return !this.state;
        }
    }
}

