/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.logging;

import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.collections.EqHashTable;
import one.microstream.math.XMath;
import one.microstream.typing.KeyValue;
import one.microstream.util.BundleInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Logging {
    private static final EqHashTable<Object, Function<Object, String>> toStringConverters = EqHashTable.New();

    static {
        try {
            Logging.getLogger(Logging.class).info("MicroStream Version {}", (Object)BundleInfo.LoadBase().version());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Logger getLogger(Class<?> clazz) {
        return LoggerFactory.getLogger(clazz);
    }

    private static Function<Object, String> DefaultToStringConverter() {
        return obj -> "";
    }

    public static Function<Object, String> getToStringConverter(Object context) {
        Function<Object, String> function = toStringConverters.get(context);
        return function != null ? function : Logging.DefaultToStringConverter();
    }

    public static Function<Object, String> setToStringConverter(Object context, Function<Object, String> converter) {
        KeyValue<Object, Function<Object, String>> old = toStringConverters.putGet(X.notNull(context), X.notNull(converter));
        return old != null ? old.value() : null;
    }

    public static final Object LazyArgInContext(Object context, Object argument) {
        return Logging.LazyArgInContext(context, () -> argument);
    }

    public static final Object LazyArgInContext(final Object context, final Supplier<?> supplier) {
        X.notNull(context);
        X.notNull(supplier);
        return new Object(){

            public String toString() {
                return Logging.getToStringConverter(context).apply(supplier.get());
            }
        };
    }

    public static final Object LazyArg(Object argument) {
        return Logging.LazyArg(() -> argument);
    }

    public static final Object LazyArg(final Supplier<?> supplier) {
        X.notNull(supplier);
        return new Object(){

            public String toString() {
                return String.valueOf(supplier.get());
            }
        };
    }

    public static Function<Object, String> LimitedElementsToStringConverter(int limit) {
        return Logging.LimitedElementsToStringConverter(limit, String::valueOf);
    }

    public static Function<Object, String> LimitedElementsToStringConverter(int limit, Function<Object, String> toStringConverter) {
        return Logging.LimitedElementsToStringConverter(obj -> limit, toStringConverter);
    }

    public static Function<Object, String> LimitedElementsToStringConverter(ToIntFunction<Object> limitProvider, Function<Object, String> toStringConverter) {
        return new LimitedElementsToStringConverter(X.notNull(limitProvider), X.notNull(toStringConverter));
    }

    private Logging() {
        throw new UnsupportedOperationException();
    }

    private static class LimitedElementsToStringConverter
    implements Function<Object, String> {
        private final ToIntFunction<Object> limitProvider;
        private final Function<Object, String> toStringConverter;

        LimitedElementsToStringConverter(ToIntFunction<Object> limitProvider, Function<Object, String> toStringConverter) {
            this.limitProvider = limitProvider;
            this.toStringConverter = toStringConverter;
        }

        @Override
        public String apply(Object obj) {
            if (obj instanceof Iterable) {
                int limit = this.limitProvider.applyAsInt(obj);
                return this.toString((Iterable)obj, limit);
            }
            if (obj != null && obj.getClass().isArray()) {
                int limit = this.limitProvider.applyAsInt(obj);
                return this.toString(X.Iterable(obj), limit);
            }
            return this.toStringConverter.apply(obj);
        }

        private String toString(Iterable<?> iterable, int limit) {
            XMath.positive(limit);
            VarString vs = VarString.New().add('[');
            Iterator<?> iterator = iterable.iterator();
            int position = 0;
            while (position < limit && iterator.hasNext()) {
                if (position > 0) {
                    vs.add(", ");
                }
                vs.add(this.apply(iterator.next()));
                ++position;
            }
            if (iterator.hasNext()) {
                vs.add(", ...");
            }
            return vs.add(']').toString();
        }
    }
}

