/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.similarity;

@FunctionalInterface
public interface Similator<T> {
    public double evaluate(T var1, T var2);

    public static interface Provider<T> {
        public Similator<T> provideSimilator();
    }

    public static final class Sequence<T>
    implements Similator<T> {
        private final Similator<? super T>[] similators;

        @SafeVarargs
        public Sequence(Similator<? super T> ... similators) {
            this.similators = similators;
        }

        @Override
        public double evaluate(T o1, T o2) {
            double result = 0.0;
            int i = 0;
            while (i < this.similators.length) {
                result += this.similators[i].evaluate(o1, o2);
                ++i;
            }
            return result / (double)this.similators.length;
        }
    }
}

