/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.traversing;

import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.util.traversing.TraversalHandler;

public interface TraversalMutator
extends TraversalHandler {
    public Object mutateReference(Object var1, Object var2);

    public static TraversalMutator New(Function<Object, ?> logic) {
        return new Default(logic);
    }

    public static TraversalMutator New(Predicate<Object> condition, Function<Object, ?> logic) {
        return new Conditional(condition, logic);
    }

    public static final class Conditional
    implements TraversalMutator {
        private final Predicate<Object> condition;
        private final Function<Object, ?> logic;

        Conditional(Predicate<Object> condition, Function<Object, ?> logic) {
            this.condition = condition;
            this.logic = logic;
        }

        @Override
        public final Object mutateReference(Object instance, Object parent) {
            if (this.condition.test(instance)) {
                return this.logic.apply(instance);
            }
            return instance;
        }
    }

    public static final class Default
    implements TraversalMutator {
        private final Function<Object, ?> logic;

        Default(Function<Object, ?> logic) {
            this.logic = logic;
        }

        @Override
        public final Object mutateReference(Object instance, Object parent) {
            return this.logic.apply(instance);
        }
    }
}

