/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

import one.microstream.chars.CharConversionIntegers;
import one.microstream.chars.XChars;

public final class CharConversion_double {
    private static final double DOUBLE_NORMALIZATION_THRESHOLD_HIGH = 1.0E7;
    private static final double DOUBLE_NORMALIZATION_THRESHOLD_LOW = 0.001;
    private static final double DOUBLE_ONE = 1.0;
    private static final double DOUBLE_ZERO = 0.0;
    private static final double DOUBLE_E100 = 1.0E100;
    private static final double DOUBLE_E10 = 1.0E10;
    private static final double DOUBLE_LAST_DIGIT0 = 1.0E-19;
    private static final double DOUBLE_LAST_DIGIT1 = 1.0E-18;
    private static final double DOUBLE_LAST_DIGIT2 = 1.0E-17;
    private static final int DOUBLE_DIGITS_MAX = 17;
    private static final int DOUBLE_DIGITS_BOUND = 16;

    public static final int put(double value, char[] target, int offset) {
        if (Double.isNaN(value)) {
            return XChars.put(XChars.CHARS_NAN, target, offset);
        }
        if (value < 0.0) {
            if (value == Double.NEGATIVE_INFINITY) {
                return XChars.put(XChars.CHARS_NEGATIVE_INFINITY, target, offset);
            }
            target[offset] = 45;
            return CharConversion_double.put_doublePositive(-value, target, offset + 1);
        }
        if (value == 0.0) {
            return XChars.put(XChars.CHARS_ZERO, target, offset);
        }
        if (value == 1.0) {
            return XChars.put(XChars.CHARS_ONE, target, offset);
        }
        if (value == Double.POSITIVE_INFINITY) {
            return XChars.put(XChars.CHARS_POSITIVE_INFINITY, target, offset);
        }
        return CharConversion_double.put_doublePositive(value, target, offset);
    }

    private static int put_doublePositive(double value, char[] target, int offset) {
        return value < 1.0 ? CharConversion_double.put_doubleLt1(value, target, offset) : CharConversion_double.put_doubleGte1(value, target, offset);
    }

    private static int put_doubleLt1(double value, char[] target, int offset) {
        return value < 0.001 ? CharConversion_double.put_doubleLt1Normalized(value, target, offset) : CharConversion_double.put_doubleLt1Denormalized(value, target, offset);
    }

    private static int put_doubleGte1(double value, char[] target, int offset) {
        return value < 1.0E7 ? CharConversion_double.put_doubleGte1Denormalized(value, target, offset) : CharConversion_double.put_doubleGte1Normalized(value, target, offset);
    }

    private static int put_doubleGte1Denormalized(double value, char[] target, int offset) {
        int exponent = CharConversion_double.exponent(value);
        target[offset] = 48;
        int i = CharConversion_double.put_doubleAndCleanup(value * CharConversion_double.pow10(16 - exponent), target, offset + 1);
        if (target[offset] != '0') {
            return CharConversion_double.handle_doubleGte1DenormSpecialCase(target, offset, exponent);
        }
        System.arraycopy(target, offset + 1, target, offset, exponent + 1);
        target[offset + exponent + 1] = 46;
        return Math.max(i, offset + exponent + 3);
    }

    private static int handle_doubleGte1DenormSpecialCase(char[] target, int offset, int exponent) {
        if (exponent == 7) {
            System.arraycopy(XChars.CHARS_NORM_THRESH_HIGH, 0, target, offset, XChars.CHARS_NORM_THRESH_HIGH.length);
            return offset + XChars.CHARS_NORM_THRESH_HIGH.length;
        }
        int e = Math.max(exponent, 1) + 1;
        int i = 1;
        while (i <= e) {
            target[offset + i] = 48;
            ++i;
        }
        target[offset + e] = 46;
        target[offset + e + 1] = 48;
        return offset + e + 2;
    }

    private static int put_doubleGte1Normalized(double value, char[] target, int offset) {
        int exponent = CharConversion_double.exponent(value);
        double intedValue = value * (exponent < 17 ? CharConversion_double.pow10(16 - exponent) : CharConversion_double.root10(16 - exponent));
        if (intedValue == Double.POSITIVE_INFINITY || intedValue == Double.NEGATIVE_INFINITY) {
            return XChars.put(Double.toString(value), target, offset);
        }
        target[offset] = 48;
        int i = CharConversion_double.put_doubleAndCleanup(intedValue, target, offset + 1);
        if (target[offset] != '0') {
            target[offset + 1] = 46;
            target[offset + 2] = 48;
            i = offset + 3;
        } else {
            target[offset] = target[offset + 1];
            target[offset + 1] = 46;
            if (i == offset + 2) {
                ++i;
            }
        }
        target[i] = 69;
        return CharConversionIntegers.put_int3(exponent, target, i + 1);
    }

    private static int put_doubleLt1Denormalized(double value, char[] target, int offset) {
        target[offset + 1] = 48;
        int i = CharConversion_double.put_doubleLt1DenormAndCleanup(value, target, offset);
        target[offset] = target[offset + 1];
        target[offset + 1] = 46;
        if (i == offset + 2) {
            target[i++] = 48;
        }
        return i;
    }

    private static int put_doubleLt1DenormAndCleanup(double value, char[] target, int offset) {
        switch (CharConversion_double.exponent(value)) {
            case -3: {
                target[offset + 2] = 48;
                target[offset + 3] = 48;
                return CharConversion_double.put_doubleAndCleanup(value / 1.0E-19, target, offset + 4);
            }
            case -2: {
                target[offset + 2] = 48;
                return CharConversion_double.put_doubleAndCleanup(value / 1.0E-18, target, offset + 3);
            }
        }
        return CharConversion_double.put_doubleAndCleanup(value / 1.0E-17, target, offset + 2);
    }

    private static int put_doubleLt1Normalized(double value, char[] target, int offset) {
        int exponent = CharConversion_double.exponent(value);
        double intedValue = value * CharConversion_double.pow10(16 - exponent);
        if (intedValue == Double.POSITIVE_INFINITY || intedValue == Double.NEGATIVE_INFINITY) {
            return XChars.put(Double.toString(value), target, offset);
        }
        int i = CharConversion_double.put_doubleAndCleanup(intedValue, target, offset + 1);
        target[offset] = target[offset + 1];
        target[offset + 1] = 46;
        if (i == offset + 2) {
            target[i++] = 48;
        }
        target[i] = 69;
        target[i + 1] = 45;
        return CharConversionIntegers.put_int3(-exponent, target, i + 2);
    }

    private static int exponent(double value) {
        return (int)Math.floor(Math.log10(value));
    }

    private static double pow10(int exponent) {
        double result = 1.0;
        int e = exponent;
        while (e >= 100) {
            e -= 100;
            result *= 1.0E100;
        }
        while (e >= 10) {
            e -= 10;
            result *= 1.0E10;
        }
        while (e-- > 0) {
            result *= 10.0;
        }
        return result;
    }

    private static double root10(int exponent) {
        double result = 1.0;
        int e = exponent;
        while (e < -99) {
            e += 100;
            result /= 1.0E100;
        }
        while (e < -9) {
            e += 10;
            result /= 1.0E10;
        }
        while (e++ <= 0) {
            result /= 10.0;
        }
        return result;
    }

    private static int put_doubleAndCleanup(double value, char[] target, int offset) {
        return CharConversion_double.cleanupDecimal(target, offset, CharConversionIntegers.put_longPositive((long)value, target, offset));
    }

    private static int cleanupDecimal(char[] buffer, int offset, int i) {
        switch (i - offset) {
            case 17: {
                return CharConversion_double.removeTrailingLast(buffer, i - 1);
            }
            case 16: {
                return CharConversion_double.removeTrailingPreLast(buffer, i - 1);
            }
        }
        return buffer[i - 1] == '9' ? CharConversion_double.removeTrailingNinesSimple(buffer, i - 1) : CharConversion_double.removeTrailingZerosSimple(buffer, i - 1);
    }

    private static int removeTrailingZerosSimple(char[] target, int offset) {
        while (target[offset] == '0') {
            --offset;
        }
        return offset + 1;
    }

    private static int removeTrailingLast(char[] target, int offset) {
        if (target[offset - 3] == '9' && target[offset - 2] == '9' && target[offset - 1] >= '7') {
            return CharConversion_double.removeTrailingNinesSimple(target, offset - 3);
        }
        if (target[offset - 3] == '0' && target[offset - 2] == '0' && target[offset - 1] <= '2') {
            return CharConversion_double.removeTrailingZerosSimple(target, offset - 3);
        }
        if (target[offset - 2] == '9' && target[offset - 1] >= '8') {
            return CharConversion_double.removeTrailingNinesSimple(target, offset - 2);
        }
        if (target[offset - 2] == '0' && target[offset - 1] <= '1') {
            return CharConversion_double.removeTrailingZerosSimple(target, offset - 2);
        }
        if (target[offset - 1] == '9' && target[offset] >= '5') {
            int n = offset - 2;
            target[n] = (char)(target[n] + '\u0001');
            return offset - 1;
        }
        if (target[offset - 1] == '0' && target[offset] < '5') {
            return offset - 1;
        }
        if (target[offset] >= '5') {
            int n = offset - 1;
            target[n] = (char)(target[n] + '\u0001');
            return offset;
        }
        return offset;
    }

    private static int removeTrailingPreLast(char[] target, int offset) {
        if (target[offset - 2] == '9' && target[offset - 1] == '9' && target[offset - 1] >= '7') {
            return CharConversion_double.removeTrailingNinesSimple(target, offset - 2);
        }
        if (target[offset - 2] == '0' && target[offset - 1] == '0' && target[offset] <= '2') {
            return CharConversion_double.removeTrailingZerosSimple(target, offset - 2);
        }
        if (target[offset - 1] == '9' && target[offset] >= '8') {
            return CharConversion_double.removeTrailingNinesSimple(target, offset - 1);
        }
        if (target[offset - 1] == '0' && target[offset] <= '1') {
            return CharConversion_double.removeTrailingZerosSimple(target, offset - 1);
        }
        if (target[offset] >= '8') {
            int n = offset - 1;
            target[n] = (char)(target[n] + '\u0001');
            return offset;
        }
        if (target[offset] <= '1') {
            return offset;
        }
        return offset + 1;
    }

    private static int removeTrailingNinesSimple(char[] target, int offset) {
        while (target[offset] == '9') {
            --offset;
        }
        int n = offset;
        target[n] = (char)(target[n] + '\u0001');
        return offset + 1;
    }

    private CharConversion_double() {
        throw new UnsupportedOperationException();
    }
}

