/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.branching.ThrowBreak;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.collections.AbstractChainCollection;
import one.microstream.collections.AbstractChainEntry;
import one.microstream.collections.AbstractChainStorage;
import one.microstream.collections.AbstractSimpleArrayCollection;
import one.microstream.collections.CachedSampleEquality;
import one.microstream.collections.ElementIsContained;
import one.microstream.collections.XArrays;
import one.microstream.collections.XSort;
import one.microstream.collections.interfaces.ChainStorage;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.equality.Equalator;
import one.microstream.functional.Aggregator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.reference.ReferenceType;
import one.microstream.typing.XTypes;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ChainStorageStrong<E, K, V, EN extends AbstractChainEntry<E, K, V, EN>>
extends AbstractChainStorage<E, K, V, EN> {
    final AbstractChainCollection<E, K, V, EN> parent;
    final EN head;

    static final String exceptionRange(long size, long offset, long length) {
        return "Range [" + (length < 0L ? String.valueOf(offset + length + 1L) + ";" + offset : String.valueOf(offset) + ";" + (offset + length - 1L)) + "] not in [0;" + (size - 1L) + "]";
    }

    static final String exceptionIndexOutOfBounds(long size, long index) {
        return "Index: " + index + ", Size: " + size;
    }

    static final String exceptionIllegalSwapBounds(long indexA, long indexB, long length) {
        return "Illegal swap bounds: (" + indexA + " [" + length + "] -> " + indexB + " [" + length + "])";
    }

    static final int validateArrayIteration(Object[] array, int offset, int length) {
        if (length >= 0) {
            if (offset < 0 || offset + length > array.length) {
                throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionRange(array.length, offset, length));
            }
            if (length == 0) {
                return 0;
            }
            return 1;
        }
        if (length < 0) {
            if (offset + length < -1 || offset >= array.length) {
                throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionRange(array.length, offset, length));
            }
            return -1;
        }
        if (offset < 0 || offset >= array.length) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(array.length, offset));
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    static <E, K, V, EN extends AbstractChainEntry<E, K, V, EN>> void mergesortHead(EN head, Comparator<? super E> comparator) {
        block4: {
            try {
                entry = ChainStorageStrong.mergesort0(head.next, comparator);
                break block4;
            }
            catch (Throwable e) {
                entry = head.prev;
                if (true) ** GOTO lbl9
            }
            do {
                entry.next = last;
lbl9:
                // 2 sources

                last = entry;
            } while ((entry = last.prev) != head);
            throw e;
        }
        head.next = entry;
        entry.prev = head;
        if (true) ** GOTO lbl18
        do {
            entry.prev = last;
lbl18:
            // 2 sources

            last = entry;
        } while ((entry = last.next) != null);
        head.prev = last;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    private static <E, K, V, EN extends AbstractChainEntry<E, K, V, EN>> EN mergesort0(EN chain, Comparator<? super E> comparator) {
        Object chain2;
        if (chain == null || chain.next == null) {
            return chain;
        }
        EN t1 = chain;
        Object t2 = chain2 = t1.next;
        if (true) {
            return ChainStorageStrong.merge1(ChainStorageStrong.mergesort0(chain, comparator), ChainStorageStrong.mergesort0(chain2, comparator), comparator);
        }
        do {
            t2 = ((AbstractChainEntry)t2).next = t1.next;
            if (t2 == null) return ChainStorageStrong.merge1(ChainStorageStrong.mergesort0(chain, comparator), ChainStorageStrong.mergesort0(chain2, comparator), comparator);
            t1.next = ((AbstractChainEntry)t2).next;
            t1 = t1.next;
        } while (t1.next != null);
        return ChainStorageStrong.merge1(ChainStorageStrong.mergesort0(chain, comparator), ChainStorageStrong.mergesort0(chain2, comparator), comparator);
    }

    private static <E, K, V, EN extends AbstractChainEntry<E, K, V, EN>> EN merge1(EN c1, EN c2, Comparator<? super E> cmp) {
        EN c;
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        if (cmp.compare(c1.element(), c2.element()) < 0) {
            c = c1;
            c1 = c.next;
        } else {
            c = c2;
            c2 = c.next;
        }
        EN t = c;
        while (true) {
            if (c1 == null) {
                t.next = c2;
                break;
            }
            if (c2 == null) {
                t.next = c1;
                break;
            }
            if (cmp.compare(c1.element(), c2.element()) < 0) {
                t.next = c1;
                t = t.next;
                c1 = ((AbstractChainEntry)t.next).next;
                continue;
            }
            t.next = c2;
            t = t.next;
            c2 = ((AbstractChainEntry)t.next).next;
        }
        return c;
    }

    public ChainStorageStrong(AbstractChainCollection<E, K, V, EN> parent, EN head) {
        this.parent = parent;
        this.head = head;
        ((AbstractChainEntry)head).prev = head;
    }

    @Override
    protected final EN head() {
        return this.head;
    }

    @Override
    protected void disjoinEntry(EN entry) {
        ((AbstractChainEntry)(((AbstractChainEntry)entry).next == null ? this.head : ((AbstractChainEntry)entry).next)).prev = ((AbstractChainEntry)entry).prev;
        ((AbstractChainEntry)((AbstractChainEntry)entry).prev).next = ((AbstractChainEntry)entry).next;
    }

    @Override
    protected void replace(EN doomedEntry, EN keptEntry) {
        ((AbstractChainEntry)(((AbstractChainEntry)doomedEntry).next == null ? this.head : ((AbstractChainEntry)doomedEntry).next)).prev = keptEntry;
        ((AbstractChainEntry)((AbstractChainEntry)doomedEntry).prev).next = keptEntry;
        ((AbstractChainEntry)keptEntry).prev = ((AbstractChainEntry)doomedEntry).prev;
        ((AbstractChainEntry)keptEntry).next = ((AbstractChainEntry)doomedEntry).next;
    }

    @Override
    protected long substitute(Function<? super E, ? extends E> mapper, BiConsumer<EN, E> callback) {
        long count = 0L;
        try {
            EN entry = this.head;
            while ((entry = ((AbstractChainEntry)entry).next) != null) {
                E newElement = mapper.apply(((AbstractChainEntry)entry).element());
                if (newElement == ((AbstractChainEntry)entry).element()) continue;
                callback.accept(entry, newElement);
                ++count;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    @Override
    protected final boolean moveToStart(EN entry) {
        if (((AbstractChainEntry)entry).prev == this.head) {
            return false;
        }
        if (((AbstractChainEntry)entry).next == null) {
            ((AbstractChainEntry)this.head).prev = ((AbstractChainEntry)entry).prev;
            ((AbstractChainEntry)((AbstractChainEntry)entry).prev).next = null;
        } else {
            ((AbstractChainEntry)((AbstractChainEntry)entry).prev).next = ((AbstractChainEntry)entry).next;
            ((AbstractChainEntry)((AbstractChainEntry)entry).next).prev = ((AbstractChainEntry)entry).prev;
        }
        ((AbstractChainEntry)entry).next = ((AbstractChainEntry)this.head).next;
        ((AbstractChainEntry)entry).prev = this.head;
        ((AbstractChainEntry)this.head).next = entry;
        return true;
    }

    @Override
    protected final boolean moveToEnd(EN entry) {
        if (((AbstractChainEntry)entry).next == null) {
            return false;
        }
        ((AbstractChainEntry)((AbstractChainEntry)entry).prev).next = ((AbstractChainEntry)entry).next;
        ((AbstractChainEntry)((AbstractChainEntry)entry).next).prev = ((AbstractChainEntry)entry).prev;
        ((AbstractChainEntry)entry).prev = ((AbstractChainEntry)this.head).prev;
        ((AbstractChainEntry)this.head).prev = entry;
        ((AbstractChainEntry)((AbstractChainEntry)this.head).prev).next = ((AbstractChainEntry)this.head).prev;
        ((AbstractChainEntry)entry).next = null;
        return true;
    }

    @Override
    public final void appendEntry(EN entry) {
        ((AbstractChainEntry)entry).prev = ((AbstractChainEntry)this.head).prev;
        ((AbstractChainEntry)this.head).prev = entry;
        ((AbstractChainEntry)((AbstractChainEntry)this.head).prev).next = ((AbstractChainEntry)this.head).prev;
    }

    @Override
    public final void prependEntry(EN entry) {
        ((AbstractChainEntry)entry).next = ((AbstractChainEntry)this.head).next;
        ((AbstractChainEntry)entry).prev = this.head;
        ((AbstractChainEntry)this.head).next = entry;
    }

    @Override
    public void clear() {
        ((AbstractChainEntry)this.head).prev = this.head;
        ((AbstractChainEntry)this.head).next = null;
    }

    @Override
    public final void shiftBy(long sourceIndex, long distance) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void shiftBy(long sourceIndex, long distance, long length) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void shiftTo(long sourceIndex, long targetIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final void shiftTo(long sourceIndex, long targetIndex, long length) {
        throw new NotImplementedYetError();
    }

    private void swapEntries(EN entryA, EN entryB) {
        Object temp;
        ((AbstractChainEntry)((temp = ((AbstractChainEntry)entryA).next) != null ? temp : this.head)).prev = entryB;
        ((AbstractChainEntry)entryA).next = ((AbstractChainEntry)entryB).next;
        ((AbstractChainEntry)(((AbstractChainEntry)entryA).next != null ? ((AbstractChainEntry)entryB).next : this.head)).prev = entryA;
        ((AbstractChainEntry)entryB).next = temp;
        temp = ((AbstractChainEntry)entryA).prev;
        ((AbstractChainEntry)((AbstractChainEntry)entryA).prev).next = entryB;
        ((AbstractChainEntry)((AbstractChainEntry)entryB).prev).next = entryA;
        ((AbstractChainEntry)entryA).prev = ((AbstractChainEntry)entryB).prev;
        ((AbstractChainEntry)entryB).prev = temp;
    }

    @Override
    public final void removeRange(long offset, long length) {
        ChainStorage.Entry e;
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        if (length > 0L) {
            e = this.getRangeChainEntry(offset + length, -length);
        } else {
            e = this.getRangeChainEntry(offset, length);
            length = -length;
        }
        while (length-- > 0L) {
            ((AbstractChainEntry)e).removeFrom(parent);
            e = ((AbstractChainEntry)e).prev;
        }
    }

    @Override
    public final void retainRange(long offset, long length) {
        throw new NotImplementedYetError();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final long removeSelection(long ... indices) {
        s = this.parent.size() - 1L;
        XSort.sort(indices);
        if (indices[0] < 0L) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(s + 1L, indices[0]));
        }
        if (indices[indices.length - 1] > s) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(s + 1L, indices[indices.length - 1]));
        }
        e = this.head.prev;
        removeCount = 0L;
        lastIdx = -1L;
        parent = this.parent;
        i = indices.length - 1;
        while (i > 0) {
            block4: {
                idx = indices[i];
                if (idx != -1L) ** GOTO lbl17
                break block4;
lbl-1000:
                // 1 sources

                {
                    e = e.prev;
lbl17:
                    // 2 sources

                    ** while (--s > idx)
                }
lbl18:
                // 1 sources

                e.removeFrom(parent);
                ++removeCount;
            }
            --i;
        }
        return removeCount;
    }

    @Override
    public final Iterator<E> iterator() {
        return new KeyItr();
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> other, final Equalator<? super E> equalator) {
        if (this.parent.size() != other.size()) {
            return false;
        }
        if (other instanceof AbstractSimpleArrayCollection) {
            long otherSize = other.size();
            E[] otherData = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)other));
            Object entry = ((AbstractChainEntry)this.head).next;
            int i = 0;
            while ((long)i < otherSize) {
                if (!equalator.equal(((AbstractChainEntry)entry).element(), otherData[i])) {
                    return false;
                }
                ++i;
                entry = ((AbstractChainEntry)entry).next;
            }
            return true;
        }
        Aggregator agg = new Aggregator<E, Boolean>(){
            private EN entry;
            private boolean notEqual;
            {
                this.entry = ChainStorageStrong.this.head;
            }

            @Override
            public final void accept(E element) {
                this.entry = ((AbstractChainEntry)this.entry).next;
                if (this.entry == null) {
                    this.notEqual = true;
                    throw X.BREAK();
                }
                if (!equalator.equal(element, ((AbstractChainEntry)this.entry).element())) {
                    this.notEqual = true;
                    throw X.BREAK();
                }
            }

            @Override
            public final Boolean yield() {
                return this.notEqual || this.entry == null || (this.entry = ((AbstractChainEntry)this.entry).next) != null ? Boolean.FALSE : Boolean.TRUE;
            }
        };
        other.iterate(agg);
        return (Boolean)agg.yield();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EN getChainEntry(long index) throws IndexOutOfBoundsException {
        block3: {
            if (index < 0L || index >= this.parent.size()) {
                throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(this.parent.size(), index));
            }
            e = this.head;
            if (this.parent.size() >>> 1 >= index) ** GOTO lbl13
            size = this.parent.size();
            while (index < size) {
                e = e.prev;
                ++index;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                e = e.next;
                --index;
lbl13:
                // 2 sources

                ** while (index >= 0L)
            }
        }
        return e;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public EN getRangeChainEntry(long offset, long length) throws IndexOutOfBoundsException {
        block11: {
            block10: {
                size = this.parent.size();
                if (length >= 0L) {
                    if (offset + length > size) {
                        throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionRange(size, offset, length));
                    }
                    if (length == 0L) {
                        return this.head;
                    }
                } else if (length < 0L) {
                    if (offset + length < -1L) {
                        throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionRange(size, offset, length));
                    }
                } else {
                    if (offset < 0L || offset >= size) {
                        throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, offset));
                    }
                    return null;
                }
                entry = this.head;
                if (offset > size >>> 1) break block10;
                if (offset >= 0L) ** GOTO lbl20
                throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, offset));
lbl-1000:
                // 1 sources

                {
                    entry = entry.next;
lbl20:
                    // 2 sources

                    ** while (offset-- >= 0L)
                }
lbl21:
                // 1 sources

                break block11;
            }
            if (offset < size) ** GOTO lbl26
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, offset));
lbl-1000:
            // 1 sources

            {
                entry = entry.prev;
lbl26:
                // 2 sources

                ** while (offset++ < size)
            }
        }
        return entry;
    }

    @Override
    public EN getIntervalLowChainEntry(long lowIndex, long highIndex) throws IndexOutOfBoundsException {
        if (lowIndex < 0L) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(this.parent.size(), lowIndex));
        }
        if (highIndex >= this.parent.size()) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(this.parent.size(), highIndex));
        }
        EN entry = this.head;
        while (lowIndex-- >= 0L) {
            entry = ((AbstractChainEntry)entry).next;
        }
        return entry;
    }

    @Override
    public final long size() {
        return this.parent.size();
    }

    @Override
    public final long consolidate() {
        return 0L;
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final ReferenceType getReferenceType() {
        return ReferenceType.STRONG;
    }

    @Override
    public final boolean containsNull() {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).hasNullElement()) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean containsId(E element) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean contains(E element) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean contains(E sample, Equalator<? super E> equalator) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean containsAll(E[] elements, int elementsOffset, int elementsLength) {
        Object first = ((AbstractChainEntry)this.head).next;
        if (first == null) {
            return false;
        }
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return true;
        }
        int elementsBound = elementsOffset + elementsLength;
        int ei = elementsOffset;
        while (ei != elementsBound) {
            block5: {
                E element = elements[ei];
                Object e = first;
                while (e != null) {
                    if (((AbstractChainEntry)e).element() != element) {
                        e = ((AbstractChainEntry)e).next;
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            ei += d;
        }
        return true;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.containsAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.applies(this::contains);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        try {
            Object e = ((AbstractChainEntry)this.head).next;
            while (true) {
                if (e == null) {
                    return false;
                }
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    return true;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean appliesAll(Predicate<? super E> predicate) {
        try {
            EN e = this.head;
            if (((AbstractChainEntry)e).next == null) {
                return false;
            }
            do {
                if ((e = ((AbstractChainEntry)e).next) != null) continue;
                return true;
            } while (predicate.test(((AbstractChainEntry)e).element()));
            return false;
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return true;
    }

    @Override
    public final long count(E element) {
        int count = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                ++count;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return count;
    }

    @Override
    public final long count(E sample, Equalator<? super E> equalator) {
        int count = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                ++count;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return count;
    }

    @Override
    public final long count(Predicate<? super E> predicate) {
        int count = 0;
        try {
            Object e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    ++count;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return count;
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            Object entry = ((AbstractChainEntry)this.head).next;
            while (entry != null) {
                Object element = ((AbstractChainEntry)entry).element();
                int i = 0;
                while (i < size) {
                    if (equalator.equal(element, array[i])) {
                        target.accept(element);
                        break;
                    }
                    ++i;
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            return target;
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        Object entry = ((AbstractChainEntry)this.head).next;
        while (entry != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)entry).element();
            if (samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            entry = ((AbstractChainEntry)entry).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            Object entry = ((AbstractChainEntry)this.head).next;
            while (entry != null) {
                block6: {
                    Object element = ((AbstractChainEntry)entry).element();
                    int i = 0;
                    while (i < size) {
                        if (!equalator.equal(element, array[i])) {
                            ++i;
                            continue;
                        }
                        break block6;
                    }
                    target.accept(element);
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            return target;
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        Object entry = ((AbstractChainEntry)this.head).next;
        while (entry != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)entry).element();
            if (!samples.containsSearched(equalCurrentElement)) {
                target.accept(equalCurrentElement.sample);
            }
            entry = ((AbstractChainEntry)entry).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> samples, Equalator<? super E> equalator, C target) {
        this.copyTo(target);
        if (samples instanceof AbstractSimpleArrayCollection) {
            E[] array = AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples));
            int size = XTypes.to_int(samples.size());
            int i = 0;
            while (i < size) {
                block4: {
                    Object sample = array[i];
                    Object entry = ((AbstractChainEntry)this.head).next;
                    while (entry != null) {
                        if (!equalator.equal(((AbstractChainEntry)entry).element(), sample)) {
                            entry = ((AbstractChainEntry)entry).next;
                            continue;
                        }
                        break block4;
                    }
                    target.accept(sample);
                }
                ++i;
            }
            return target;
        }
        samples.iterate(e -> {
            Equalator equalator2 = equalator;
            Object entry = ((AbstractChainEntry)this.head).next;
            while (entry != null) {
                if (equalator2.equal(e, ((AbstractChainEntry)entry).element())) {
                    return;
                }
                entry = ((AbstractChainEntry)entry).next;
            }
            target.accept(e);
        });
        return target;
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            target.accept(((AbstractChainEntry)e).element());
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super E>> C copySelection(C target, long[] indices) {
        long length = indices.length;
        long size = this.parent.size();
        int i = 0;
        while ((long)i < length) {
            if (indices[i] < 0L || indices[i] >= size) {
                throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        i = 0;
        while ((long)i < length) {
            target.accept(((AbstractChainEntry)this.getChainEntry(indices[i])).element());
            ++i;
        }
        return target;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final int copyToArray(long offset, int length, Object[] target, int targetOffset) {
        block5: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return 0;
            }
            if (targetOffset < 0) {
                throw new ArrayIndexOutOfBoundsException(targetOffset);
            }
            if ((length < 0 ? -length : length) + targetOffset > target.length) {
                throw new ArrayIndexOutOfBoundsException((length < 0 ? -length : length) + targetOffset);
            }
            t = targetOffset;
            if (length <= 0) ** GOTO lbl17
            while (length-- > 0) {
                target[t++] = e /* !! */ .element();
                e /* !! */  = e /* !! */ .next;
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                target[t++] = e /* !! */ .element();
                e /* !! */  = e /* !! */ .prev;
lbl17:
                // 2 sources

                ** while (length++ < 0)
            }
        }
        return t - targetOffset;
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target, Predicate<? super E> predicate) {
        try {
            Object entry = ((AbstractChainEntry)this.head).next;
            while (entry != null) {
                if (predicate.test(((AbstractChainEntry)entry).element())) {
                    target.accept(((AbstractChainEntry)entry).element());
                }
                entry = ((AbstractChainEntry)entry).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return target;
    }

    @Override
    public final Object[] toArray() {
        Object[] array = new Object[XTypes.to_int(this.parent.size())];
        this.copyToArray(0L, XTypes.to_int(this.parent.size()), array, 0);
        return array;
    }

    @Override
    public final E[] toArray(Class<E> type) {
        Object[] array = X.Array(type, XTypes.to_int(this.parent.size()));
        this.copyToArray(0L, XTypes.to_int(this.parent.size()), array, 0);
        return array;
    }

    @Override
    public final E first() {
        return ((AbstractChainEntry)this.head).next == null ? null : (E)((AbstractChainEntry)((AbstractChainEntry)this.head).next).element();
    }

    @Override
    public final E last() {
        return ((AbstractChainEntry)this.head).prev == this.head ? null : (E)((AbstractChainEntry)((AbstractChainEntry)this.head).prev).element();
    }

    @Override
    public final E get(long index) {
        return ((AbstractChainEntry)this.getChainEntry(index)).element();
    }

    @Override
    public final E seek(E sample, Equalator<? super E> equalator) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                return ((AbstractChainEntry)e).element();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final E seek(E sample) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (sample == ((AbstractChainEntry)e).element()) {
                return ((AbstractChainEntry)e).element();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        try {
            Object e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    return ((AbstractChainEntry)e).element();
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return null;
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        Object e = ((AbstractChainEntry)this.head).next;
        if (e == null) {
            return null;
        }
        Object loopMinElement = ((AbstractChainEntry)e).element();
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            if (comparator.compare(loopMinElement, element) > 0) {
                loopMinElement = element;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return loopMinElement;
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        Object e = ((AbstractChainEntry)this.head).next;
        if (e == null) {
            return null;
        }
        Object loopMaxElement = ((AbstractChainEntry)e).element();
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            if (comparator.compare(loopMaxElement, element) < 0) {
                loopMaxElement = element;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return loopMaxElement;
    }

    @Override
    public final void iterate(Consumer<? super E> procedure) {
        try {
            EN entry = this.head;
            while ((entry = ((AbstractChainEntry)entry).next) != null) {
                procedure.accept(((AbstractChainEntry)entry).element());
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final <A> void join(BiConsumer<? super E, A> joiner, A aggregate) {
        try {
            EN entry = this.head;
            while ((entry = ((AbstractChainEntry)entry).next) != null) {
                joiner.accept(((AbstractChainEntry)entry).element(), aggregate);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final void iterateIndexed(IndexedAcceptor<? super E> procedure) {
        try {
            int i = -1;
            EN entry = this.head;
            while ((entry = ((AbstractChainEntry)entry).next) != null) {
                procedure.accept(((AbstractChainEntry)entry).element(), ++i);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final void iterate(Predicate<? super E> predicate, Consumer<? super E> procedure) {
        try {
            Object e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    procedure.accept(((AbstractChainEntry)e).element());
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
    }

    @Override
    public final long indexOf(E element) {
        long i = 0L;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                return i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return -1L;
    }

    @Override
    public final long indexOf(E sample, Equalator<? super E> equalator) {
        long i = 0L;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                return i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return -1L;
    }

    @Override
    public final long lastIndexOf(E element) {
        long i = this.size();
        Object e = ((AbstractChainEntry)this.head).prev;
        while (e != this.head) {
            if (((AbstractChainEntry)e).element() == element) {
                return i;
            }
            e = ((AbstractChainEntry)e).prev;
            --i;
        }
        return -1L;
    }

    @Override
    public final long lastIndexOf(E sample, Equalator<? super E> equalator) {
        long i = this.size();
        Object e = ((AbstractChainEntry)this.head).prev;
        while (e != this.head) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                return i;
            }
            e = ((AbstractChainEntry)e).prev;
            --i;
        }
        return -1L;
    }

    @Override
    public final long indexOf(Predicate<? super E> predicate) {
        long i = 0L;
        try {
            Object e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    return i;
                }
                e = ((AbstractChainEntry)e).next;
                ++i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        long i = this.size();
        try {
            Object e = ((AbstractChainEntry)this.head).prev;
            while (e != this.head) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    return i;
                }
                e = ((AbstractChainEntry)e).prev;
                --i;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        Object e = ((AbstractChainEntry)this.head).next;
        if (e == null) {
            return -1L;
        }
        Object loopMinElement = ((AbstractChainEntry)e).element();
        long loopMinIndex = 0L;
        long i = 1L;
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            if (comparator.compare(loopMinElement, element) > 0) {
                loopMinElement = element;
                loopMinIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return loopMinIndex;
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        Object e = ((AbstractChainEntry)this.head).next;
        if (e == null) {
            return -1L;
        }
        Object loopMaxElement = ((AbstractChainEntry)e).element();
        long loopMaxIndex = 0L;
        long i = 1L;
        e = ((AbstractChainEntry)e).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            if (comparator.compare(loopMaxElement, element) < 0) {
                loopMaxElement = element;
                loopMaxIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return loopMaxIndex;
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        long i = 0L;
        long foundIndex = -1L;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).element())) {
                foundIndex = i;
            }
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
        return foundIndex;
    }

    @Override
    public final boolean hasDistinctValues() {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (element == ((AbstractChainEntry)lookAhead).element()) {
                    return false;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return true;
    }

    @Override
    public final boolean hasDistinctValues(Equalator<? super E> equalator) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            Object lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (equalator.equal(element, ((AbstractChainEntry)lookAhead).element())) {
                    return false;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return true;
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            block3: {
                Object element = ((AbstractChainEntry)e).element();
                Object lookAhead = ((AbstractChainEntry)e).next;
                while (lookAhead != null) {
                    if (element != ((AbstractChainEntry)lookAhead).element()) {
                        lookAhead = ((AbstractChainEntry)lookAhead).next;
                        continue;
                    }
                    break block3;
                }
                target.accept(element);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            block3: {
                Object element = ((AbstractChainEntry)e).element();
                Object lookAhead = ((AbstractChainEntry)e).next;
                while (lookAhead != null) {
                    if (!equalator.equal(element, ((AbstractChainEntry)lookAhead).element())) {
                        lookAhead = ((AbstractChainEntry)lookAhead).next;
                        continue;
                    }
                    break block3;
                }
                target.accept(element);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return target;
    }

    @Override
    public final VarString appendTo(VarString vc) {
        Object entry = ((AbstractChainEntry)this.head).next;
        while (entry != null) {
            vc.add(((AbstractChainEntry)entry).element());
            entry = ((AbstractChainEntry)entry).next;
        }
        return vc;
    }

    @Override
    public final VarString appendTo(VarString vc, char separator) {
        if (((AbstractChainEntry)this.head).next == null) {
            return vc;
        }
        EN entry = this.head;
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            ((AbstractChainEntry)entry).assembleElement(vc).add(separator);
        }
        return vc.deleteLast();
    }

    @Override
    public final VarString appendTo(VarString vc, String separator) {
        if (separator == null || separator.isEmpty()) {
            return this.appendTo(vc);
        }
        if (((AbstractChainEntry)this.head).next == null) {
            return vc;
        }
        char[] sepp = XChars.readChars(separator);
        EN entry = this.head;
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            ((AbstractChainEntry)entry).assembleElement(vc).add(sepp);
        }
        return vc.deleteLast(sepp.length);
    }

    @Override
    public final VarString appendTo(VarString vc, BiConsumer<VarString, ? super E> appender) {
        Object entry = ((AbstractChainEntry)this.head).next;
        while (entry != null) {
            appender.accept(vc, ((AbstractChainEntry)entry).element());
            entry = ((AbstractChainEntry)entry).next;
        }
        return vc;
    }

    @Override
    public final VarString appendTo(VarString vc, BiConsumer<VarString, ? super E> appender, char separator) {
        Object entry = ((AbstractChainEntry)this.head).next;
        if (entry == null) {
            return vc;
        }
        appender.accept(vc, ((AbstractChainEntry)entry).element());
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            appender.accept(vc.append(separator), ((AbstractChainEntry)entry).element());
        }
        return vc;
    }

    @Override
    public final VarString appendTo(VarString vc, BiConsumer<VarString, ? super E> appender, String separator) {
        if (separator == null || separator.isEmpty()) {
            return this.appendTo(vc, appender);
        }
        Object entry = ((AbstractChainEntry)this.head).next;
        if (entry == null) {
            return vc;
        }
        appender.accept(vc, ((AbstractChainEntry)entry).element());
        char[] sepp = XChars.readChars(separator);
        while ((entry = ((AbstractChainEntry)entry).next) != null) {
            appender.accept(vc.add(sepp), ((AbstractChainEntry)entry).element());
        }
        return vc;
    }

    @Override
    public final String toString() {
        VarString vc = VarString.New((int)((float)XTypes.to_int(this.parent.size()) * 5.0f));
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            vc.append('(').add(((AbstractChainEntry)e).element()).add(')', '-');
            e = ((AbstractChainEntry)e).next;
        }
        if (vc.isEmpty()) {
            vc.add('(', ')');
        } else {
            vc.deleteLast();
        }
        return vc.toString();
    }

    @Override
    public final E remove(long index) {
        ChainStorage.Entry e = this.getChainEntry(index);
        ((AbstractChainEntry)e).removeFrom(this.parent);
        return ((AbstractChainEntry)e).element();
    }

    @Override
    public final long removeNull() {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).hasNullElement()) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final E retrieve(E element) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).element();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final E retrieve(E sample, Equalator<? super E> equalator) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).element();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final E retrieve(Predicate<? super E> predicate) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).element())) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return ((AbstractChainEntry)e).element();
            }
            e = ((AbstractChainEntry)e).next;
        }
        return null;
    }

    @Override
    public final boolean removeOne(E element) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final boolean removeOne(E sample, Equalator<? super E> equalator) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                return true;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return false;
    }

    @Override
    public final long remove(E element) {
        int oldSize = XTypes.to_int(this.parent.size());
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                ((AbstractChainEntry)e).removeFrom(parent);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return oldSize - XTypes.to_int(this.parent.size());
    }

    @Override
    public final long remove(E sample, Equalator<? super E> equalator) {
        int oldSize = XTypes.to_int(this.parent.size());
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (equalator.equal(((AbstractChainEntry)e).element(), sample)) {
                ((AbstractChainEntry)e).removeFrom(parent);
            }
            e = ((AbstractChainEntry)e).next;
        }
        return oldSize - XTypes.to_int(this.parent.size());
    }

    @Override
    public final long removeAll(E[] elements, int elementsOffset, int elementsLength) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0L;
        }
        int elementsBound = elementsOffset + elementsLength;
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            int i = elementsOffset;
            while (i != elementsBound) {
                if (element == elements[i]) {
                    ((AbstractChainEntry)e).removeFrom(parent);
                    ++removeCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long removeAll(XGettingCollection<? extends E> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.removeAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        return elements.iterate(new Consumer<E>(){
            int removeCount;

            @Override
            public void accept(E e) {
                this.removeCount = (int)((long)this.removeCount + ChainStorageStrong.this.remove(e));
            }
        }).removeCount;
    }

    @Override
    public final long removeDuplicates() {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            EN lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (element == ((AbstractChainEntry)lookAhead).element()) {
                    ((AbstractChainEntry)lookAhead).removeFrom(parent);
                    ++removeCount;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            EN lookAhead = ((AbstractChainEntry)e).next;
            while (lookAhead != null) {
                if (equalator.equal(element, ((AbstractChainEntry)lookAhead).element())) {
                    ((AbstractChainEntry)lookAhead).removeFrom(parent);
                    ++removeCount;
                }
                lookAhead = ((AbstractChainEntry)lookAhead).next;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long reduce(Predicate<? super E> predicate) {
        int removeCount = 0;
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).element())) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long retainAll(E[] elements, int elementsOffset, int elementsLength) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0L;
        }
        int elementsBound = elementsOffset + elementsLength;
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            block4: {
                Object element = ((AbstractChainEntry)e).element();
                int i = elementsOffset;
                while (i != elementsBound) {
                    if (element != elements[i]) {
                        i += d;
                        continue;
                    }
                    break block4;
                }
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    public final int retainAll(E[] samples, int samplesOffset, int samplesLength, Equalator<? super E> equalator) {
        int d = ChainStorageStrong.validateArrayIteration(samples, samplesOffset, samplesLength);
        if (d == 0) {
            return 0;
        }
        int samplesBound = samplesOffset + samplesLength;
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            block4: {
                Object element = ((AbstractChainEntry)e).element();
                int i = samplesOffset;
                while (i != samplesBound) {
                    if (!equalator.equal(element, samples[i])) {
                        i += d;
                        continue;
                    }
                    break block4;
                }
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> elements) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.retainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()));
        }
        ElementIsContained currentElement = new ElementIsContained();
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            currentElement.element = ((AbstractChainEntry)e).element();
            if (!elements.containsSearched(currentElement)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples instanceof AbstractSimpleArrayCollection) {
            return this.retainAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)samples)), 0, XTypes.to_int(samples.size()), equalator);
        }
        CachedSampleEquality<? super E> equalCurrentElement = new CachedSampleEquality<E>(equalator);
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            equalCurrentElement.sample = ((AbstractChainEntry)e).element();
            if (!samples.containsSearched(equalCurrentElement)) {
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final long process(Consumer<? super E> procedure) {
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int removeCount = 0;
        try {
            EN e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                procedure.accept(((AbstractChainEntry)e).element());
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak b) {
            removeCount += parent.internalClear();
        }
        return removeCount;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final long moveRange(long offset, long length, Consumer<? super E> target) {
        block3: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return 0L;
            }
            parent = this.parent;
            bound = offset + length;
            if (length <= 0L) ** GOTO lbl18
            while (offset != bound) {
                target.accept(e /* !! */ .element());
                e /* !! */ .removeFrom(parent);
                e /* !! */  = e /* !! */ .next;
                ++offset;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                target.accept(e /* !! */ .element());
                e /* !! */ .removeFrom(parent);
                e /* !! */  = e /* !! */ .prev;
                --offset;
lbl18:
                // 2 sources

                ** while (offset != bound)
            }
        }
        return length < 0L ? -length : length;
    }

    @Override
    public final long moveSelection(Consumer<? super E> target, long ... indices) {
        int indicesLength = indices.length;
        int size = XTypes.to_int(this.parent.size());
        int i = 0;
        while (i < indicesLength) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, indices[i]));
            }
            ++i;
        }
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        int i2 = 0;
        while (i2 < indicesLength) {
            ChainStorage.Entry e = this.getChainEntry(indices[i2]);
            target.accept(((AbstractChainEntry)e).element());
            ((AbstractChainEntry)e).removeFrom(parent);
            ++i2;
        }
        return indicesLength;
    }

    @Override
    public final long moveTo(Consumer<? super E> target, Predicate<? super E> predicate) {
        int removeCount = 0;
        AbstractChainCollection<E, K, V, EN> parent = this.parent;
        EN e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            if (predicate.test(element)) {
                target.accept(element);
                ((AbstractChainEntry)e).removeFrom(parent);
                ++removeCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return removeCount;
    }

    @Override
    public final void sort(Comparator<? super E> comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        if (XTypes.to_int(this.parent.size()) <= 1) {
            return;
        }
        ChainStorageStrong.mergesortHead(this.head, comparator);
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        Object e = ((AbstractChainEntry)this.head).next;
        if (e == null) {
            return true;
        }
        Object loopLastElement = ((AbstractChainEntry)e).element();
        while ((e = ((AbstractChainEntry)e).next) != null) {
            Object element = ((AbstractChainEntry)e).element();
            if (comparator.compare(loopLastElement, element) > 0) {
                return false;
            }
            loopLastElement = element;
        }
        return true;
    }

    @Override
    public final void shuffle() {
        throw new NotImplementedYetError();
    }

    @Override
    public final void set(long offset, E[] elements) {
        ChainStorage.Entry e = this.getRangeChainEntry(offset, elements.length);
        int i = 0;
        while (i < elements.length) {
            ((AbstractChainEntry)e).setElement0(elements[i]);
            e = ((AbstractChainEntry)e).next;
            ++i;
        }
    }

    @Override
    public final void set(long offset, E[] elements, int elementsOffset, int elementsLength) {
        ChainStorage.Entry e = this.getRangeChainEntry(offset, elementsLength);
        int d = XArrays.validateArrayRange(elements, elementsOffset, elementsLength);
        int i = elementsOffset;
        int bound = elementsOffset + elementsLength;
        while (i != bound) {
            ((AbstractChainEntry)e).setElement0(elements[i]);
            e = ((AbstractChainEntry)e).next;
            i += d;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public final void fill(long offset, long length, E element) {
        block3: {
            e /* !! */  = this.getRangeChainEntry(offset, length);
            if (e /* !! */  == null) {
                return;
            }
            bound = offset + length;
            if (length <= 0L) ** GOTO lbl15
            while (offset != bound) {
                e /* !! */ .setElement0(element);
                e /* !! */  = e /* !! */ .next;
                ++offset;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                e /* !! */ .setElement0(element);
                e /* !! */  = e /* !! */ .prev;
                --offset;
lbl15:
                // 2 sources

                ** while (offset != bound)
            }
        }
    }

    @Override
    public final long replaceOne(E element, E replacement) {
        int i = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                ((AbstractChainEntry)e).setElement0(replacement);
                return i;
            }
            ++i;
            e = ((AbstractChainEntry)e).next;
        }
        return -1L;
    }

    @Override
    public final long replace(E element, E replacement) {
        int replaceCount = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (((AbstractChainEntry)e).element() == element) {
                ((AbstractChainEntry)e).setElement0(replacement);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final long replaceAll(E[] elements, int elementsOffset, int elementsLength, E replacement) {
        int d = ChainStorageStrong.validateArrayIteration(elements, elementsOffset, elementsLength);
        if (d == 0) {
            return 0L;
        }
        int elementsBound = elementsOffset + elementsLength;
        int replaceCount = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            Object element = ((AbstractChainEntry)e).element();
            int i = elementsOffset;
            while (i != elementsBound) {
                if (element == elements[i]) {
                    ((AbstractChainEntry)e).setElement0(replacement);
                    ++replaceCount;
                    break;
                }
                i += d;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final long replaceAll(XGettingCollection<? extends E> elements, final E replacement) {
        if (elements instanceof AbstractSimpleArrayCollection) {
            return this.replaceAll(AbstractSimpleArrayCollection.internalGetStorageArray((AbstractSimpleArrayCollection)((Object)elements)), 0, XTypes.to_int(elements.size()), replacement);
        }
        return elements.iterate(new Consumer<E>(){
            int replaceCount;

            @Override
            public void accept(E e) {
                this.replaceCount = (int)((long)this.replaceCount + ChainStorageStrong.this.replace(e, replacement));
            }
        }).replaceCount;
    }

    @Override
    public final long replaceOneBy(Predicate<? super E> predicate, E substitute) {
        try {
            int i = 0;
            Object e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    ((AbstractChainEntry)e).setElement0(substitute);
                    return i;
                }
                ++i;
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public final long replaceBy(Predicate<? super E> predicate, E substitute) {
        int replaceCount = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            if (predicate.test(((AbstractChainEntry)e).element())) {
                ((AbstractChainEntry)e).setElement0(substitute);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final long substitute(Function<E, E> mapper) {
        int replaceCount = 0;
        Object e = ((AbstractChainEntry)this.head).next;
        while (e != null) {
            E replacement = mapper.apply(((AbstractChainEntry)e).element());
            if (replacement != ((AbstractChainEntry)e).element()) {
                ((AbstractChainEntry)e).setElement0(replacement);
                ++replaceCount;
            }
            e = ((AbstractChainEntry)e).next;
        }
        return replaceCount;
    }

    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        int replaceCount = 0;
        try {
            Object e = ((AbstractChainEntry)this.head).next;
            while (e != null) {
                if (predicate.test(((AbstractChainEntry)e).element())) {
                    ((AbstractChainEntry)e).setElement0(mapper.apply(((AbstractChainEntry)e).element()));
                    ++replaceCount;
                }
                e = ((AbstractChainEntry)e).next;
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return replaceCount;
    }

    @Override
    public final void swap(long indexA, long indexB) {
        ChainStorage.Entry eB;
        ChainStorage.Entry eA;
        long size = this.parent.size();
        if (indexA >= size || indexA < 0L) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, indexA));
        }
        if (indexB < 0L || indexB >= size) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIndexOutOfBounds(size, indexB));
        }
        long i = indexA - indexB;
        if (i >= 0L) {
            if (i == 0L) {
                return;
            }
            if (i < size >>> 1) {
                eB = eA = this.getChainEntry(indexB);
                while (i-- > 0L) {
                    eA = ((AbstractChainEntry)eA).next;
                }
            } else {
                eA = this.getChainEntry(indexA);
                eB = this.getChainEntry(indexB);
            }
        } else if (-i < size >>> 1) {
            eB = eA = this.getChainEntry(indexA);
            while (i++ < 0L) {
                eB = ((AbstractChainEntry)eB).next;
            }
        } else {
            eA = this.getChainEntry(indexA);
            eB = this.getChainEntry(indexB);
        }
        this.swapEntries(eA, eB);
    }

    @Override
    public final void swap(long indexA, long indexB, long length) {
        long bound;
        if (length == 0L || indexA == indexB) {
            return;
        }
        if (indexA > indexB) {
            long t = indexA;
            indexA = indexB;
            indexB = t;
        }
        if (length < 0L || (bound = indexA + length) >= indexB) {
            throw new IndexOutOfBoundsException(ChainStorageStrong.exceptionIllegalSwapBounds(indexA, indexB, length));
        }
        ChainStorage.Entry eB = this.getRangeChainEntry(indexB, length);
        ChainStorage.Entry eA = this.getChainEntry(indexA);
        while (indexA < bound) {
            Object nextA = ((AbstractChainEntry)eA).next;
            Object nextB = ((AbstractChainEntry)eB).next;
            this.swapEntries(eA, eB);
            eA = nextA;
            eB = nextB;
            ++indexA;
        }
    }

    @Override
    public final void reverse() {
        Object eA = ((AbstractChainEntry)this.head).next;
        if (eA == null) {
            return;
        }
        Object eB = ((AbstractChainEntry)this.head).prev;
        int i = XTypes.to_int(this.parent.size()) >>> 1;
        while (i != 0) {
            Object nextA = ((AbstractChainEntry)eA).next;
            Object nextB = ((AbstractChainEntry)eB).prev;
            this.swapEntries(eA, eB);
            eA = nextA;
            eB = nextB;
            --i;
        }
    }

    final class Itr
    implements Iterator<E> {
        private EN current;

        Itr() {
            this.current = ChainStorageStrong.this.head;
        }

        @Override
        public final boolean hasNext() {
            return ((AbstractChainEntry)this.current).next != null;
        }

        @Override
        public final E next() {
            this.current = ((AbstractChainEntry)this.current).next;
            return ((AbstractChainEntry)this.current).element();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    final class KeyItr
    implements Iterator<E> {
        private EN current;

        KeyItr() {
            this.current = ChainStorageStrong.this.head;
        }

        @Override
        public final boolean hasNext() {
            return ((AbstractChainEntry)this.current).next != null;
        }

        @Override
        public final E next() {
            if (((AbstractChainEntry)this.current).next == null) {
                throw new NoSuchElementException();
            }
            this.current = ((AbstractChainEntry)this.current).next;
            return ((AbstractChainEntry)this.current).element();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

