/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.old.OldList;
import one.microstream.collections.old.OldSet;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XReferencing;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.TrivialIterator;

public class Constant<E>
implements XImmutableList<E>,
XImmutableEnum<E>,
XReferencing<E> {
    final E element;

    public Constant(E element) {
        this.element = element;
    }

    @Override
    public final E get() {
        return this.element;
    }

    @Override
    public final Constant<E> copy() {
        return new Constant<E>(this.element);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        procedure.accept(this.element);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        joiner.accept(this.element, aggregate);
        return aggregate;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        procedure.accept(this.element, 0L);
        return procedure;
    }

    @Override
    public final Constant<E> immure() {
        return this;
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new TrivialIterator(this);
    }

    @Override
    public final ListIterator<E> listIterator(long index) {
        if (index != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return new TrivialIterator(this);
    }

    @Override
    public final OldConstant old() {
        return new OldConstant();
    }

    @Override
    public final Constant<E> range(long fromIndex, long toIndex) {
        if (fromIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (toIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return new Constant<E>(this.element);
    }

    @Override
    public final Constant<E> toReversed() {
        return new Constant<E>(this.element);
    }

    @Override
    public final <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        int i = 0;
        while (i < indices.length) {
            if (indices[i] != 0L) {
                throw new IndexOutOfBoundsException();
            }
            ++i;
        }
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final E first() {
        return this.element;
    }

    @Override
    public final E at(long index) {
        if (index != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this.element;
    }

    @Override
    public final long indexOf(E element) {
        if (element == this.element) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return true;
    }

    @Override
    public final E last() {
        return this.element;
    }

    @Override
    public final long lastIndexOf(E element) {
        if (element == this.element) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return 0L;
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return 0L;
    }

    @Override
    public final E peek() {
        return this.element;
    }

    @Override
    public final E poll() {
        return this.element;
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return 0L;
        }
        return -1L;
    }

    @Override
    public final Constant<E> view() {
        return this;
    }

    @Override
    public final Constant<E> view(long lowIndex, long highIndex) {
        if (lowIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        if (highIndex != 0L) {
            throw new IndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return predicate.test(this.element);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return predicate.test(this.element);
    }

    @Override
    public final boolean contains(E element) {
        return this.element == element;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        Object element = this.element;
        return elements.applies(e -> e == element);
    }

    @Override
    public final boolean containsId(E element) {
        return this.element == element;
    }

    @Override
    public final <T extends Consumer<? super E>> T copyTo(T target) {
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final <T extends Consumer<? super E>> T filterTo(T target, Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            target.accept(this.element);
        }
        return (T)target;
    }

    @Override
    public final long count(E element) {
        return this.element == element ? 1 : 0;
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return predicate.test(this.element) ? 1 : 0;
    }

    @Override
    public final <T extends Consumer<? super E>> T distinct(T target) {
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final <T extends Consumer<? super E>> T distinct(T target, Equalator<? super E> equalator) {
        target.accept(this.element);
        return (T)target;
    }

    @Override
    public final Equalator<? super E> equality() {
        return Equalator.identity();
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples instanceof Constant) {
            return equalator.equal(this.element, ((Constant)samples).element);
        }
        return false;
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return XTypes.to_int(samples.size()) == 1 && equalator.equal(this.element, samples.get());
    }

    @Override
    public final <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new TrivialIterator(this);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.element;
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.element;
    }

    @Override
    public final boolean nullContained() {
        return this.element == null;
    }

    @Override
    public final E seek(E sample) {
        return (E)(this.element == sample ? sample : null);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        if (predicate.test(this.element)) {
            return this.element;
        }
        return null;
    }

    @Override
    public final long size() {
        return 1L;
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.element};
    }

    @Override
    public E[] toArray(Class<E> type) {
        E[] array = X.Array(type, 1);
        array[0] = this.element;
        return array;
    }

    @Override
    public final <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullAllowed() {
        return false;
    }

    @Override
    public final long remainingCapacity() {
        return 0L;
    }

    @Override
    public final boolean isFull() {
        return true;
    }

    @Override
    public final long maximumCapacity() {
        return 1L;
    }

    public final class OldConstant
    implements OldList<E>,
    OldSet<E> {
        @Override
        public final Constant<E> parent() {
            return Constant.this;
        }

        @Override
        public final boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean contains(Object o) {
            return Constant.this.contains(o);
        }

        @Override
        public final boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (o == Constant.this.element) continue;
                return false;
            }
            return true;
        }

        @Override
        public final E get(int index) {
            return Constant.this.at(index);
        }

        @Override
        public final int indexOf(Object o) {
            return X.checkArrayRange(Constant.this.indexOf(o));
        }

        @Override
        public final boolean isEmpty() {
            return Constant.this.isEmpty();
        }

        @Override
        public final Iterator<E> iterator() {
            return new TrivialIterator(Constant.this);
        }

        @Override
        public final int lastIndexOf(Object o) {
            return X.checkArrayRange(Constant.this.lastIndexOf(o));
        }

        @Override
        public final ListIterator<E> listIterator() {
            return new TrivialIterator(Constant.this);
        }

        @Override
        public final ListIterator<E> listIterator(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException();
            }
            return new TrivialIterator(Constant.this);
        }

        @Override
        public final boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int size() {
            return XTypes.to_int(Constant.this.size());
        }

        @Override
        public final List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex != 0 || toIndex != 0) {
                throw new IllegalArgumentException();
            }
            return this;
        }

        @Override
        public final Object[] toArray() {
            return Constant.this.toArray();
        }

        @Override
        public final <T> T[] toArray(T[] a) {
            a[0] = Constant.this.element;
            if (a.length > 1) {
                a[1] = null;
            }
            return a;
        }

        @Override
        public final Spliterator<E> spliterator() {
            return OldList.super.spliterator();
        }
    }
}

