/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.collections.AbstractChainCollection;
import one.microstream.collections.AbstractChainEntryLinked;
import one.microstream.collections.AbstractChainStorage;
import one.microstream.collections.ChainEntryLinkedHashedStrong;
import one.microstream.collections.ChainStorageStrong;
import one.microstream.collections.EnumView;
import one.microstream.collections.interfaces.ChainStorage;
import one.microstream.collections.interfaces.HashCollection;
import one.microstream.collections.old.OldSet;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XImmutableEnum;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.hashing.HashEqualator;
import one.microstream.hashing.XHashing;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.Composition;
import one.microstream.typing.Copyable;
import one.microstream.typing.XTypes;

public final class EqConstHashEnum<E>
extends AbstractChainCollection<E, E, E, ChainEntryLinkedHashedStrong<E>>
implements XImmutableEnum<E>,
HashCollection<E>,
Composition {
    private final AbstractChainStorage<E, E, E, ChainEntryLinkedHashedStrong<E>> chain;
    ChainEntryLinkedHashedStrong<E>[] slots;
    final HashEqualator<? super E> hashEqualator;
    float hashDensity;
    transient int capacity;
    transient int range;
    int size;

    public static final <E> EqConstHashEnum<E> New() {
        return new EqConstHashEnum(1, 1.0f, XHashing.hashEqualityValue());
    }

    public static final <E> EqConstHashEnum<E> New(int initialCapacity) {
        return new EqConstHashEnum(XHashing.padHashLength(initialCapacity), 1.0f, XHashing.hashEqualityValue());
    }

    public static final <E> EqConstHashEnum<E> New(int initialCapacity, float hashDensity) {
        return new EqConstHashEnum(XHashing.padHashLength(initialCapacity), XHashing.validateHashDensity(hashDensity), XHashing.hashEqualityValue());
    }

    public static final <E> EqConstHashEnum<E> New(XGettingCollection<? extends E> entries) {
        EqConstHashEnum<? extends E> newEnum = EqConstHashEnum.New();
        newEnum.internalAddAll(entries);
        return newEnum;
    }

    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator) {
        return new EqConstHashEnum<E>(1, 1.0f, hashEqualator);
    }

    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, int initialCapacity) {
        return new EqConstHashEnum<E>(XHashing.padHashLength(initialCapacity), 1.0f, hashEqualator);
    }

    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, float hashDensity) {
        return new EqConstHashEnum<E>(1, hashDensity, hashEqualator);
    }

    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, int initialCapacity, float hashDensity) {
        return new EqConstHashEnum<E>(XHashing.padHashLength(initialCapacity), XHashing.validateHashDensity(hashDensity), hashEqualator);
    }

    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, XGettingCollection<? extends E> entries) {
        return EqConstHashEnum.New(hashEqualator, 1.0f, entries);
    }

    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, float hashDensity, XGettingCollection<? extends E> entries) {
        EqConstHashEnum<E> newEnum = new EqConstHashEnum<E>(XHashing.padHashLength(entries.size()), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator));
        newEnum.internalAddAll(entries);
        return newEnum;
    }

    @SafeVarargs
    public static final <E> EqConstHashEnum<E> New(E ... entries) {
        return EqConstHashEnum.New(XHashing.hashEqualityValue(), 1.0f, entries);
    }

    @SafeVarargs
    public static final <E> EqConstHashEnum<E> New(float hashDensity, E ... entries) {
        return EqConstHashEnum.New(XHashing.hashEqualityValue(), hashDensity, entries);
    }

    @SafeVarargs
    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, E ... entries) {
        return EqConstHashEnum.New(hashEqualator, 1.0f, entries);
    }

    @SafeVarargs
    public static final <E> EqConstHashEnum<E> New(HashEqualator<? super E> hashEqualator, float hashDensity, E ... entries) {
        EqConstHashEnum<E> newEnum = new EqConstHashEnum<E>(XHashing.padHashLength(entries.length), XHashing.validateHashDensity(hashDensity), X.notNull(hashEqualator));
        E[] EArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            newEnum.internalAdd(e);
            ++n2;
        }
        return newEnum;
    }

    private EqConstHashEnum(EqConstHashEnum<E> original) {
        this.hashDensity = original.hashDensity;
        this.hashEqualator = original.hashEqualator;
        this.range = original.range;
        this.slots = ChainEntryLinkedHashedStrong.array(original.slots.length);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedHashedStrong<Object>>(this, new ChainEntryLinkedHashedStrong<Object>(-1, null, null));
        this.capacity = original.capacity;
    }

    private EqConstHashEnum(int pow2InitialHashLength, float positiveHashDensity, HashEqualator<? super E> hashEqualator) {
        this.hashDensity = positiveHashDensity;
        this.hashEqualator = hashEqualator;
        this.range = pow2InitialHashLength - 1;
        this.slots = ChainEntryLinkedHashedStrong.array(pow2InitialHashLength);
        this.chain = new ChainStorageStrong<E, E, E, ChainEntryLinkedHashedStrong<Object>>(this, new ChainEntryLinkedHashedStrong<Object>(-1, null, null));
        this.capacity = (int)((float)pow2InitialHashLength * positiveHashDensity);
    }

    final boolean internalAdd(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return false;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        this.chain.appendEntry(this.createNewEntry(hash, element));
        return true;
    }

    final void internalAddAll(XGettingCollection<? extends E> elements) {
        elements.iterate(this::internalAdd);
    }

    private ChainEntryLinkedHashedStrong<E> createNewEntry(int hash, E element) {
        if (this.size >= this.capacity) {
            EqConstHashEnum.ensureFreeArrayCapacity(this.size);
            this.increaseStorage();
        }
        ChainEntryLinkedHashedStrong<E> e = new ChainEntryLinkedHashedStrong<E>(hash, element, this.slots[hash & this.range]);
        this.slots[hash & this.range] = e;
        ++this.size;
        return e;
    }

    private void increaseStorage() {
        this.rebuildStorage((int)((float)this.slots.length * 2.0f));
    }

    private void rebuildStorage(int newSlotLength) {
        ChainEntryLinkedHashedStrong<E>[] newSlots = ChainEntryLinkedHashedStrong.array(newSlotLength);
        int modulo = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : newSlotLength - 1;
        ChainEntryLinkedHashedStrong entry = this.chain.head();
        while ((entry = (ChainEntryLinkedHashedStrong)entry.next) != null) {
            entry.link = newSlots[entry.hash & modulo];
            newSlots[entry.hash & modulo] = entry;
        }
        this.capacity = newSlotLength >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)((float)newSlotLength * this.hashDensity);
        this.slots = newSlots;
        this.range = modulo;
    }

    final void internalCollectUnhashed(E element) {
        this.chain.appendEntry(new ChainEntryLinkedHashedStrong<E>(0, element, null));
    }

    final int internalRehash() {
        int reqCapacity = XHashing.padHashLength((int)((float)this.size / this.hashDensity));
        ChainEntryLinkedHashedStrong<E>[] slots = ChainEntryLinkedHashedStrong.array(reqCapacity);
        int range = reqCapacity >= Integer.MAX_VALUE ? Integer.MAX_VALUE : reqCapacity - 1;
        HashEqualator<E> hashEqualator = this.hashEqualator;
        AbstractChainStorage<E, E, E, ChainEntryLinkedHashedStrong<E>> chain = this.chain;
        ChainEntryLinkedHashedStrong entry = (ChainEntryLinkedHashedStrong)chain.head().next;
        chain.clear();
        int size = 0;
        while (entry != null) {
            block3: {
                int hash = hashEqualator.hash(entry.element);
                ChainEntryLinkedHashedStrong e = slots[hash & range];
                while (e != null) {
                    if (e.hash != hash || !hashEqualator.equal(e.element, entry.element)) {
                        e = (ChainEntryLinkedHashedStrong)e.link;
                        continue;
                    }
                    break block3;
                }
                ChainEntryLinkedHashedStrong chainEntryLinkedHashedStrong = new ChainEntryLinkedHashedStrong(hash, entry.element, slots[hash & range]);
                slots[hash & range] = chainEntryLinkedHashedStrong;
                chain.appendEntry(chainEntryLinkedHashedStrong);
                ++size;
            }
            entry = (ChainEntryLinkedHashedStrong)entry.next;
        }
        this.slots = slots;
        this.range = range;
        this.size = size;
        return size;
    }

    @Override
    public final int rehash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nullAllowed() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ChainStorage<E, E, E, ChainEntryLinkedHashedStrong<E>> getInternalStorageChain() {
        return this.chain;
    }

    @Override
    protected int internalRemoveNullEntries() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingAddAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(E[] elements, int offset, int length) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalCountingPutAll(XGettingCollection<? extends E> elements) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void internalRemoveEntry(ChainEntryLinkedHashedStrong<E> entry) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int internalClear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long size() {
        return this.size;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public final EqConstHashEnum<E> copy() {
        final EqConstHashEnum<E> newVarMap = new EqConstHashEnum<E>(this);
        this.chain.iterate(new Consumer<E>(){

            @Override
            public void accept(E entry) {
                newVarMap.internalAdd(entry);
            }
        });
        return newVarMap;
    }

    @Override
    public final EqConstHashEnum<E> immure() {
        return this;
    }

    @Override
    public final XGettingEnum<E> view() {
        return new EnumView(this);
    }

    @Override
    public final void setHashDensity(float hashDensity) {
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final OldSet<E> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public final long maximumCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public final boolean isFull() {
        return this.size >= Integer.MAX_VALUE;
    }

    @Override
    public final long remainingCapacity() {
        return Integer.MAX_VALUE - this.size;
    }

    @Override
    public final HashCollection.Analysis<EqConstHashEnum<E>> analyze() {
        return AbstractChainEntryLinked.analyzeSlots((HashCollection)this, (AbstractChainEntryLinked[])this.slots);
    }

    @Override
    public final int hashDistributionRange() {
        return this.slots.length;
    }

    @Override
    public final HashEqualator<? super E> hashEquality() {
        return this.hashEqualator;
    }

    @Override
    public final float hashDensity() {
        return this.hashDensity;
    }

    @Override
    public final boolean hasVolatileHashElements() {
        return this.chain.hasVolatileElements();
    }

    public final String toString() {
        return this.chain.appendTo(VarString.New(this.slots.length).append('['), ",").append(']').toString();
    }

    @Override
    public final XImmutableEnum<E> range(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final XGettingEnum<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public final E[] toArray(Class<E> type) {
        return this.chain.toArray(type);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        this.chain.iterate(procedure);
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        this.chain.join(joiner, aggregate);
        return aggregate;
    }

    @Override
    public final long count(E entry) {
        return this.chain.count((E)entry, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return this.chain.count(predicate);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        return this.chain.search(predicate);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.chain.max(comparator);
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.chain.min(comparator);
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return this.chain.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return this.chain.appliesAll(predicate);
    }

    @Override
    public final boolean nullContained() {
        return false;
    }

    @Override
    public final boolean containsId(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (hash == e.hash && element == e.element) {
                return true;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return false;
    }

    @Override
    public final boolean contains(E element) {
        int hash = this.hashEqualator.hash(element);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, element)) {
                return true;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return false;
    }

    @Override
    public final E seek(E sample) {
        if (sample == null) {
            return null;
        }
        int hash = this.hashEqualator.hash(sample);
        ChainEntryLinkedHashedStrong e = this.slots[hash & this.range];
        while (e != null) {
            if (e.hash == hash && this.hashEqualator.equal(e.element, sample)) {
                return e.element;
            }
            e = (ChainEntryLinkedHashedStrong)e.link;
        }
        return null;
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        return elements.applies(this::contains);
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || !(samples instanceof EqConstHashEnum)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return this.equalsContent(samples, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (this.size != XTypes.to_int(samples.size())) {
            return false;
        }
        return this.chain.equalsContent(samples, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.intersect(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.except(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.chain.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        return this.chain.copyTo(target);
    }

    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.chain.copyTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        return this.distinct(target, (Equalator<? super E>)this.hashEqualator);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.chain.distinct(target, equalator);
    }

    @Override
    public final EqConstHashEnum<E> toReversed() {
        Copyable reversedVarSet = this.copy();
        ((EqConstHashEnum)reversedVarSet).chain.reverse();
        return reversedVarSet;
    }

    @Override
    public final <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        this.chain.copySelection(target, indices);
        return target;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        this.chain.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final E at(long index) {
        return this.chain.get(index);
    }

    @Override
    public final E get() {
        return this.chain.first();
    }

    @Override
    public final E first() {
        return this.chain.first();
    }

    @Override
    public final E last() {
        return this.chain.last();
    }

    @Override
    public final E poll() {
        return this.size == 0 ? null : (E)this.chain.first();
    }

    @Override
    public final E peek() {
        return this.size == 0 ? null : (E)this.chain.last();
    }

    @Override
    public final long indexOf(E entry) {
        return this.chain.indexOf(entry);
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        return this.chain.indexOf(predicate);
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return this.chain.isSorted(comparator);
    }

    @Override
    public final long lastIndexOf(E entry) {
        return this.chain.lastIndexOf(entry);
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        return this.chain.lastIndexBy(predicate);
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return this.chain.maxIndex(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return this.chain.minIndex(comparator);
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        return this.chain.scan(predicate);
    }

    @Override
    public final Iterator<E> iterator() {
        return this.chain.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.chain.toArray();
    }

    @Override
    public final HashEqualator<? super E> equality() {
        return this.hashEqualator;
    }
}

