/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.collections.AbstractExtendedCollection;
import one.microstream.collections.ConstList;
import one.microstream.collections.ListView;
import one.microstream.collections.SubListView;
import one.microstream.collections.old.AbstractOldSettingList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XSettingList;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.ReadOnlyListIterator;

public class ListAccessor<E>
implements XSettingList<E> {
    private final XSettingList<E> subject;

    public ListAccessor(XSettingList<E> list) {
        this.subject = list;
    }

    @Override
    public final Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    public final boolean hasVolatileElements() {
        return false;
    }

    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public final boolean nullAllowed() {
        return true;
    }

    @Override
    public final boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public final boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public final boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public final ListAccessor<E> copy() {
        return new ListAccessor<E>(this.subject.copy());
    }

    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        return this.subject.copyTo(target);
    }

    @Override
    public final long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public final long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        return this.subject.distinct(target);
    }

    @Override
    @Deprecated
    public final boolean equals(Object o) {
        return this.subject.equals(o);
    }

    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(this.subject, equalator);
    }

    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(this.subject, equalator);
    }

    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        return this.subject.iterate(procedure);
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        return this.subject.iterateIndexed(procedure);
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    public final ListAccessor<E> fill(long offset, long length, E element) {
        this.subject.fill(offset, length, element);
        return this;
    }

    @Override
    public final E at(long index) {
        return this.subject.at(index);
    }

    @Override
    public final E get() {
        return this.subject.get();
    }

    @Override
    public final E first() {
        return this.subject.first();
    }

    @Override
    public final E last() {
        return this.subject.last();
    }

    @Override
    public final E poll() {
        return this.subject.poll();
    }

    @Override
    public final E peek() {
        return this.subject.peek();
    }

    @Override
    @Deprecated
    public final int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    public final long indexBy(Predicate<? super E> predicate) {
        return this.subject.indexBy(predicate);
    }

    @Override
    public final long indexOf(E element) {
        return this.subject.indexOf(element);
    }

    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public final boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public final boolean isSorted(Comparator<? super E> comparator) {
        return this.subject.isSorted(comparator);
    }

    @Override
    public final long lastIndexBy(Predicate<? super E> predicate) {
        return this.subject.lastIndexBy(predicate);
    }

    @Override
    public final long lastIndexOf(E element) {
        return this.subject.lastIndexOf(element);
    }

    @Override
    public final Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public final ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public final ListIterator<E> listIterator(long index) {
        AbstractExtendedCollection.validateIndex(this.subject.size(), index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public final E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public final long maxIndex(Comparator<? super E> comparator) {
        return this.subject.maxIndex(comparator);
    }

    @Override
    public final E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public final long minIndex(Comparator<? super E> comparator) {
        return this.subject.minIndex(comparator);
    }

    @Override
    public final long replace(E element, E replacement) {
        return this.subject.replace(element, replacement);
    }

    @Override
    public final long replace(Predicate<? super E> predicate, E substitute) {
        return this.subject.replace(predicate, (E)substitute);
    }

    @Override
    public final long substitute(Function<? super E, ? extends E> mapper) {
        return this.subject.substitute(mapper);
    }

    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return this.subject.substitute(predicate, mapper);
    }

    @Override
    public final long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return this.subject.replaceAll(elements, (E)replacement);
    }

    @Override
    public final boolean replaceOne(E element, E replacement) {
        return this.subject.replaceOne(element, replacement);
    }

    @Override
    public final boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return this.subject.replaceOne(predicate, (E)substitute);
    }

    @Override
    public final ListAccessor<E> reverse() {
        this.subject.reverse();
        return this;
    }

    @Override
    public final long scan(Predicate<? super E> predicate) {
        return this.subject.scan(predicate);
    }

    @Override
    public final E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public final E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    @SafeVarargs
    public final ListAccessor<E> setAll(long offset, E ... elements) {
        this.subject.setAll(offset, (Object[])elements);
        return this;
    }

    @Override
    public final boolean set(long index, E element) {
        return this.subject.set(index, element);
    }

    @Override
    public final E setGet(long index, E element) {
        return this.subject.setGet(index, element);
    }

    @Override
    public final ListAccessor<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        this.subject.set(offset, (Object[])src, srcIndex, srcLength);
        return this;
    }

    @Override
    public final ListAccessor<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        this.subject.set(offset, (XGettingSequence)elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public final void setFirst(E element) {
        this.subject.setFirst(element);
    }

    @Override
    public final void setLast(E element) {
        this.subject.setLast(element);
    }

    @Override
    public final long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public final long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public final boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public final long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public final ListAccessor<E> sort(Comparator<? super E> comparator) {
        this.subject.sort(comparator);
        return this;
    }

    @Override
    public final XSettingList<E> range(long fromIndex, long toIndex) {
        return this.subject.range(fromIndex, toIndex);
    }

    @Override
    public final ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public final SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public final ListAccessor<E> shiftTo(long sourceIndex, long targetIndex) {
        this.subject.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final ListAccessor<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.subject.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final ListAccessor<E> shiftBy(long sourceIndex, long distance) {
        this.subject.shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public final ListAccessor<E> shiftBy(long sourceIndex, long distance, long length) {
        this.subject.shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public final ListAccessor<E> swap(long indexA, long indexB, long length) {
        this.subject.swap(indexA, indexB, length);
        return this;
    }

    @Override
    public final ListAccessor<E> swap(long indexA, long indexB) {
        this.subject.swap(indexA, indexB);
        return this;
    }

    @Override
    public final Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public final E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public final ListAccessor<E> toReversed() {
        return new ListAccessor<E>(this.subject.toReversed());
    }

    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public final <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return this.subject.copySelection(target, indices);
    }

    @Override
    public final XImmutableList<E> immure() {
        return ConstList.New(this.subject);
    }

    @Override
    public final OldListAccessor<E> old() {
        return new OldListAccessor(this);
    }

    public static final class OldListAccessor<E>
    extends AbstractOldSettingList<E> {
        OldListAccessor(ListAccessor<E> list) {
            super(list);
        }

        @Override
        public final ListAccessor<E> parent() {
            return (ListAccessor)super.parent();
        }
    }
}

