/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.function.Consumer;
import one.microstream.collections.ConstMiniMap;
import one.microstream.math.XMath;
import one.microstream.typing.Composition;
import one.microstream.typing.KeyValue;

public final class MiniMap<K, V>
implements Composition {
    private Entry<K, V>[] slots;
    private int modulo;
    private int size;

    @SafeVarargs
    public static final <K, V> MiniMap<K, V> miniMap(KeyValue<? extends K, ? extends V> ... data) {
        return new MiniMap<K, V>(data.length, data);
    }

    public MiniMap() {
        this.size = 0;
        this.slots = new Entry[1];
        this.modulo = 0;
    }

    public MiniMap(int initialCapacity) {
        this.size = 0;
        this.slots = new Entry[XMath.pow2BoundMaxed(initialCapacity)];
        this.modulo = this.slots.length - 1;
    }

    public MiniMap(int initialCapacity, KeyValue<? extends K, ? extends V> ... data) {
        int modulo;
        this.size = 0;
        Entry[] slots = new Entry[XMath.pow2BoundMaxed(initialCapacity)];
        this.slots = slots;
        this.modulo = modulo = slots.length - 1;
        int i = 0;
        while (i < data.length) {
            K key;
            KeyValue<K, V> entry = data[i];
            if (entry != null && (key = entry.key()) != null) {
                slots[System.identityHashCode(key) & modulo] = new Entry<K, V>(key, entry.value(), slots[System.identityHashCode(key) & modulo]);
            }
            ++i;
        }
    }

    MiniMap(int size, ConstMiniMap.Entry<K, V>[] source) {
        int modulo;
        this.size = size;
        Entry[] slots = new Entry[XMath.pow2BoundMaxed(this.size)];
        this.slots = slots;
        this.modulo = modulo = slots.length - 1;
        int i = 0;
        while (i < source.length) {
            ConstMiniMap.Entry<K, V> entry = source[i];
            while (entry != null) {
                slots[System.identityHashCode(entry.key) & modulo] = new Entry(entry.key, entry.value, slots[System.identityHashCode(entry.key) & modulo]);
                entry = entry.link;
            }
            ++i;
        }
    }

    MiniMap(int size, Entry<K, V>[] source) {
        int modulo;
        this.size = size;
        Entry[] slots = new Entry[XMath.pow2BoundMaxed(this.size)];
        this.slots = slots;
        this.modulo = modulo = slots.length - 1;
        int i = 0;
        while (i < source.length) {
            Entry<K, V> entry = source[i];
            while (entry != null) {
                slots[System.identityHashCode(entry.key) & modulo] = new Entry(entry.key, entry.value, slots[System.identityHashCode(entry.key) & modulo]);
                entry = entry.link;
            }
            ++i;
        }
    }

    public int size() {
        return this.size;
    }

    public MiniMap<K, V> copy() {
        return new MiniMap<K, V>(this.size, this.slots);
    }

    public ConstMiniMap<K, V> toConstMap() {
        return new ConstMiniMap<K, V>(this.size, this.slots);
    }

    public V get(K key) {
        Entry<K, V> e = this.slots[System.identityHashCode(key) & this.modulo];
        while (e != null) {
            if (e.key == key) {
                return e.value;
            }
            e = e.link;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        return null;
    }

    public boolean containsKey(K key) {
        Entry<K, V> e = this.slots[System.identityHashCode(key) & this.modulo];
        while (e != null) {
            if (e.key == key) {
                return true;
            }
            e = e.link;
        }
        return false;
    }

    private void increaseStorage() {
        if (XMath.isGreaterThanOrEqualHighestPowerOf2(this.slots.length)) {
            return;
        }
        this.rebuildStorage(this.slots.length << 1);
    }

    private void rebuildStorage(int newSlotLength) {
        Entry<K, V>[] slots = this.slots;
        Entry[] newSlots = new Entry[newSlotLength];
        int newModulo = newSlotLength - 1;
        int i = 0;
        while (i < slots.length) {
            Entry<K, V> e = slots[i];
            while (e != null) {
                Entry link = e.link;
                e.link = newSlots[System.identityHashCode(e.key) & newModulo];
                newSlots[System.identityHashCode(e.key) & newModulo] = e;
                e = link;
            }
            ++i;
        }
        this.slots = newSlots;
        this.modulo = newModulo;
    }

    public V put(K key, V value) {
        Entry<K, V> e = this.slots[System.identityHashCode(key) & this.modulo];
        while (e != null) {
            if (e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.link;
        }
        if (key == null) {
            throw new NullPointerException();
        }
        this.slots[System.identityHashCode(key) & this.modulo] = new Entry<K, V>(key, value, this.slots[System.identityHashCode(key) & this.modulo]);
        if (this.size++ >= this.modulo) {
            this.increaseStorage();
        }
        return null;
    }

    public MiniMap<K, V> putAll(KeyValue<K, V> ... data) {
        Entry<K, V>[] slots = this.slots;
        int modulo = this.modulo;
        int i = 0;
        while (i < data.length) {
            K key = data[i].key();
            if (key != null) {
                slots[System.identityHashCode(key) & modulo] = new Entry<K, V>(key, data[i].value(), slots[System.identityHashCode(key) & modulo]);
                if (this.size++ >= modulo) {
                    this.increaseStorage();
                    slots = this.slots;
                    modulo = this.modulo;
                }
            }
            ++i;
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    public V remove(K key) {
        if (key == null) {
            throw new NullPointerException();
        }
        entry = this.slots[System.identityHashCode(key) & this.modulo];
        if (entry.key != key) ** GOTO lbl12
        this.slots[System.identityHashCode(key) & this.modulo] = entry.link;
        --this.size;
        return entry.value;
lbl-1000:
        // 1 sources

        {
            if (entry.key == key) {
                last.link = entry.link;
                --this.size;
                return entry.value;
            }
lbl12:
            // 3 sources

            last = entry;
            ** while ((entry = last.link) != null)
        }
lbl14:
        // 1 sources

        return null;
    }

    public void optimize() {
        if (XMath.pow2BoundMaxed(this.size) < this.modulo) {
            this.rebuildStorage(XMath.pow2BoundMaxed(this.size));
        }
    }

    public void clear() {
        Entry<K, V>[] slots = this.slots;
        int i = 0;
        while (i < slots.length) {
            Entry<K, V> e = slots[i];
            while (e != null) {
                Entry link = e.link;
                e.key = null;
                e.value = null;
                e.link = null;
                e = link;
            }
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    public KeyValue<K, V>[] toArray() {
        Entry<K, V>[] slots = this.slots;
        int slotsLength = slots.length;
        KeyValue[] array = new KeyValue[this.size];
        int a = 0;
        int i = 0;
        while (i < slotsLength) {
            Entry<K, V> e = slots[i];
            while (e != null) {
                array[a++] = KeyValue.New(e.key, e.value);
                e = e.link;
            }
            ++i;
        }
        return array;
    }

    public int iterateValues(Consumer<? super V> procedure) {
        Entry<K, V>[] entryArray = this.slots;
        int n = this.slots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<K, V> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.value);
                entry = entry.link;
            }
            ++n2;
        }
        return this.size;
    }

    static final class Entry<K, V>
    implements Composition {
        K key;
        V value;
        Entry<K, V> link;

        Entry(K key, V value, Entry<K, V> link) {
            this.key = key;
            this.value = value;
            this.link = link;
        }
    }
}

