/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.SubListAccessor;
import one.microstream.collections.XArrays;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XList;
import one.microstream.collections.types.XProcessingList;
import one.microstream.collections.types.XSettingList;
import one.microstream.equality.Equalator;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;

public final class SubList<E>
extends SubListAccessor<E>
implements XList<E> {
    public SubList(XList<E> list, long fromIndex, long toIndex) {
        super(list, fromIndex, toIndex);
    }

    private void internalClear() {
        this.size = 0L;
        this.length = 0L;
        this.d = 1;
    }

    private void increment() {
        ++this.size;
        this.length += (long)this.d;
    }

    private void increment(long amount) {
        this.size += amount;
        this.length += amount * (long)this.d;
    }

    private void decrement() {
        --this.size;
        this.length -= (long)this.d;
    }

    private void decrement(long amount) {
        this.size -= amount;
        this.length -= amount * (long)this.d;
    }

    @Override
    public final long currentCapacity() {
        return ((XList)this.list).currentCapacity();
    }

    @Override
    public final void clear() {
        ((XList)this.list).removeRange(this.startIndex, this.length);
        this.internalClear();
    }

    @Override
    public final void accept(E element) {
        this.add(element);
    }

    @Override
    public final boolean add(E e) {
        ((XList)this.list).input(this.startIndex + this.length, e);
        this.increment();
        return true;
    }

    @Override
    @SafeVarargs
    public final SubList<E> addAll(E ... elements) {
        ((XList)this.list).inputAll(this.startIndex + this.length, elements);
        this.increment(elements.length);
        return this;
    }

    @Override
    public final SubList<E> addAll(XGettingCollection<? extends E> elements) {
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).inputAll(this.startIndex + this.length, elements);
        this.increment(((XList)this.list).size() - (long)oldListSize);
        return this;
    }

    @Override
    public final SubList<E> addAll(E[] elements, int offset, int length) {
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).inputAll(this.getEndIndex(), elements, offset, length);
        this.increment(((XList)this.list).size() - (long)oldListSize);
        return this;
    }

    @Override
    public final boolean nullAdd() {
        ((XList)this.list).input(this.startIndex + this.length, null);
        this.increment();
        return true;
    }

    @Override
    public final boolean put(E element) {
        return this.add(element);
    }

    @Override
    @SafeVarargs
    public final SubList<E> putAll(E ... elements) {
        return this.addAll((Object[])elements);
    }

    @Override
    public final SubList<E> putAll(E[] elements, int offset, int length) {
        return this.addAll((Object[])elements, offset, length);
    }

    @Override
    public final SubList<E> putAll(XGettingCollection<? extends E> elements) {
        return elements.iterate(this);
    }

    @Override
    public final boolean nullPut() {
        return this.nullAdd();
    }

    @Override
    public final boolean prepend(E element) {
        if (this.d > 0) {
            if (((XList)this.list).insert(this.startIndex, element)) {
                --this.startIndex;
                this.increment();
                return true;
            }
        } else if (((XList)this.list).insert(this.startIndex + 1L, element)) {
            ++this.startIndex;
            this.increment();
            return true;
        }
        return false;
    }

    @Override
    @SafeVarargs
    public final SubList<E> prependAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final SubList<E> prependAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public final SubList<E> prependAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPrepend() {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean preput(E element) {
        if (this.d > 0) {
            ((XList)this.list).input(this.startIndex, element);
            --this.startIndex;
        } else {
            ((XList)this.list).input(this.startIndex + 1L, element);
            ++this.startIndex;
        }
        this.increment();
        return true;
    }

    @Override
    @SafeVarargs
    public final SubList<E> preputAll(E ... elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final SubList<E> preputAll(E[] elements, int srcStartIndex, int srcLength) {
        throw new NotImplementedYetError();
    }

    @Override
    public final SubList<E> preputAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean nullPreput() {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean insert(long index, E element) {
        this.checkIndex(index);
        return ((XList)this.list).insert(this.startIndex + index * (long)this.d, element);
    }

    @Override
    @SafeVarargs
    public final long insertAll(long index, E ... elements) {
        this.checkIndex(index);
        int oldListSize = XTypes.to_int(this.list.size());
        if (this.d > 0) {
            ((XList)this.list).insertAll(this.startIndex + index, elements);
        } else {
            ((XList)this.list).insertAll(this.startIndex - index, XArrays.toReversed(elements));
        }
        long increase = ((XList)this.list).size() - (long)oldListSize;
        this.increment(increase);
        return XTypes.to_int(increase);
    }

    @Override
    public final long insertAll(long index, E[] elements, int offset, int length) {
        this.checkIndex(index);
        int oldListSize = XTypes.to_int(this.list.size());
        if (this.d > 0) {
            ((XList)this.list).insertAll(this.startIndex + index, elements, offset, length);
        } else {
            ((XList)this.list).insertAll(this.startIndex - index, XArrays.toReversed(elements, offset, length));
        }
        long increase = ((XList)this.list).size() - (long)oldListSize;
        this.increment(increase);
        return XTypes.to_int(increase);
    }

    @Override
    public final long insertAll(long index, XGettingCollection<? extends E> elements) {
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).insertAll(this.startIndex + index * (long)this.d, elements);
        long increase = ((XList)this.list).size() - (long)oldListSize;
        this.increment(increase);
        return XTypes.to_int(increase);
    }

    @Override
    public final boolean nullInsert(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final boolean input(long index, E element) {
        this.checkIndex(index);
        return ((XList)this.list).input(this.startIndex + index * (long)this.d, element);
    }

    @Override
    @SafeVarargs
    public final long inputAll(long index, E ... elements) {
        this.checkIndex(index);
        int oldListSize = XTypes.to_int(this.list.size());
        if (this.d > 0) {
            ((XList)this.list).inputAll(this.startIndex + index, elements);
        } else {
            ((XList)this.list).inputAll(this.startIndex - index, XArrays.toReversed(elements));
        }
        long increase = ((XList)this.list).size() - (long)oldListSize;
        this.increment(increase);
        return XTypes.to_int(increase);
    }

    @Override
    public final long inputAll(long index, E[] elements, int offset, int length) {
        this.checkIndex(index);
        int oldListSize = XTypes.to_int(this.list.size());
        if (this.d > 0) {
            ((XList)this.list).inputAll(this.startIndex + index, elements, offset, length);
        } else {
            ((XList)this.list).inputAll(this.startIndex - index, XArrays.toReversed(elements, offset, length));
        }
        long increase = ((XList)this.list).size() - (long)oldListSize;
        this.increment(increase);
        return XTypes.to_int(increase);
    }

    @Override
    public final long inputAll(long index, XGettingCollection<? extends E> elements) {
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).inputAll(this.startIndex + index * (long)this.d, elements);
        long increase = ((XList)this.list).size() - (long)oldListSize;
        this.increment(increase);
        return XTypes.to_int(increase);
    }

    @Override
    public final boolean nullInput(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        int oldListSize = XTypes.to_int(this.list.size());
        XUtilsCollection.rngProcess((XProcessingList)this.list, this.startIndex, this.length, procedure);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return procedure;
    }

    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngRemoveDuplicates((XProcessingList)this.list, this.startIndex, this.length, equalator);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final E retrieve(E element) {
        int oldListSize = XTypes.to_int(this.list.size());
        E e = XUtilsCollection.rngRetrieve((XProcessingList)this.list, this.startIndex, this.length, element);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return e;
    }

    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        int oldListSize = XTypes.to_int(this.list.size());
        E e = XUtilsCollection.rngRetrieve((XProcessingList)this.list, this.startIndex, this.length, predicate);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return e;
    }

    @Override
    public final boolean removeOne(E element) {
        if (XUtilsCollection.rngRemoveOne((XProcessingList)this.list, this.startIndex, this.length, element)) {
            this.decrement();
            return true;
        }
        return false;
    }

    @Override
    public final long remove(E element) {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngRemove((XProcessingList)this.list, this.startIndex, this.length, element);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long removeAll(XGettingCollection<? extends E> elements) {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngRemoveAll((XProcessingList)this.list, this.startIndex, this.length, elements);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long removeDuplicates() {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngRemoveDuplicates((XProcessingList)this.list, this.startIndex, this.length);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long retainAll(XGettingCollection<? extends E> elements) {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngRetainAll((XProcessingList)this.list, this.startIndex, this.length, elements);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngReduce((XProcessingList)this.list, this.startIndex, this.length, predicate);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final void truncate() {
        ((XList)this.list).removeRange(this.startIndex, this.length);
        this.internalClear();
    }

    @Override
    public final SubList<E> range(long fromIndex, long toIndex) {
        this.checkRange(fromIndex, toIndex);
        return new SubList<E>((XList)this.list, this.startIndex + fromIndex * (long)this.d, this.startIndex + toIndex * (long)this.d);
    }

    @Override
    public final SubList<E> ensureFreeCapacity(long minimalFreeCapacity) {
        ((XList)this.list).ensureFreeCapacity(minimalFreeCapacity);
        return this;
    }

    @Override
    public final SubList<E> ensureCapacity(long minimalCapacity) {
        ((XList)this.list).ensureCapacity(minimalCapacity + this.size);
        return this;
    }

    @Override
    public final long consolidate() {
        return ((XList)this.list).consolidate() > 0L ? 1 : 0;
    }

    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        int oldListSize = XTypes.to_int(this.list.size());
        XUtilsCollection.rngMoveTo((XProcessingList)this.list, this.startIndex, this.length, target, predicate);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return target;
    }

    @Override
    public final long optimize() {
        return ((XList)this.list).optimize();
    }

    @Override
    public final <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).moveSelection(target, this.shiftIndices(indices));
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return target;
    }

    @Override
    public final E removeAt(long index) throws UnsupportedOperationException {
        this.checkIndex(index);
        Object element = ((XList)this.list).removeAt(index);
        this.decrement();
        return element;
    }

    @Override
    public final E fetch() {
        return this.removeAt(0L);
    }

    @Override
    public final E pop() {
        return this.removeAt(this.getEndIndex());
    }

    @Override
    public final E pinch() {
        return this.size == 0L ? null : (E)this.removeAt(0L);
    }

    @Override
    public final E pick() {
        return this.size == 0L ? null : (E)this.removeAt(this.getEndIndex());
    }

    @Override
    public final SubList<E> removeRange(long startIndex, long length) {
        this.checkVector(startIndex, length);
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).removeRange(this.startIndex + startIndex * (long)this.d, length * (long)this.d);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return this;
    }

    @Override
    public final SubList<E> retainRange(long startIndex, long length) {
        this.checkVector(startIndex, length);
        int oldListSize = XTypes.to_int(this.list.size());
        ((XList)this.list).retainRange(this.startIndex + startIndex * (long)this.d, length * (long)this.d);
        this.decrement(oldListSize - XTypes.to_int(this.list.size()));
        return this;
    }

    @Override
    public final long removeSelection(long[] indices) {
        long oldListSize = ((XList)this.list).size();
        ((XList)this.list).removeSelection(this.shiftIndices(indices));
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final SubList<E> toReversed() {
        return new SubList<E>((XList)this.list, this.getEndIndex(), this.startIndex);
    }

    @Override
    public final SubList<E> copy() {
        return new SubList<E>((XList)this.list, this.startIndex, this.getEndIndex());
    }

    @Override
    public final long nullRemove() {
        long oldListSize = ((XList)this.list).size();
        XUtilsCollection.rngRemoveNull((XProcessingList)this.list, this.startIndex, this.length);
        long removeCount = oldListSize - (long)XTypes.to_int(this.list.size());
        this.decrement(removeCount);
        return XTypes.to_int(removeCount);
    }

    @Override
    public final SubList<E> sort(Comparator<? super E> comparator) {
        XUtilsCollection.rngSort((XSettingList)this.list, this.startIndex, this.length, comparator);
        return this;
    }

    @Override
    public final SubList<E> swap(long indexA, long indexB) {
        this.checkIndex(indexA);
        this.checkIndex(indexB);
        ((XList)this.list).swap(this.startIndex + indexA * (long)this.d, this.startIndex + indexB * (long)this.d);
        return this;
    }

    @Override
    public final SubList<E> swap(long indexA, long indexB, long length) {
        this.checkVector(indexA, length);
        this.checkVector(indexB, length);
        ((XList)this.list).swap(this.startIndex + indexA * (long)this.d, this.startIndex + indexB * (long)this.d, length * (long)this.d);
        return this;
    }

    @Override
    @SafeVarargs
    public final SubList<E> setAll(long offset, E ... elements) {
        super.setAll(offset, (Object[])elements);
        return this;
    }

    @Override
    public final SubList<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        super.set(offset, (Object[])src, srcIndex, srcLength);
        return this;
    }

    @Override
    public final SubList<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        this.checkVector(offset, elementsLength);
        if (this.d > 0) {
            ((XList)this.list).set(this.startIndex + offset, (XGettingSequence)elements, elementsOffset, elementsLength);
        } else {
            long revElementsStartIndex = elementsLength == 0L ? elementsOffset : (elementsLength > 0L ? elementsOffset + elementsLength - 1L : elementsOffset + elementsLength + 1L);
            ((XList)this.list).set(this.startIndex - offset, (XGettingSequence)elements, revElementsStartIndex, -elementsLength);
        }
        return this;
    }

    @Override
    public final SubList<E> fill(long offset, long length, E element) {
        this.checkVector(offset, length);
        ((XList)this.list).fill(this.startIndex + offset * (long)this.d, length * (long)this.d, (Object)element);
        return this;
    }

    @Override
    public final OldSubList<E> old() {
        return new OldSubList(this);
    }

    @Override
    public final SubList<E> reverse() {
        throw new NotImplementedYetError();
    }

    @Override
    public final SubList<E> shiftTo(long sourceIndex, long targetIndex) {
        super.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final SubList<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        super.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final SubList<E> shiftBy(long sourceIndex, long distance) {
        super.shiftBy(sourceIndex, distance);
        return this;
    }

    @Override
    public final SubList<E> shiftBy(long sourceIndex, long distance, long length) {
        super.shiftBy(sourceIndex, distance, length);
        return this;
    }

    static class OldSubList<E>
    extends SubListAccessor.OldSubListAccessor<E> {
        OldSubList(SubList<E> list) {
            super(list);
        }

        @Override
        public final SubList<E> parent() {
            return (SubList)super.parent();
        }
    }
}

