/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import one.microstream.collections.AbstractSimpleArrayCollection;
import one.microstream.collections.sorting.Sortable;
import one.microstream.collections.types.XSortableSequence;
import one.microstream.functional.ComparatorReversed;
import one.microstream.functional.ComparatorSequence;
import one.microstream.math.FastRandom;

public final class XSort {
    private static final transient int RANDOM_SEGMENTS = 32;
    private static final transient int R32_SHIFT = 5;
    private static final transient int R32_RANGE = 32;
    private static final transient int R32_SIZE = 1024;
    private static final transient int R32_MOD = 1023;
    private static final transient int R04_SHIFT = 2;
    private static final transient int R04_RANGE = 4;
    private static final transient int R04_SIZE = 128;
    private static final transient int R04_MOD = 127;
    private static final transient int[] RND32 = new int[1024];
    private static final transient int[] RND04 = new int[128];
    private static transient int r;

    static {
        XSort.initPseudoRandom();
    }

    public static final int compare(Boolean o1, Boolean o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        if (o1.booleanValue()) {
            return o2 != false ? 0 : 1;
        }
        return o2 != false ? -1 : 0;
    }

    public static final int compare(Byte o1, Byte o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2 >= o1 ? (o2.byteValue() != o1.byteValue() ? -1 : 0) : 1;
    }

    public static final int compare(Short o1, Short o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2 >= o1 ? (o2.shortValue() != o1.shortValue() ? -1 : 0) : 1;
    }

    public static final int compare(Integer o1, Integer o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2 >= o1 ? (o2.intValue() != o1.intValue() ? -1 : 0) : 1;
    }

    public static final int compare(Float o1, Float o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2.floatValue() >= o1.floatValue() ? (o2.floatValue() != o1.floatValue() ? -1 : 0) : 1;
    }

    public static final int compare(Long o1, Long o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2 >= o1 ? (o2.longValue() != o1.longValue() ? -1 : 0) : 1;
    }

    public static final int compare(Double o1, Double o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2 >= o1 ? (o2.doubleValue() != o1.doubleValue() ? -1 : 0) : 1;
    }

    public static final int compare(String o1, String o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o1.compareTo(o2);
    }

    public static final int compareLength(String o1, String o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return o2.length() >= o1.length() ? (o2.length() != o1.length() ? -1 : 0) : 1;
    }

    public static final int compareIdentityHash(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null ? 0 : -1;
        }
        if (o2 == null) {
            return 1;
        }
        return System.identityHashCode(o2) >= System.identityHashCode(o1) ? (System.identityHashCode(o2) != System.identityHashCode(o1) ? -1 : 0) : 1;
    }

    public static final <E> Comparator<E> reverse(Comparator<E> comparator) {
        return new ComparatorReversed<E>(comparator);
    }

    @SafeVarargs
    public static final <E> Comparator<? super E> chain(Comparator<? super E> ... comparators) {
        return new ComparatorSequence<E>(comparators);
    }

    private static void initPseudoRandom() {
        int i;
        int bound;
        int offset;
        FastRandom rnd = new FastRandom();
        int segment = 0;
        int[] random = RND32;
        while (segment < 32) {
            offset = segment * 32;
            bound = offset + 32;
            i = offset;
            while (i < bound) {
                random[i] = i - offset;
                ++i;
            }
            i = offset;
            while (i < bound) {
                XSort.swap(random, i, offset + rnd.nextInt(32));
                ++i;
            }
            ++segment;
        }
        segment = 0;
        random = RND04;
        while (segment < 32) {
            offset = segment * 4;
            bound = offset + 4;
            i = offset;
            while (i < bound) {
                random[i] = i - offset;
                ++i;
            }
            i = offset;
            while (i < bound) {
                XSort.swap(random, i, offset + rnd.nextInt(4));
                ++i;
            }
            ++segment;
        }
    }

    private static int spotTestIndex32Left(int mid, int multiplier) {
        return mid - RND32[++r & 0x3FF] * multiplier;
    }

    private static int spotTestIndex32Right(int mid, int multiplier) {
        return mid + RND32[++r & 0x3FF] * multiplier;
    }

    private static int spotTestIndex04Left(int mid, int multiplier) {
        return mid - RND04[++r & 0x7F] * multiplier;
    }

    private static int spotTestIndex04Right(int mid, int multiplier) {
        return mid + RND04[++r & 0x7F] * multiplier;
    }

    private static int log2(int length) {
        return length < 8 ? 3 : (length < 16 ? 4 : (length < 32 ? 5 : (length < 64 ? 6 : (length < 128 ? 7 : (length < 256 ? 8 : (length < 512 ? 9 : (length < 1024 ? 10 : (length < 2048 ? 11 : (length < 4096 ? 12 : (length < 8192 ? 13 : (length < 16384 ? 14 : (length < 32768 ? 15 : (length < 65536 ? 16 : (length < 131072 ? 17 : (length < 262144 ? 18 : (length < 524288 ? 19 : (length < 0x100000 ? 20 : (length < 0x200000 ? 21 : (length < 0x400000 ? 22 : (length < 0x800000 ? 23 : (length < 0x1000000 ? 24 : (length < 0x2000000 ? 25 : (length < 0x4000000 ? 26 : (length < 0x8000000 ? 27 : (length < 0x10000000 ? 28 : (length < 0x20000000 ? 29 : 30))))))))))))))))))))))))));
    }

    private static void swap(int[] values, int l, int r) {
        int t = values[l];
        values[l] = values[r];
        values[r] = t;
    }

    private static void swap(long[] values, int l, int r) {
        long t = values[l];
        values[l] = values[r];
        values[r] = t;
    }

    private static void swap(Object[] values, int l, int r) {
        Object t = values[l];
        values[l] = values[r];
        values[r] = t;
    }

    private static void checkRange(int[] values, int start, int bound) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException(start);
        }
        if (start >= bound) {
            throw new IllegalArgumentException("invalid sorting range");
        }
        if (bound > values.length) {
            throw new ArrayIndexOutOfBoundsException(bound);
        }
    }

    private static boolean checkRange(Object[] values, int start, int bound) {
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException(start);
        }
        if (bound > values.length) {
            throw new ArrayIndexOutOfBoundsException(bound);
        }
        if (start > bound) {
            throw new IllegalArgumentException("invalid sorting range");
        }
        return bound - start > 1;
    }

    private static <E> E[] mergesortBuffer(E[] suggestedBuffer, E[] values) {
        if (suggestedBuffer == null || suggestedBuffer == values || suggestedBuffer.length < values.length) {
            return (Object[])values.clone();
        }
        System.arraycopy(values, 0, suggestedBuffer, 0, values.length);
        return suggestedBuffer;
    }

    private static int checkIterationRange(int[] values, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            if (startIndex < 0 || startIndex >= values.length) {
                throw new ArrayIndexOutOfBoundsException(startIndex);
            }
            return 0;
        }
        if (startIndex < endIndex) {
            if (startIndex < 0) {
                throw new ArrayIndexOutOfBoundsException(startIndex);
            }
            if (endIndex >= values.length) {
                throw new ArrayIndexOutOfBoundsException(endIndex);
            }
            return 1;
        }
        if (startIndex >= values.length) {
            throw new ArrayIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        return -1;
    }

    private static int checkIterationRange(Object[] values, int startIndex, int endIndex) {
        if (startIndex == endIndex) {
            if (startIndex < 0 || startIndex >= values.length) {
                throw new ArrayIndexOutOfBoundsException(startIndex);
            }
            return 0;
        }
        if (startIndex < endIndex) {
            if (startIndex < 0) {
                throw new ArrayIndexOutOfBoundsException(startIndex);
            }
            if (endIndex >= values.length) {
                throw new ArrayIndexOutOfBoundsException(endIndex);
            }
            return 1;
        }
        if (startIndex >= values.length) {
            throw new ArrayIndexOutOfBoundsException(startIndex);
        }
        if (endIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(endIndex);
        }
        return -1;
    }

    private static void insertionsort0(int[] values, int start, int bound) {
        int i = start;
        while (i < bound) {
            int j = i;
            while (j > start && values[j - 1] > values[j]) {
                XSort.swap(values, j, j - 1);
                --j;
            }
            ++i;
        }
    }

    private static void insertionsort0(long[] values, int start, int bound) {
        int i = start;
        while (i < bound) {
            int j = i;
            while (j > start && values[j - 1] > values[j]) {
                XSort.swap(values, j, j - 1);
                --j;
            }
            ++i;
        }
    }

    private static <E> void insertionsort0(E[] values, int start, int bound, Comparator<? super E> comparator) {
        int i = start;
        while (i < bound) {
            int j = i;
            while (j > start && comparator.compare(values[j - 1], values[j]) > 0) {
                XSort.swap(values, j, j - 1);
                --j;
            }
            ++i;
        }
    }

    private static <E> boolean tryInsertionsort(E[] values, int start, int bound, Comparator<? super E> comparator) {
        int c = bound - start;
        int i = start;
        while (i < bound) {
            int j = i;
            while (j > start && comparator.compare(values[j - 1], values[j]) > 0) {
                XSort.swap(values, j, j - 1);
                if (--c == 0) {
                    return false;
                }
                --j;
            }
            ++i;
        }
        return true;
    }

    @SafeVarargs
    public static final <T> void sortAll(Comparator<? super T> sortation, Sortable<T> ... sortables) {
        int i = 0;
        while (i < sortables.length) {
            if (sortables[i] != null) {
                sortables[i].sort(sortation);
            }
            ++i;
        }
    }

    public static void insertionsort(boolean[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            boolean ai = values[i + 1];
            while (!ai && values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(byte[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            byte ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(short[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            short ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(int[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            int ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(long[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            long ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(float[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            float ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(double[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            double ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static void insertionsort(char[] values) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            char ai = values[i + 1];
            while (ai < values[j]) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static <E> void insertionsort(E[] values, Comparator<? super E> comparator) {
        int i;
        int j = i = 0;
        int len = values.length - 1;
        while (i < len) {
            E ai = values[i + 1];
            while (comparator.compare(ai, values[j]) < 0) {
                values[j + 1] = values[j];
                if (j-- == 0) break;
            }
            values[j + 1] = ai;
            j = ++i;
        }
    }

    public static <E> void sort(E[] elements, Comparator<? super E> comparator) {
        XSort.adaptiveMergesort0((Object[])elements.clone(), elements, 0, elements.length, comparator, XSort.log2(elements.length));
    }

    public static <E> void sort(E[] elements, int start, int bound, Comparator<? super E> comparator) {
        if (XSort.checkRange(elements, start, bound)) {
            XSort.adaptiveMergesort0((Object[])elements.clone(), elements, start, bound, comparator, XSort.log2(bound - start));
        }
    }

    public static <V> void valueSort(XSortableSequence<V> values, Comparator<? super V> comparator) {
        if (values instanceof AbstractSimpleArrayCollection) {
            XSort.valueSort(((AbstractSimpleArrayCollection)((Object)values)).internalGetStorageArray(), 0, ((AbstractSimpleArrayCollection)((Object)values)).internalSize(), comparator);
            return;
        }
        values.sort(comparator);
    }

    public static <V> void valueSort(V[] values, Comparator<? super V> comparator) {
        XSort.dualPivotQuicksort(values, 0, values.length - 1, comparator);
    }

    public static <V> void valueSort(V[] values, int start, int bound, Comparator<? super V> comparator) {
        if (XSort.checkRange(values, start, bound)) {
            XSort.dualPivotQuicksort(values, start, bound - 1, comparator);
        }
    }

    public static <E> E[] bufferedAdaptiveMergesort(E[] elements, E[] buffer, Comparator<? super E> comparator) {
        E[] checkedBuffer = XSort.mergesortBuffer(buffer, elements);
        XSort.adaptiveMergesort0(checkedBuffer, elements, 0, elements.length, comparator, XSort.log2(elements.length));
        return checkedBuffer;
    }

    public static <E> E[] bufferedAdaptiveMergesort(E[] elements, E[] buffer, int start, int bound, Comparator<? super E> comparator) {
        if (XSort.checkRange(elements, start, bound)) {
            E[] checkedBuffer = XSort.mergesortBuffer(buffer, elements);
            XSort.adaptiveMergesort0(checkedBuffer, elements, start, bound, comparator, XSort.log2(bound - start));
            return checkedBuffer;
        }
        return buffer;
    }

    static <E> void adaptiveMergesort0(E[] buffer, E[] values, int start, int bound, Comparator<? super E> c) {
        XSort.adaptiveMergesort0(buffer, values, start, bound, c, XSort.log2(bound - start));
    }

    static <E> void adaptiveMergesort0(E[] buffer, E[] values, int start, int bound, Comparator<? super E> c, int log2) {
        int i;
        int mid;
        block14: {
            int mult;
            if (bound - start < 7) {
                XSort.insertionsort0(values, start, bound, c);
                return;
            }
            if (log2 > 6) {
                mid = start + bound >>> 1;
                mult = mid - start >>> 5;
                i = 0;
                while (i < log2) {
                    if (c.compare(values[XSort.spotTestIndex32Left(mid, mult)], values[XSort.spotTestIndex32Right(mid, mult)]) <= 0) {
                        ++i;
                        continue;
                    }
                    break block14;
                }
                if (XSort.tryInsertionsort(values, start, bound, c)) {
                    return;
                }
                System.arraycopy(values, start, buffer, start, bound - start);
            } else {
                mid = start + bound >>> 1;
                mult = mid - start >>> 2;
                i = 1;
                while (i < log2) {
                    if (c.compare(values[XSort.spotTestIndex04Left(mid, mult)], values[XSort.spotTestIndex04Right(mid, mult)]) <= 0) {
                        ++i;
                        continue;
                    }
                    break block14;
                }
                if (XSort.tryInsertionsort(values, start, bound, c)) {
                    return;
                }
                System.arraycopy(values, start, buffer, start, bound - start);
            }
        }
        XSort.adaptiveMergesort0(values, buffer, start, mid, c, log2 - 1);
        XSort.adaptiveMergesort0(values, buffer, mid, bound, c, log2 - 1);
        if (c.compare(buffer[mid - 1], buffer[mid]) <= 0) {
            System.arraycopy(buffer, start, values, start, bound - start);
        } else {
            int l;
            i = l = start;
            int r = mid;
            while (i < bound) {
                if (r >= bound || l < mid && c.compare(buffer[l], buffer[r]) <= 0) {
                    values[i] = buffer[l];
                    ++l;
                } else {
                    values[i] = buffer[r];
                    ++r;
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static <E> void parallelSort(final E[] elements, final Comparator<? super E> comparator) {
        if (elements.length < 8192) {
            XSort.adaptiveMergesort0((Object[])elements.clone(), elements, 0, elements.length, comparator, XSort.log2(elements.length));
            return;
        }
        final Object[] buffer = (Object[])elements.clone();
        int bound = elements.length;
        final int log2length = XSort.log2(bound);
        final int mid = bound >>> 1;
        final boolean[] board = new boolean[2];
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                XSort.adaptiveMergesort0(elements, buffer, mid, elements.length, comparator, log2length);
                board[1] = true;
                if (!board[0]) return;
                boolean[] blArray = board;
                synchronized (board) {
                    board.notifyAll();
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        }.start();
        XSort.adaptiveMergesort0(elements, buffer, 0, mid, comparator, log2length);
        board[0] = true;
        if (!board[1]) {
            boolean[] blArray = board;
            // MONITORENTER : board
            try {
                while (!board[1]) {
                    board.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Unhandled interruption", e);
            }
        }
        if (comparator.compare(buffer[mid - 1], buffer[mid]) <= 0) {
            System.arraycopy(buffer, mid, elements, mid, bound - mid);
            return;
        }
        int l = 0;
        int i = 0;
        int r = mid;
        while (i < bound) {
            if (r >= bound || l < mid && comparator.compare(buffer[l], buffer[r]) <= 0) {
                elements[i] = buffer[l];
                ++l;
            } else {
                elements[i] = buffer[r];
                ++r;
            }
            ++i;
        }
    }

    public static final void sort(int[] values) throws NullPointerException {
        XSort.dualPivotQuicksort(values, 0, values.length - 1);
    }

    public static final void sort(long[] values) throws NullPointerException {
        XSort.dualPivotQuicksort(values, 0, values.length - 1);
    }

    public static final void sort(int[] values, int start, int bound) throws NullPointerException, ArrayIndexOutOfBoundsException {
        XSort.checkRange(values, start, bound);
        XSort.dualPivotQuicksort(values, start, bound - 1);
    }

    public static final <E> void quicksort(E[] values, Comparator<? super E> comparator) throws NullPointerException {
        XSort.dualPivotQuicksort(values, 0, values.length - 1, comparator);
    }

    public static final <E> void quicksort(E[] values, int start, int bound, Comparator<? super E> comparator) throws NullPointerException {
        if (XSort.checkRange(values, start, bound)) {
            XSort.dualPivotQuicksort(values, start, bound - 1, comparator);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void simpleQuicksort(int[] values, int low, int high) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (high - low < 8) {
            XSort.insertionsort0(values, low, high + 1);
            return;
        }
        left = low;
        right = high;
        pivot = values[left + right >>> 1];
        ** GOTO lbl16
        {
            ++left;
            do {
                if (values[left] < pivot) continue block0;
                while (values[right] > pivot) {
                    --right;
                }
                if (left > right) break block0;
                XSort.swap(values, left++, right--);
lbl16:
                // 2 sources

            } while (left <= right);
        }
        if (left < high) {
            XSort.simpleQuicksort(values, left, high);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static <E> void simpleQuicksort(E[] values, int low, int high, Comparator<? super E> cmp) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (high - low < 8) {
            XSort.insertionsort0(values, low, high + 1, cmp);
            return;
        }
        left = low;
        right = high;
        pivot = values[left + right >>> 1];
        ** GOTO lbl16
        {
            ++left;
            do {
                if (cmp.compare(values[left], pivot) < 0) continue block0;
                while (cmp.compare(values[right], pivot) > 0) {
                    --right;
                }
                if (left > right) break block0;
                XSort.swap(values, left++, right--);
lbl16:
                // 2 sources

            } while (left <= right);
        }
        if (right > low) {
            XSort.simpleQuicksort(values, low, right, cmp);
        }
        if (left < high) {
            XSort.simpleQuicksort(values, left, high, cmp);
        }
    }

    public static <E> void mergesort(E[] values, Comparator<? super E> comparator) {
        XSort.mergesort0((Object[])values.clone(), values, 0, values.length, comparator);
    }

    public static <E> void mergesort(E[] values, int start, int bound, Comparator<? super E> comparator) {
        if (XSort.checkRange(values, start, bound)) {
            XSort.mergesort0((Object[])values.clone(), values, start, bound, comparator);
        }
    }

    public static <E> E[] bufferMergesort(E[] values, E[] buffer, Comparator<? super E> comparator) {
        E[] checkedBuffer = XSort.mergesortBuffer(buffer, values);
        XSort.mergesort0(checkedBuffer, values, 0, values.length, comparator);
        return checkedBuffer;
    }

    public static <E> E[] bufferMergesort(E[] values, E[] buffer, int start, int bound, Comparator<? super E> comparator) {
        if (XSort.checkRange(values, start, bound)) {
            E[] checkedBuffer = XSort.mergesortBuffer(buffer, values);
            XSort.mergesort0(checkedBuffer, values, start, bound, comparator);
            return checkedBuffer;
        }
        return buffer;
    }

    private static final <E> void mergesort0(E[] buffer, E[] values, int start, int bound, Comparator<? super E> c) {
        if (bound - start < 7) {
            XSort.insertionsort0(values, start, bound, c);
            return;
        }
        int mid = start + bound >>> 1;
        XSort.mergesort0(values, buffer, start, mid, c);
        XSort.mergesort0(values, buffer, mid, bound, c);
        if (c.compare(buffer[mid - 1], buffer[mid]) <= 0) {
            System.arraycopy(buffer, start, values, start, bound - start);
        } else {
            int l;
            int i = l = start;
            int r = mid;
            while (i < bound) {
                if (r >= bound || l < mid && c.compare(buffer[l], buffer[r]) <= 0) {
                    values[i] = buffer[l];
                    ++l;
                } else {
                    values[i] = buffer[r];
                    ++r;
                }
                ++i;
            }
        }
    }

    public static void distinctsort(int[] values) {
        int[] buffer = new int[values.length];
        XSort.distinctsortInto0(values, buffer);
        System.arraycopy(buffer, 0, values, 0, values.length);
    }

    public static void copyDistinctsort(int[] values, int[] target) {
        XSort.distinctsortInto0(values, target);
    }

    public static void bufferDistinctsort(int[] values, int[] buffer) {
        XSort.distinctsortInto0(values, buffer);
        System.arraycopy(buffer, 0, values, 0, values.length);
    }

    private static void distinctsortInto0(int[] values, int[] target) {
        int targetLast;
        int length = values.length;
        int distinctsLowBound = targetLast = target.length - 1;
        target[targetLast] = values[0];
        int i = 1;
        while (i < length) {
            int t = targetLast;
            while (t >= distinctsLowBound) {
                if (target[t] == values[i]) break;
                target[--distinctsLowBound] = values[i];
                --t;
            }
            ++i;
        }
        XSort.simpleQuicksort(target, distinctsLowBound, targetLast);
        int targetIndex = -1;
        while (distinctsLowBound <= targetLast) {
            int current = target[distinctsLowBound];
            int i2 = 0;
            while (i2 < length) {
                if (values[i2] == current) {
                    target[++targetIndex] = values[i2];
                }
                ++i2;
            }
            ++distinctsLowBound;
        }
    }

    public static <E> void distinctsort(E[] values, Comparator<? super E> comparator) {
        Object[] buffer = new Object[values.length];
        XSort.distinctsortInto(values, buffer, 0, values.length, comparator);
        System.arraycopy(buffer, 0, values, 0, values.length);
    }

    public static <E> void bufferDistinctsort(E[] values, E[] buffer, Comparator<? super E> comparator) {
        XSort.distinctsortInto(values, buffer, 0, values.length, comparator);
        System.arraycopy(buffer, 0, values, 0, values.length);
    }

    public static <E> void distinctsortInto(E[] values, E[] target, Comparator<? super E> comparator) {
        XSort.distinctsortInto(values, target, 0, values.length, comparator);
    }

    private static <E> void distinctsortInto(E[] values, E[] target, int start, int bound, Comparator<? super E> comparator) {
        E last7;
        int targetLast;
        int distinctsLowBound = targetLast = bound - 1;
        E last6 = last7 = values[start];
        E last5 = last7;
        E last4 = last7;
        E last3 = last7;
        E last2 = last7;
        E last1 = last7;
        E current = last7;
        target[targetLast] = last7;
        int distinctScanBound = targetLast + 7;
        int i = start + 1;
        while (i < bound) {
            block7: {
                if (comparator.compare(current, current = values[i]) != 0 && comparator.compare(current, last1) != 0 && comparator.compare(current, last2) != 0 && comparator.compare(current, last3) != 0 && comparator.compare(current, last4) != 0 && comparator.compare(current, last5) != 0 && comparator.compare(current, last6) != 0 && comparator.compare(current, last7) != 0) {
                    int t = targetLast;
                    while (t >= distinctScanBound) {
                        if (comparator.compare(current, target[t]) != 0) {
                            --t;
                            continue;
                        }
                        break block7;
                    }
                    target[--distinctsLowBound] = current;
                    last7 = last6;
                    last6 = last5;
                    last5 = last4;
                    last4 = last3;
                    last3 = last2;
                    last2 = last1;
                    last1 = current;
                    --distinctScanBound;
                }
            }
            ++i;
        }
        XSort.simpleQuicksort(target, distinctsLowBound, targetLast, comparator);
        int targetIndex = start - 1;
        while (distinctsLowBound <= targetLast) {
            current = target[distinctsLowBound];
            int i2 = start;
            while (i2 < bound) {
                if (comparator.compare(current, values[i2]) == 0) {
                    target[++targetIndex] = values[i2];
                }
                ++i2;
            }
            ++distinctsLowBound;
        }
    }

    public static void quicksortDualPivot(int[] values) {
        XSort.dualPivotQuicksort(values, 0, values.length - 1);
    }

    public static <E> void quicksortDualPivot(E[] values, Comparator<? super E> comparator) {
        XSort.dualPivotQuicksort(values, 0, values.length - 1, comparator);
    }

    /*
     * Unable to fully structure code
     */
    private static void dualPivotQuicksort(int[] a, int low, int high) {
        block35: {
            block34: {
                if (high - low < 31) {
                    XSort.insertionsort0(a, low, high + 1);
                    return;
                }
                seventh = (high - low + 1 >>> 3) + (high - low + 1 >>> 6) + 1;
                e3 = low + high >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                left = low;
                right = high;
                pivot1 = a[e2];
                pivot2 = a[e4];
                if (pivot1 == pivot2) break block34;
                a[e2] = a[low];
                a[e4] = a[high];
                while (a[++left] < pivot1) {
                }
                while (a[--right] > pivot2) {
                }
                k = left;
                block2: while (k <= right) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[left];
                        a[left] = ak;
                        ++left;
                    } else if (ak > pivot2) {
                        while (a[right] > pivot2) {
                            if (right-- == k) break block2;
                        }
                        if (a[right] < pivot1) {
                            a[k] = a[left];
                            a[left] = a[right];
                            ++left;
                        } else {
                            a[k] = a[right];
                        }
                        a[right] = ak;
                        --right;
                    }
                    ++k;
                }
                a[low] = a[left - 1];
                a[left - 1] = pivot1;
                a[high] = a[right + 1];
                a[right + 1] = pivot2;
                XSort.dualPivotQuicksort(a, low, left - 2);
                XSort.dualPivotQuicksort(a, right + 2, high);
                if (left < e1 && e5 < right) {
                    while (a[left] == pivot1) {
                        ++left;
                    }
                    while (a[right] == pivot2) {
                        --right;
                    }
                    k = left;
                    block6: while (k <= right) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[left];
                            a[left] = ak;
                            ++left;
                        } else if (ak == pivot2) {
                            while (a[right] == pivot2) {
                                if (right-- == k) break block6;
                            }
                            if (a[right] == pivot1) {
                                a[k] = a[left];
                                a[left] = pivot1;
                                ++left;
                            } else {
                                a[k] = a[right];
                            }
                            a[right] = ak;
                            --right;
                        }
                        ++k;
                    }
                }
                XSort.dualPivotQuicksort(a, left, right);
                break block35;
            }
            k = low;
            while (k <= right) {
                block36: {
                    if (a[k] == pivot1) break block36;
                    ak = a[k];
                    if (ak >= pivot1) ** GOTO lbl125
                    a[k] = a[left];
                    a[left] = ak;
                    ++left;
                    break block36;
lbl-1000:
                    // 1 sources

                    {
                        --right;
lbl125:
                        // 2 sources

                        ** while (a[right] > pivot1)
                    }
lbl126:
                    // 1 sources

                    if (a[right] < pivot1) {
                        a[k] = a[left];
                        a[left] = a[right];
                        ++left;
                    } else {
                        a[k] = pivot1;
                    }
                    a[right] = ak;
                    --right;
                }
                ++k;
            }
            XSort.dualPivotQuicksort(a, low, left - 1);
            XSort.dualPivotQuicksort(a, right + 1, high);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void dualPivotQuicksort(long[] a, int low, int high) {
        block35: {
            block34: {
                if (high - low < 31) {
                    XSort.insertionsort0(a, low, high + 1);
                    return;
                }
                seventh = (high - low + 1 >>> 3) + (high - low + 1 >>> 6) + 1;
                e3 = low + high >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (a[e2] < a[e1]) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (a[e3] < a[e2]) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (t < a[e1]) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (a[e4] < a[e3]) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (t < a[e2]) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (t < a[e1]) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (a[e5] < a[e4]) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (t < a[e3]) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (t < a[e2]) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (t < a[e1]) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                left = low;
                right = high;
                pivot1 = a[e2];
                pivot2 = a[e4];
                if (pivot1 == pivot2) break block34;
                a[e2] = a[low];
                a[e4] = a[high];
                while (a[++left] < pivot1) {
                }
                while (a[--right] > pivot2) {
                }
                k = left;
                block2: while (k <= right) {
                    ak = a[k];
                    if (ak < pivot1) {
                        a[k] = a[left];
                        a[left] = ak;
                        ++left;
                    } else if (ak > pivot2) {
                        while (a[right] > pivot2) {
                            if (right-- == k) break block2;
                        }
                        if (a[right] < pivot1) {
                            a[k] = a[left];
                            a[left] = a[right];
                            ++left;
                        } else {
                            a[k] = a[right];
                        }
                        a[right] = ak;
                        --right;
                    }
                    ++k;
                }
                a[low] = a[left - 1];
                a[left - 1] = pivot1;
                a[high] = a[right + 1];
                a[right + 1] = pivot2;
                XSort.dualPivotQuicksort(a, low, left - 2);
                XSort.dualPivotQuicksort(a, right + 2, high);
                if (left < e1 && e5 < right) {
                    while (a[left] == pivot1) {
                        ++left;
                    }
                    while (a[right] == pivot2) {
                        --right;
                    }
                    k = left;
                    block6: while (k <= right) {
                        ak = a[k];
                        if (ak == pivot1) {
                            a[k] = a[left];
                            a[left] = ak;
                            ++left;
                        } else if (ak == pivot2) {
                            while (a[right] == pivot2) {
                                if (right-- == k) break block6;
                            }
                            if (a[right] == pivot1) {
                                a[k] = a[left];
                                a[left] = pivot1;
                                ++left;
                            } else {
                                a[k] = a[right];
                            }
                            a[right] = ak;
                            --right;
                        }
                        ++k;
                    }
                }
                XSort.dualPivotQuicksort(a, left, right);
                break block35;
            }
            k = low;
            while (k <= right) {
                block36: {
                    if (a[k] == pivot1) break block36;
                    ak = a[k];
                    if (ak >= pivot1) ** GOTO lbl125
                    a[k] = a[left];
                    a[left] = ak;
                    ++left;
                    break block36;
lbl-1000:
                    // 1 sources

                    {
                        --right;
lbl125:
                        // 2 sources

                        ** while (a[right] > pivot1)
                    }
lbl126:
                    // 1 sources

                    if (a[right] < pivot1) {
                        a[k] = a[left];
                        a[left] = a[right];
                        ++left;
                    } else {
                        a[k] = pivot1;
                    }
                    a[right] = ak;
                    --right;
                }
                ++k;
            }
            XSort.dualPivotQuicksort(a, low, left - 1);
            XSort.dualPivotQuicksort(a, right + 1, high);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static <E> void dualPivotQuicksort(E[] a, int low, int high, Comparator<? super E> cmp) {
        block35: {
            block34: {
                if (high - low < 16) {
                    XSort.insertionsort0(a, low, high + 1, cmp);
                    return;
                }
                seventh = (high - low + 1 >>> 3) + (high - low + 1 >>> 6) + 1;
                e3 = low + high >>> 1;
                e2 = e3 - seventh;
                e1 = e2 - seventh;
                e4 = e3 + seventh;
                e5 = e4 + seventh;
                if (cmp.compare(a[e2], a[e1]) < 0) {
                    t = a[e2];
                    a[e2] = a[e1];
                    a[e1] = t;
                }
                if (cmp.compare(a[e3], a[e2]) < 0) {
                    t = a[e3];
                    a[e3] = a[e2];
                    a[e2] = t;
                    if (cmp.compare(t, a[e1]) < 0) {
                        a[e2] = a[e1];
                        a[e1] = t;
                    }
                }
                if (cmp.compare(a[e4], a[e3]) < 0) {
                    t = a[e4];
                    a[e4] = a[e3];
                    a[e3] = t;
                    if (cmp.compare(t, a[e2]) < 0) {
                        a[e3] = a[e2];
                        a[e2] = t;
                        if (cmp.compare(t, a[e1]) < 0) {
                            a[e2] = a[e1];
                            a[e1] = t;
                        }
                    }
                }
                if (cmp.compare(a[e5], a[e4]) < 0) {
                    t = a[e5];
                    a[e5] = a[e4];
                    a[e4] = t;
                    if (cmp.compare(t, a[e3]) < 0) {
                        a[e4] = a[e3];
                        a[e3] = t;
                        if (cmp.compare(t, a[e2]) < 0) {
                            a[e3] = a[e2];
                            a[e2] = t;
                            if (cmp.compare(t, a[e1]) < 0) {
                                a[e2] = a[e1];
                                a[e1] = t;
                            }
                        }
                    }
                }
                left = low;
                right = high;
                pivot1 = a[e2];
                pivot2 = a[e4];
                if (cmp.compare(pivot1, pivot2) == 0) break block34;
                a[e2] = a[low];
                a[e4] = a[high];
                while (cmp.compare(a[++left], pivot1) < 0) {
                }
                while (cmp.compare(a[--right], pivot2) > 0) {
                }
                k = left;
                block2: while (k <= right) {
                    ak = a[k];
                    if (cmp.compare(ak, pivot1) < 0) {
                        a[k] = a[left];
                        a[left] = ak;
                        ++left;
                    } else if (cmp.compare(ak, pivot2) > 0) {
                        while (cmp.compare(a[right], pivot2) > 0) {
                            if (right-- == k) break block2;
                        }
                        if (cmp.compare(a[right], pivot1) < 0) {
                            a[k] = a[left];
                            a[left] = a[right];
                            ++left;
                        } else {
                            a[k] = a[right];
                        }
                        a[right] = ak;
                        --right;
                    }
                    ++k;
                }
                a[low] = a[left - 1];
                a[left - 1] = pivot1;
                a[high] = a[right + 1];
                a[right + 1] = pivot2;
                XSort.dualPivotQuicksort(a, low, left - 2, cmp);
                XSort.dualPivotQuicksort(a, right + 2, high, cmp);
                if (left < e1 && e5 < right) {
                    while (cmp.compare(a[left], pivot1) == 0) {
                        ++left;
                    }
                    while (cmp.compare(a[right], pivot2) == 0) {
                        --right;
                    }
                    k = left;
                    block6: while (k <= right) {
                        ak = a[k];
                        if (cmp.compare(ak, pivot1) == 0) {
                            a[k] = a[left];
                            a[left] = ak;
                            ++left;
                        } else if (cmp.compare(ak, pivot2) == 0) {
                            while (cmp.compare(a[right], pivot2) == 0) {
                                if (right-- == k) break block6;
                            }
                            if (cmp.compare(a[right], pivot1) == 0) {
                                a[k] = a[left];
                                a[left] = pivot1;
                                ++left;
                            } else {
                                a[k] = a[right];
                            }
                            a[right] = ak;
                            --right;
                        }
                        ++k;
                    }
                }
                XSort.dualPivotQuicksort(a, left, right, cmp);
                break block35;
            }
            k = low;
            while (k <= right) {
                block36: {
                    if (cmp.compare(a[k], pivot1) == 0) break block36;
                    ak = a[k];
                    if (cmp.compare(ak, pivot1) >= 0) ** GOTO lbl125
                    a[k] = a[left];
                    a[left] = ak;
                    ++left;
                    break block36;
lbl-1000:
                    // 1 sources

                    {
                        --right;
lbl125:
                        // 2 sources

                        ** while (cmp.compare(a[right], pivot1) > 0)
                    }
lbl126:
                    // 1 sources

                    if (cmp.compare(a[right], pivot1) < 0) {
                        a[k] = a[left];
                        a[left] = a[right];
                        ++left;
                    } else {
                        a[k] = pivot1;
                    }
                    a[right] = ak;
                    --right;
                }
                ++k;
            }
            XSort.dualPivotQuicksort(a, low, left - 1, cmp);
            XSort.dualPivotQuicksort(a, right + 1, high, cmp);
        }
    }

    public static boolean isIncreasing(int[] values) {
        int i = 1;
        while (i < values.length) {
            if (values[i - 1] > values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isStrictlyIncreasing(int[] values) {
        int i = 1;
        while (i < values.length) {
            if (values[i - 1] >= values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDecreasing(int[] values) {
        int i = 1;
        while (i < values.length) {
            if (values[i - 1] < values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isStrictlyDecreasing(int[] values) {
        int i = 1;
        while (i < values.length) {
            if (values[i - 1] <= values[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIncreasing(int[] values, int startIndex, int endIndex) {
        int d = XSort.checkIterationRange(values, startIndex, endIndex);
        if (d == 0) {
            return true;
        }
        int i = startIndex;
        while (i != endIndex) {
            if (values[i] <= values[i += d]) continue;
            return false;
        }
        return true;
    }

    public static boolean isStrictlyIncreasing(int[] values, int startIndex, int endIndex) {
        int d = XSort.checkIterationRange(values, startIndex, endIndex);
        if (d == 0) {
            return true;
        }
        int i = startIndex;
        while (i != endIndex) {
            if (values[i] < values[i += d]) continue;
            return false;
        }
        return true;
    }

    public static boolean isDecreasing(int[] values, int startIndex, int endIndex) {
        int d = XSort.checkIterationRange(values, startIndex, endIndex);
        if (d == 0) {
            return true;
        }
        int i = startIndex;
        while (i != endIndex) {
            if (values[i] >= values[i += d]) continue;
            return false;
        }
        return true;
    }

    public static boolean isStrictlyDecreasing(int[] values, int startIndex, int endIndex) {
        int d = XSort.checkIterationRange(values, startIndex, endIndex);
        if (d == 0) {
            return true;
        }
        int i = startIndex;
        while (i != endIndex) {
            if (values[i] > values[i += d]) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isSorted(E[] values, Comparator<? super E> comparator) {
        int i = 1;
        while (i < values.length) {
            if (comparator.compare(values[i - 1], values[i]) > 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <E> boolean isStrictlySorted(E[] values, Comparator<? super E> comparator) {
        int i = 1;
        while (i < values.length) {
            if (comparator.compare(values[i - 1], values[i]) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <E> boolean isReverseSorted(E[] values, int startIndex, int endIndex, Comparator<? super E> comparator) {
        int d = XSort.checkIterationRange(values, startIndex, endIndex);
        if (d == 0) {
            return true;
        }
        int i = startIndex;
        while (i != endIndex) {
            if (comparator.compare(values[i], values[i += d]) >= 0) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean isStrictlyReverseSorted(E[] values, int startIndex, int endIndex, Comparator<? super E> comparator) {
        int d = XSort.checkIterationRange(values, startIndex, endIndex);
        if (d == 0) {
            return true;
        }
        int i = startIndex;
        while (i != endIndex) {
            if (comparator.compare(values[i], values[i += d]) > 0) continue;
            return false;
        }
        return true;
    }

    public static int uniformitySimple(int ... values) {
        int uniformity = 0;
        int last = values[0];
        int i = 1;
        while (i < values.length) {
            int current = values[i];
            if (current == last) {
                ++uniformity;
            }
            last = current;
            ++i;
        }
        return uniformity;
    }

    public static double uniformity(int ... values) {
        int uniformity = 0;
        int growth = 1;
        int last = values[0];
        int length = values.length;
        int i = 1;
        while (i < length) {
            int current = values[i];
            if (current == last) {
                uniformity += ++growth;
            } else {
                growth = 0;
            }
            last = current;
            ++i;
        }
        return (double)uniformity * 2.0 / (double)(length * (length + 1));
    }

    private XSort() {
        throw new UnsupportedOperationException();
    }
}

