/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections.lazy;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import one.microstream.branching.ThrowBreak;
import one.microstream.collections.lazy.LazyCollection;
import one.microstream.collections.lazy.LazySegment;
import one.microstream.collections.lazy.LazySegmentUnloader;
import one.microstream.collections.lazy.LazySet;
import one.microstream.reference.ControlledLazyReference;
import one.microstream.reference.Lazy;
import one.microstream.reference.LazyClearController;
import one.microstream.reference.ObjectSwizzling;

public final class LazyHashMap<K, V>
implements Map<K, V> {
    private static final int MAX_SEGMENT_SIZE_DEFAULT = 1000;
    private final int maxSegmentSize;
    private final ArrayList<Segment<Entry<K, V>>> segments;
    private int size;
    private int modCount;
    private transient ObjectSwizzling loader;
    private final LazySegmentUnloader unloader;

    public LazyHashMap() {
        this.maxSegmentSize = 1000;
        this.segments = new ArrayList();
        this.unloader = new LazySegmentUnloader.Default(5);
    }

    public LazyHashMap(int maxSegmentSize) {
        if (maxSegmentSize < 0) {
            throw new IllegalArgumentException("Illegal maxSegmentSize: " + maxSegmentSize + ". Must be 0 or greater!");
        }
        this.maxSegmentSize = maxSegmentSize;
        this.segments = new ArrayList();
        this.unloader = new LazySegmentUnloader.Default(5);
    }

    public LazyHashMap(int maxSegmentSize, LazySegmentUnloader lazySegmentUnloader) {
        if (maxSegmentSize < 0) {
            throw new IllegalArgumentException("Illegal maxSegmentSize: " + maxSegmentSize + ". Must be 0 or greater!");
        }
        this.maxSegmentSize = maxSegmentSize;
        this.segments = new ArrayList();
        this.unloader = lazySegmentUnloader;
    }

    public LazyHashMap(LazyHashMap<K, V> map) {
        this.maxSegmentSize = map.maxSegmentSize;
        this.segments = new ArrayList();
        this.unloader = map.unloader.copy();
        this.putAll(map);
    }

    public long getSegmentCount() {
        return this.segments.size();
    }

    public Iterable<? extends Segment<?>> segments() {
        return this.segments;
    }

    public int getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    protected int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }

    private Segment<Entry<K, V>> searchSegment(int hash, int lowSegmentIndex, int highSegmentIndex) {
        if (this.segments.size() < 1) {
            return null;
        }
        int hi = highSegmentIndex;
        int lo = lowSegmentIndex;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            Segment<Entry<K, V>> segment = this.segments.get(mid);
            int cmp = segment.compareHash(hash);
            if (cmp == 0) {
                return segment;
            }
            if (cmp < 0) {
                hi = mid - 1;
                continue;
            }
            lo = mid + 1;
        }
        throw new NoSuchElementException("No segment found for hash " + hash);
    }

    private Entry<K, V> insert(Entry<K, V> entry) {
        Segment<Entry<K, V>> segment = this.searchSegment(entry.hash, 0, this.segments.size());
        if (segment == null) {
            segment = new Segment(this.maxSegmentSize);
            this.segments.add(segment);
        }
        Entry retVal = segment.insert(entry);
        if (segment.segmentSize > this.maxSegmentSize) {
            int smin = ((Entry)((ArrayList)segment.getData()).get((int)0)).hash;
            int smax = ((Entry)((ArrayList)segment.getData()).get((int)(segment.segmentSize - 1))).hash;
            int mid = (int)(((long)smin + (long)smax) / 2L);
            int splitIndex = segment.findNextPosition(mid);
            if (splitIndex == 0 || splitIndex > segment.segmentSize - 1) {
                return retVal;
            }
            Segment newSegment = segment.split(splitIndex);
            newSegment.min = mid;
            newSegment.max = segment.max;
            segment.max = mid;
            this.segments.add(this.segments.indexOf(segment) + 1, newSegment);
        }
        return retVal;
    }

    private Entry<K, V> getByHash(Object key) {
        int hash = this.hash(key);
        Segment<Entry<K, V>> segment = this.searchSegment(hash, 0, this.segments.size());
        if (segment == null) {
            return null;
        }
        return segment.getByHash(hash, key);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size < 1;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getByHash(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        for (Segment<Entry<K, V>> segment : this.segments) {
            Iterator iterator = ((ArrayList)segment.getData()).iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry.value != value && (entry.value == null || !entry.value.equals(value))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public V get(Object key) {
        Entry<K, V> result = this.getByHash(key);
        if (result == null) {
            return null;
        }
        return result.value;
    }

    @Override
    public V put(K key, V value) {
        ++this.modCount;
        Entry<K, V> oldEntry = this.insert(new Entry<K, V>(this.hash(key), key, value));
        if (oldEntry != null) {
            return oldEntry.value;
        }
        ++this.size;
        return null;
    }

    @Override
    public V remove(Object key) {
        if (this.segments.size() < 1) {
            return null;
        }
        int hash = this.hash(key);
        Segment<Entry<K, V>> s = this.searchSegment(hash, 0, this.segments.size());
        Optional removedValue = s.remove(key);
        if (removedValue == null) {
            return null;
        }
        --this.size;
        ++this.modCount;
        this.removeSegmentIfEmpty(s);
        return removedValue.orElse(null);
    }

    @Override
    public V replace(K key, V value) {
        if (this.segments.size() < 1) {
            return null;
        }
        int hash = this.hash(key);
        Segment<Entry<K, V>> s = this.searchSegment(hash, 0, this.segments.size());
        Optional<V> replacedValue = s.replace(hash, key, value);
        if (replacedValue == null) {
            return null;
        }
        ++this.modCount;
        return replacedValue.orElse(null);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        if (this.segments.size() < 1) {
            return false;
        }
        int hash = this.hash(key);
        Segment<Entry<K, V>> s = this.searchSegment(hash, 0, this.segments.size());
        boolean replaced = s.replace(hash, key, oldValue, newValue);
        if (replaced) {
            ++this.modCount;
        }
        return replaced;
    }

    private boolean removeSegmentIfEmpty(Segment<Entry<K, V>> segment) {
        if (segment.segmentSize < 1) {
            int index = this.segments.indexOf(segment);
            if (index > 0) {
                Segment<Entry<K, V>> left = this.segments.get(index - 1);
                left.max = segment.max;
            } else if (this.segments.size() > 1) {
                Segment<Entry<K, V>> right = this.segments.get(index + 1);
                right.min = segment.min;
            }
            this.segments.remove(index);
            this.unloader.remove(segment);
            return true;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            K key = e.getKey();
            V value = e.getValue();
            this.put(key, value);
        }
    }

    @Override
    public void clear() {
        this.segments.clear();
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public LazySet<K> keySet() {
        return new KeySet();
    }

    @Override
    public LazyCollection<V> values() {
        return new Values();
    }

    @Override
    public LazySet<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    public String toString() {
        Iterator<Segment<?>> segmentsIterator = this.segments().iterator();
        if (!segmentsIterator.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Segment<?> s = segmentsIterator.next();
            sb.append(s.toString());
            if (!segmentsIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    private void addSegment(int min, int max, int segmentSize, Object data) {
        this.segments.add(new Segment(min, max, segmentSize, (ControlledLazyReference)data));
    }

    private IndexPosition calculateIndexPosition(int index) {
        Objects.checkIndex(index, this.size);
        int segmentIndex = 0;
        int segmentStartIndex = 0;
        for (Segment<Entry<K, V>> segment : this.segments) {
            if (segmentStartIndex + segment.segmentSize - 1 >= index) {
                return new IndexPosition(segmentIndex, segmentStartIndex, segment.segmentSize);
            }
            ++segmentIndex;
            segmentStartIndex += segment.segmentSize;
        }
        throw new NoSuchElementException("Can't determine IndexPosition for index " + index);
    }

    public void link(ObjectSwizzling objectLoader) {
        if (this.loader != null) {
            return;
        }
        this.loader = objectLoader;
    }

    public void verifyLoader(ObjectSwizzling objectLoader) {
        if (this.loader != null && this.loader != objectLoader) {
            throw new IllegalStateException("Map already bound to an other storage!");
        }
    }

    public static class Entry<K, V>
    implements Map.Entry<K, V> {
        protected final int hash;
        protected final K key;
        protected V value;

        public Entry(int hash, K key, V value) {
            this.hash = hash;
            this.key = key;
            this.value = value;
        }

        public int getHash() {
            return this.hash;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        public final int hashCode() {
            return Objects.hashCode(this.hash) ^ Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Entry) {
                Entry e = (Entry)obj;
                return Objects.equals(this.hash, e.getHash()) && Objects.equals(this.key, e.getKey()) && Objects.equals(this.value, e.getValue());
            }
            return false;
        }
    }

    final class EntryIterator
    extends LazyMapIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public final Entry<K, V> next() {
            return super.nextEntry();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>>
    implements LazySet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public int size() {
            return LazyHashMap.this.size;
        }

        @Override
        public void clear() {
            LazyHashMap.this.clear();
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(LazyHashMap.this, 0, -1, 0);
        }

        @Override
        public <P extends Consumer<Lazy<?>>> P iterateLazyReferences(P procedure) {
            try {
                for (Segment segment : LazyHashMap.this.segments) {
                    procedure.accept(segment.data);
                }
            }
            catch (ThrowBreak throwBreak) {
                // empty catch block
            }
            return procedure;
        }

        @Override
        public boolean consolidate() {
            return false;
        }

        @Override
        public void tryUnload(boolean unloadAll) {
            LazyHashMap.this.unloader.unload(unloadAll);
        }
    }

    static class EntrySpliterator<K, V>
    extends SegmentsSpliterator<K, V>
    implements Spliterator<Map.Entry<K, V>> {
        public EntrySpliterator(LazyHashMap<K, V> map, int index, int fence, int expectedModCount) {
            super(map, index, fence, expectedModCount);
        }

        @Override
        public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int hi = this.getFence();
            if (this.index < hi) {
                this.currentSegment.allowUnload(false);
                Map.Entry entry = (Map.Entry)((ArrayList)this.currentSegment.getData()).get(this.localIndex);
                action.accept(entry);
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                ++this.index;
                if (this.index >= hi) {
                    return true;
                }
                if (this.localIndex < this.currentSegment.segmentSize - 1) {
                    ++this.localIndex;
                } else {
                    this.localIndex = 0;
                    ++this.segmentIndex;
                    this.currentSegment.allowUnload(true);
                    this.currentSegment = this.map.segments.get(this.segmentIndex);
                }
                return true;
            }
            this.currentSegment.allowUnload(true);
            return false;
        }

        @Override
        public Spliterator<Map.Entry<K, V>> trySplit() {
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            IndexPosition sIndex = this.map.calculateIndexPosition(mid);
            if (lo < mid) {
                if (hi <= sIndex.segmentStartIndex + sIndex.segmentSize && lo >= sIndex.segmentStartIndex) {
                    return null;
                }
                int dist_lo = mid - sIndex.segmentStartIndex;
                int dist_hi = sIndex.segmentStartIndex + sIndex.segmentSize - mid;
                int splitIndex = dist_lo < dist_hi ? sIndex.segmentStartIndex : sIndex.segmentStartIndex + sIndex.segmentSize;
                this.index = splitIndex;
                this.segmentIndex = this.map.calculateIndexPosition((int)this.index).segmentIndex;
                this.currentSegment = this.map.segments.get(this.segmentIndex);
                return new EntrySpliterator<K, V>(this.map, lo, splitIndex, this.expectedModCount);
            }
            return null;
        }
    }

    private static class IndexPosition {
        int segmentIndex;
        int segmentStartIndex;
        int segmentSize;

        public IndexPosition(int segmentIndex, int segmentStartIndex, int segmentSize) {
            this.segmentIndex = segmentIndex;
            this.segmentStartIndex = segmentStartIndex;
            this.segmentSize = segmentSize;
        }
    }

    final class KeyIterator
    extends LazyMapIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public final K next() {
            return super.nextEntry().getKey();
        }
    }

    final class KeySet
    extends AbstractSet<K>
    implements LazySet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return LazyHashMap.this.size;
        }

        @Override
        public void clear() {
            LazyHashMap.this.clear();
        }

        @Override
        public final Spliterator<K> spliterator() {
            return new KeySpliterator(LazyHashMap.this, 0, -1, 0);
        }

        @Override
        public <P extends Consumer<Lazy<?>>> P iterateLazyReferences(P procedure) {
            try {
                for (Segment segment : LazyHashMap.this.segments) {
                    procedure.accept(segment.data);
                }
            }
            catch (ThrowBreak throwBreak) {
                // empty catch block
            }
            return procedure;
        }

        @Override
        public boolean consolidate() {
            return false;
        }

        @Override
        public void tryUnload(boolean unloadAll) {
            LazyHashMap.this.unloader.unload(unloadAll);
        }
    }

    static class KeySpliterator<K, V>
    extends SegmentsSpliterator<K, V>
    implements Spliterator<K> {
        public KeySpliterator(LazyHashMap<K, V> map, int index, int fence, int expectedModCount) {
            super(map, index, fence, expectedModCount);
        }

        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int hi = this.getFence();
            if (this.index < hi) {
                this.currentSegment.allowUnload(false);
                Object key = ((Entry)((ArrayList)this.currentSegment.getData()).get((int)this.localIndex)).key;
                action.accept(key);
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                ++this.index;
                if (this.index >= hi) {
                    return true;
                }
                if (this.localIndex < this.currentSegment.segmentSize - 1) {
                    ++this.localIndex;
                } else {
                    this.localIndex = 0;
                    ++this.segmentIndex;
                    this.currentSegment.allowUnload(true);
                    this.currentSegment = this.map.segments.get(this.segmentIndex);
                }
                return true;
            }
            this.currentSegment.allowUnload(true);
            return false;
        }

        @Override
        public Spliterator<K> trySplit() {
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            IndexPosition sIndex = this.map.calculateIndexPosition(mid);
            if (lo < mid) {
                if (hi <= sIndex.segmentStartIndex + sIndex.segmentSize && lo >= sIndex.segmentStartIndex) {
                    return null;
                }
                int dist_lo = mid - sIndex.segmentStartIndex;
                int dist_hi = sIndex.segmentStartIndex + sIndex.segmentSize - mid;
                int splitIndex = dist_lo < dist_hi ? sIndex.segmentStartIndex : sIndex.segmentStartIndex + sIndex.segmentSize;
                this.index = splitIndex;
                this.segmentIndex = this.map.calculateIndexPosition((int)this.index).segmentIndex;
                this.currentSegment = this.map.segments.get(this.segmentIndex);
                return new KeySpliterator<K, V>(this.map, lo, splitIndex, this.expectedModCount);
            }
            return null;
        }
    }

    public static class LazyHashMapSegmentEntryList<K, V>
    extends ArrayList<Entry<K, V>> {
        public LazyHashMapSegmentEntryList(int initialCapacity) {
            super(initialCapacity);
        }

        public void addEntry(int hash, Object key, Object value) {
            this.add(new Entry<Object, Object>(hash, key, value));
        }
    }

    private abstract class LazyMapIterator {
        private int segmentIndex = -1;
        private int localIndex = -1;
        private int currentLocalIndex = -1;
        private int nextIndex = -1;
        private final int expectedModCount;
        private Segment<Entry<K, V>> currentSegment;

        public LazyMapIterator() {
            this.expectedModCount = LazyHashMap.this.modCount;
            if (LazyHashMap.this.size > 0) {
                this.nextIndex = 0;
                this.segmentIndex = 0;
                this.localIndex = 0;
            }
        }

        public boolean hasNext() {
            return this.nextIndex >= 0;
        }

        public Entry<K, V> nextEntry() {
            if (LazyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentSegment = LazyHashMap.this.segments.get(this.segmentIndex);
            Entry e = (Entry)((ArrayList)this.currentSegment.getData()).get(this.localIndex);
            this.currentLocalIndex = this.localIndex;
            ++this.nextIndex;
            if (this.nextIndex >= LazyHashMap.this.size) {
                this.nextIndex = -1;
            } else if (this.localIndex < this.currentSegment.segmentSize - 1) {
                ++this.localIndex;
            } else {
                this.localIndex = 0;
                ++this.segmentIndex;
            }
            return e;
        }

        public final void remove() {
            if (this.currentLocalIndex < 0) {
                throw new IllegalStateException();
            }
            if (LazyHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.currentSegment.remove(this.currentLocalIndex);
            --LazyHashMap.this.size;
            if (this.nextIndex > LazyHashMap.this.size) {
                this.nextIndex = -1;
            }
            this.currentLocalIndex = -1;
            this.localIndex = Math.max(0, --this.localIndex);
            --this.nextIndex;
            if (LazyHashMap.this.removeSegmentIfEmpty(this.currentSegment)) {
                this.localIndex = 0;
                --this.segmentIndex;
            }
        }
    }

    public final class Segment<E extends Entry<K, V>>
    implements LazyClearController,
    LazySegment<LazyHashMapSegmentEntryList<K, V>> {
        private final ControlledLazyReference<LazyHashMapSegmentEntryList<K, V>> data;
        private int min;
        private int max;
        private int segmentSize;
        private transient boolean modified;
        private boolean allowUnloading = true;

        Segment(int initialCapacity) {
            this.data = Lazy.register(new ControlledLazyReference.Default(new LazyHashMapSegmentEntryList(initialCapacity), this));
            this.min = Integer.MIN_VALUE;
            this.max = Integer.MAX_VALUE;
            this.modified = true;
        }

        Segment(int min, int max, int segmentSize, ControlledLazyReference<LazyHashMapSegmentEntryList<K, V>> data) {
            this.min = min;
            this.max = max;
            this.segmentSize = segmentSize;
            this.data = data;
            this.data.setLazyClearController(this);
        }

        @Override
        public int size() {
            return this.segmentSize;
        }

        @Override
        public boolean isLoaded() {
            return this.data.isLoaded();
        }

        @Override
        public boolean isModified() {
            return this.modified;
        }

        @Override
        public void unloadSegment() {
            this.data.clear();
            this.allowUnloading = true;
        }

        private void cleanModified() {
            this.modified = false;
        }

        private Lazy<LazyHashMapSegmentEntryList<K, V>> getLazy() {
            return this.data;
        }

        @Override
        public LazyHashMapSegmentEntryList<K, V> getData() {
            LazyHashMap.this.unloader.unload(this);
            return (LazyHashMapSegmentEntryList)this.data.get();
        }

        private LazyHashMapSegmentEntryList<K, V> getLazyData() {
            return (LazyHashMapSegmentEntryList)this.data.get();
        }

        public int compareHash(int hash) {
            if (hash < this.min) {
                return -1;
            }
            if (hash >= this.max) {
                return 1;
            }
            return 0;
        }

        public Entry<K, V> getByHash(int hash, Object key) {
            Object entries = this.getData();
            Iterator iterator = ((ArrayList)entries).iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if ((entry.hash != hash || entry.key != null) && (entry.key == null || !entry.key.equals(key))) continue;
                return entry;
            }
            return null;
        }

        private Optional<V> remove(Object key) {
            Object entries = this.getData();
            Iterator iterator = ((ArrayList)entries).iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                if (entry.key != null && !entry.key.equals(key)) continue;
                ((ArrayList)entries).remove(entry);
                this.modified = true;
                --this.segmentSize;
                return Optional.ofNullable(entry.value);
            }
            return null;
        }

        private Entry<K, V> remove(int i) {
            --this.segmentSize;
            this.modified = true;
            return (Entry)((ArrayList)this.getData()).remove(i);
        }

        private Entry<K, V> insert(E entry) {
            Object entries = this.getData();
            Object e = this.getData();
            int i = 0;
            while (i < ((ArrayList)e).size()) {
                if (((Entry)((ArrayList)e).get((int)i)).hash > ((Entry)entry).hash) {
                    ((ArrayList)entries).add(i, entry);
                    this.modified = true;
                    ++this.segmentSize;
                    return null;
                }
                if (((Entry)((ArrayList)e).get((int)i)).hash == ((Entry)entry).hash) {
                    Object key = ((Entry)((ArrayList)e).get((int)i)).key;
                    if (key == null || key.equals(((Entry)entry).key)) {
                        this.modified = true;
                        return (Entry)((ArrayList)entries).set(i, entry);
                    }
                    ((ArrayList)entries).add(i, entry);
                    this.modified = true;
                    ++this.segmentSize;
                    return null;
                }
                ++i;
            }
            ((ArrayList)entries).add(entry);
            this.modified = true;
            ++this.segmentSize;
            return null;
        }

        private Optional<V> replace(int hash, K key, V value) {
            Entry current = this.getByHash(hash, key);
            if (current != null) {
                this.modified = true;
                Object old = current.value;
                current.value = value;
                return Optional.ofNullable(old);
            }
            return null;
        }

        private boolean replace(int hash, K key, V oldValue, V newValue) {
            Entry current = this.getByHash(hash, key);
            if (current != null && current.value.equals(oldValue)) {
                current.value = newValue;
                this.modified = true;
                return true;
            }
            return false;
        }

        @Override
        public boolean allowClear() {
            return !this.modified;
        }

        private int findNextPosition(int hash) {
            Object e = this.getData();
            int i = 0;
            while (i < ((ArrayList)e).size()) {
                if (((Entry)((ArrayList)e).get((int)i)).hash >= hash) {
                    return i;
                }
                ++i;
            }
            return ((ArrayList)e).size();
        }

        private Segment<Entry<K, V>> split(int index) {
            Object e = this.getData();
            List part = ((ArrayList)e).subList(index, ((ArrayList)e).size());
            Segment newSegment = new Segment(0);
            ((ArrayList)newSegment.getData()).addAll(part);
            newSegment.segmentSize = ((ArrayList)newSegment.getData()).size();
            ((ArrayList)e).removeAll(part);
            this.segmentSize = ((ArrayList)e).size();
            return newSegment;
        }

        public String toString() {
            if (!this.isLoaded()) {
                return "[ " + this.segmentSize + " unloaded Elements]";
            }
            Iterator i = ((ArrayList)this.getData()).iterator();
            if (!i.hasNext()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Entry entry = (Entry)i.next();
                sb.append(entry.toString());
                if (!i.hasNext()) {
                    return sb.append(']').toString();
                }
                sb.append(',').append(' ');
            }
        }

        @Override
        public void allowUnload(boolean allow) {
            this.allowUnloading = allow;
        }

        @Override
        public boolean unloadAllowed() {
            return this.allowUnloading;
        }
    }

    static class SegmentsSpliterator<K, V> {
        protected final LazyHashMap<K, V> map;
        protected int index;
        protected int fence;
        protected int expectedModCount;
        protected int segmentIndex;
        protected int localIndex;
        protected Segment<Entry<K, V>> currentSegment;

        public SegmentsSpliterator(LazyHashMap<K, V> map, int index, int fence, int expectedModCount) {
            this.map = map;
            this.index = index;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
            this.segmentIndex = map.calculateIndexPosition((int)index).segmentIndex;
            this.currentSegment = map.segments.get(this.segmentIndex);
        }

        protected int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = this.map.modCount;
                hi = this.fence = this.map.size;
            }
            return hi;
        }

        public long estimateSize() {
            return this.getFence() - this.index;
        }

        public int characteristics() {
            return 16464;
        }
    }

    final class ValueIterator
    extends LazyMapIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public final V next() {
            return super.nextEntry().getValue();
        }
    }

    static class ValueSpliterator<K, V>
    extends SegmentsSpliterator<K, V>
    implements Spliterator<V> {
        public ValueSpliterator(LazyHashMap<K, V> map, int index, int fence, int expectedModCount) {
            super(map, index, fence, expectedModCount);
        }

        @Override
        public boolean tryAdvance(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int hi = this.getFence();
            if (this.index < hi) {
                this.currentSegment.allowUnload(false);
                Object value = ((Entry)((ArrayList)this.currentSegment.getData()).get((int)this.localIndex)).value;
                action.accept(value);
                if (this.map.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                ++this.index;
                if (this.index >= hi) {
                    return true;
                }
                if (this.localIndex < this.currentSegment.segmentSize - 1) {
                    ++this.localIndex;
                } else {
                    this.localIndex = 0;
                    ++this.segmentIndex;
                    this.currentSegment.allowUnload(true);
                    this.currentSegment = this.map.segments.get(this.segmentIndex);
                }
                return true;
            }
            this.currentSegment.allowUnload(true);
            return false;
        }

        @Override
        public Spliterator<V> trySplit() {
            int lo = this.index;
            int hi = this.getFence();
            int mid = lo + hi >>> 1;
            IndexPosition sIndex = this.map.calculateIndexPosition(mid);
            if (lo < mid) {
                if (hi <= sIndex.segmentStartIndex + sIndex.segmentSize && lo >= sIndex.segmentStartIndex) {
                    return null;
                }
                int dist_lo = mid - sIndex.segmentStartIndex;
                int dist_hi = sIndex.segmentStartIndex + sIndex.segmentSize - mid;
                int splitIndex = dist_lo < dist_hi ? sIndex.segmentStartIndex : sIndex.segmentStartIndex + sIndex.segmentSize;
                this.index = splitIndex;
                this.segmentIndex = this.map.calculateIndexPosition((int)this.index).segmentIndex;
                this.currentSegment = this.map.segments.get(this.segmentIndex);
                return new ValueSpliterator<K, V>(this.map, lo, splitIndex, this.expectedModCount);
            }
            return null;
        }
    }

    final class Values
    extends AbstractSet<V>
    implements LazyCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return LazyHashMap.this.size;
        }

        @Override
        public void clear() {
            LazyHashMap.this.clear();
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(LazyHashMap.this, 0, -1, 0);
        }

        @Override
        public <P extends Consumer<Lazy<?>>> P iterateLazyReferences(P procedure) {
            try {
                for (Segment segment : LazyHashMap.this.segments) {
                    procedure.accept(segment.data);
                }
            }
            catch (ThrowBreak throwBreak) {
                // empty catch block
            }
            return procedure;
        }

        @Override
        public boolean consolidate() {
            return false;
        }

        @Override
        public void tryUnload(boolean unloadAll) {
            LazyHashMap.this.unloader.unload(unloadAll);
        }
    }
}

