/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections.lazy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import one.microstream.collections.lazy.LazySegment;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface LazySegmentUnloader {
    public void unload(LazySegment<?> var1);

    public void unload(boolean var1);

    public void remove(LazySegment<?> var1);

    public LazySegmentUnloader copy();

    public static final class Default
    implements LazySegmentUnloader {
        private static final Logger logger = Logging.getLogger(Default.class);
        private final int desiredLoadCount;
        private transient LinkedList<LazySegment<?>> loadedSegments;

        public Default() {
            this.desiredLoadCount = 2;
            this.loadedSegments = new LinkedList();
        }

        public Default(int desiredLoadCount) {
            if (desiredLoadCount < 1) {
                throw new IllegalArgumentException("the desired load count must be create then zero: " + desiredLoadCount);
            }
            this.desiredLoadCount = desiredLoadCount;
            this.loadedSegments = new LinkedList();
        }

        @Override
        public synchronized void unload(LazySegment<?> lazySegment) {
            if (this.loadedSegments == null) {
                this.loadedSegments = new LinkedList();
            }
            if (this.setLastUsed(lazySegment)) {
                Iterator iterator = this.loadedSegments.iterator();
                while (iterator.hasNext() && this.loadedSegments.size() > this.desiredLoadCount) {
                    LazySegment segment = (LazySegment)iterator.next();
                    if (segment == lazySegment || segment.isModified() || !segment.isLoaded() || !segment.unloadAllowed()) continue;
                    logger.debug("unloading segment {}", (Object)segment.hashCode());
                    segment.unloadSegment();
                    iterator.remove();
                }
            }
        }

        @Override
        public synchronized void unload(boolean unloadAll) {
            if (this.loadedSegments == null) {
                this.loadedSegments = new LinkedList();
            }
            int segmentsToKeep = unloadAll ? 0 : this.desiredLoadCount;
            Iterator iterator = this.loadedSegments.iterator();
            while (iterator.hasNext() && this.loadedSegments.size() > segmentsToKeep) {
                LazySegment segment = (LazySegment)iterator.next();
                if (segment.isModified() || !segment.isLoaded()) continue;
                logger.debug("unloading segment {}", (Object)segment);
                segment.unloadSegment();
                iterator.remove();
            }
        }

        private boolean setLastUsed(LazySegment<?> lazySegment) {
            if (lazySegment != this.loadedSegments.peekLast()) {
                this.loadedSegments.remove(lazySegment);
                this.loadedSegments.add(lazySegment);
                return true;
            }
            return false;
        }

        @Override
        public LazySegmentUnloader copy() {
            return new Default(this.desiredLoadCount);
        }

        @Override
        public void remove(LazySegment<?> segment) {
            this.loadedSegments.remove(segment);
        }
    }

    public static final class Never
    implements LazySegmentUnloader {
        @Override
        public void unload(LazySegment<?> lazySegment) {
        }

        @Override
        public void unload(boolean unloadAll) {
        }

        @Override
        public LazySegmentUnloader copy() {
            return new Never();
        }

        @Override
        public void remove(LazySegment<?> segment) {
        }
    }

    public static final class Timed
    implements LazySegmentUnloader {
        private static final Logger logger = Logging.getLogger(Timed.class);
        private transient HashMap<LazySegment<?>, Long> loadedSegments;
        long lifetime;

        public Timed(long lifetime) {
            this.lifetime = lifetime;
            this.loadedSegments = new HashMap();
        }

        @Override
        public synchronized void unload(LazySegment<?> currentLazySegment) {
            if (this.loadedSegments == null) {
                this.loadedSegments = new HashMap();
            }
            long currentTime = System.currentTimeMillis();
            this.loadedSegments.put(currentLazySegment, currentTime);
            for (Map.Entry<LazySegment<?>, Long> item : this.loadedSegments.entrySet()) {
                LazySegment<?> segment = item.getKey();
                if (item.getValue() + this.lifetime >= currentTime || segment == currentLazySegment || segment.isModified() || !segment.isLoaded() || !segment.unloadAllowed()) continue;
                logger.debug("unloading segment {}", (Object)segment.hashCode());
                segment.unloadSegment();
            }
        }

        @Override
        public synchronized void unload(boolean unloadAll) {
            if (this.loadedSegments == null) {
                this.loadedSegments = new HashMap();
            }
            long currentTime = System.currentTimeMillis();
            for (Map.Entry<LazySegment<?>, Long> item : this.loadedSegments.entrySet()) {
                LazySegment<?> segment = item.getKey();
                if (item.getValue() + this.lifetime >= currentTime || segment.isModified() || !segment.isLoaded()) continue;
                logger.debug("unloading segment {}", (Object)segment.hashCode());
                segment.unloadSegment();
            }
        }

        @Override
        public LazySegmentUnloader copy() {
            return new Timed(this.lifetime);
        }

        @Override
        public void remove(LazySegment<?> segment) {
            this.loadedSegments.remove(segment);
        }
    }
}

