/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.entity;

import one.microstream.X;
import one.microstream.entity.Entity;
import one.microstream.entity.EntityLayer;
import one.microstream.entity.EntityLogger;

public final class EntityLayerLogging
extends EntityLayer {
    private final EntityLogger logger;

    protected EntityLayerLogging(Entity inner, EntityLogger logger) {
        super(inner);
        this.logger = X.notNull(logger);
    }

    @Override
    protected void entityCreated() {
        this.logger.entityCreated(this.entityIdentity(), this.entityData());
        super.entityCreated();
    }

    @Override
    protected Entity entityData() {
        Entity data = super.entityData();
        this.logger.afterRead(this.entityIdentity(), data);
        return data;
    }

    @Override
    protected boolean updateEntityData(Entity newData) {
        Entity identity = this.entityIdentity();
        this.logger.beforeUpdate(identity, newData);
        boolean success = super.updateEntityData(newData);
        this.logger.afterUpdate(identity, newData, success);
        return success;
    }
}

