/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.functional;

import one.microstream.collections.BulkList;
import one.microstream.functional.Aggregator;

public final class AggregateArrayBuilder<E>
implements Aggregator<E, E[]> {
    final Class<E> elementType;
    final BulkList<E> collector;

    public static final AggregateArrayBuilder<Object> New() {
        return AggregateArrayBuilder.New(Object.class);
    }

    public static final <E> AggregateArrayBuilder<E> New(Class<E> elementType) {
        return AggregateArrayBuilder.New(elementType, 1);
    }

    public static final <E> AggregateArrayBuilder<E> New(Class<E> elementType, int initialCapacity) {
        return new AggregateArrayBuilder<E>(elementType, new BulkList(initialCapacity));
    }

    AggregateArrayBuilder(Class<E> elementType, BulkList<E> collector) {
        this.elementType = elementType;
        this.collector = collector;
    }

    @Override
    public final void accept(E element) {
        this.collector.add(element);
    }

    @Override
    public final E[] yield() {
        return this.collector.toArray(this.elementType);
    }
}

