/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import one.microstream.X;

public final class ByteBufferOutputStream
extends OutputStream {
    private final ByteBuffer targetBuffer;

    public static ByteBufferOutputStream New(ByteBuffer targetBuffer) {
        return new ByteBufferOutputStream(X.notNull(targetBuffer));
    }

    private ByteBufferOutputStream(ByteBuffer targetBuffer) {
        this.targetBuffer = targetBuffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.targetBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        X.notNull(bytes);
        if (offset < 0 || offset > bytes.length || length < 0 || offset + length > bytes.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        this.targetBuffer.put(bytes, offset, length);
    }
}

