/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.math;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.NoSuchElementException;
import one.microstream.math.MatrixException;

public class Matrix<T> {
    final T[][] data;
    private final Class<T> type;
    private final int rowCount;
    private final int columnCount;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T[][] validateArray(T[][] array) throws MatrixException, NullPointerException {
        if (array == null) {
            throw new NullPointerException("array is null");
        }
        if (array.length == 0) {
            throw new MatrixException("Array may not have length 0");
        }
        int i = 0;
        try {
            int nestedArraysLength = array[i].length;
            if (nestedArraysLength == 0) {
                throw new MatrixException("Nested arrays may not have length 0");
            }
            while (true) {
                if (i >= array.length) {
                    return array;
                }
                T[] objects = array[i];
                if (objects.length != nestedArraysLength) {
                    throw new MatrixException("array has different sized nested array at index" + i + ": " + objects.length + " != " + nestedArraysLength);
                }
                ++i;
            }
        }
        catch (NullPointerException e) {
            throw new MatrixException("matrix array has no nested array at index " + i);
        }
    }

    private static final void validateRowIndex(int index, Object[][] data, String type) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(type) + " may not be negative: " + index);
        }
        if (index >= data.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(type) + " out of bounds: " + index + " >= " + data.length);
        }
    }

    private static final void validateColumnIndex(int index, Object[] data, String type) throws ArrayIndexOutOfBoundsException {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(type) + " may not be negative: " + index);
        }
        if (index >= data.length) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(type) + " out of bounds: " + index + " >= " + data.length);
        }
    }

    public Matrix(T[][] data) {
        this.data = Matrix.validateArray(data);
        this.type = data.getClass().getComponentType().getComponentType();
        this.rowCount = data.length;
        this.columnCount = data[0].length;
    }

    public Matrix(Class<T> type, int rows, int columns) {
        this.type = type;
        this.data = (Object[][])Array.newInstance(type, rows, columns);
        this.rowCount = rows;
        this.columnCount = columns;
    }

    public Class<T> getType() {
        return this.type;
    }

    protected T[][] getData() {
        return this.data;
    }

    protected T[] getArray(int arrayIndex) {
        return this.data[arrayIndex];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(1024);
        T[][] data = this.data;
        int x = 0;
        while (x < data.length) {
            T[] row;
            T[] TArray = row = data[x];
            int n = row.length;
            int n2 = 0;
            while (n2 < n) {
                T t = TArray[n2];
                sb.append(t).append('\t');
                ++n2;
            }
            sb.append('\n');
            ++x;
        }
        return sb.toString();
    }

    public T getElementAt(int rowIndex, int colIndex) {
        return this.data[rowIndex][colIndex];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T setElementAt(int rowIndex, int colIndex, T newElement) {
        T[][] TArray = this.data;
        synchronized (this.data) {
            T oldElement = this.data[rowIndex][colIndex];
            this.data[rowIndex][colIndex] = newElement;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return oldElement;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapElements(int rowIndex1, int colIndex1, int rowIndex2, int colIndex2) {
        T[][] TArray = this.data;
        synchronized (this.data) {
            T element1 = this.data[rowIndex1][colIndex1];
            this.data[rowIndex1][colIndex1] = this.data[rowIndex2][colIndex2];
            this.data[rowIndex2][colIndex2] = element1;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    public Iterable<T> iterate() {
        return new MatrixIterable();
    }

    protected Iterable<T> iterate(int firstRow, int firstColumn, int lastRow, int lastColumn, Double range) throws IllegalArgumentException {
        Matrix.validateRowIndex(firstRow, this.data, "firstRow");
        Matrix.validateRowIndex(lastRow, this.data, "lastRow");
        Matrix.validateColumnIndex(firstColumn, this.data[firstRow], "firstColumn");
        Matrix.validateColumnIndex(lastColumn, this.data[firstRow], "lastColumn");
        return new MatrixIterable(firstRow, lastRow, firstColumn, lastColumn, range);
    }

    public Iterable<T> iterate(int firstRow, int firstColumn, int lastRow, int lastColumn) throws IllegalArgumentException {
        return this.iterate(firstRow, firstColumn, lastRow, lastColumn, null);
    }

    public Iterable<T> iterate(int centerRowIndex, int centerColumnIndex, int squareRadius) throws IllegalArgumentException {
        return this.iterate(Math.max(centerRowIndex - squareRadius, 0), Math.max(centerColumnIndex - squareRadius, 0), Math.min(centerRowIndex + squareRadius, this.rowCount), Math.min(centerColumnIndex + squareRadius, this.columnCount), null);
    }

    public Iterable<T> iterate(int centerRowIndex, int centerColumnIndex, double range) throws IllegalArgumentException {
        int squareRadius = (int)range;
        return this.iterate(Math.max(centerRowIndex - squareRadius, 0), Math.max(centerColumnIndex - squareRadius, 0), Math.min(centerRowIndex + squareRadius, this.rowCount), Math.min(centerColumnIndex + squareRadius, this.columnCount), range);
    }

    private static interface HasNextChecker {
        public boolean hasNext();
    }

    public static enum IterationMode {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    private final class MatrixIterable
    implements Iterable<T> {
        final int firstRow;
        final int lastRow;
        final int firstColumn;
        final int lastColumn;
        private final Double range;

        MatrixIterable() {
            this(0, matrix.data.length - 1, 0, matrix.data[0].length - 1, null);
        }

        MatrixIterable(int firstRow, int lastRow, int firstColumn, int lastColumn, Double range) {
            this.firstRow = firstRow;
            this.lastRow = lastRow;
            this.firstColumn = firstColumn;
            this.lastColumn = lastColumn;
            this.range = range;
        }

        @Override
        public Iterator<T> iterator() {
            return new MatrixIterator(this.range);
        }

        private class MatrixIterator
        implements Iterator<T> {
            private T[] currentArray;
            private int currentRowIndex;
            int currentColIndex;
            private final HasNextChecker hasNextChecker;
            private final double rangeSquare;
            private final int centerRowIndex;
            private final int centerColIndex;

            final boolean isInRange() {
                int rowDif = this.currentRowIndex - this.centerRowIndex;
                int colDif = this.currentColIndex - this.centerColIndex;
                return (double)(rowDif * rowDif + colDif * colDif) <= this.rangeSquare;
            }

            MatrixIterator(Double range) {
                this.currentRowIndex = MatrixIterable.this.firstRow - 1;
                this.currentColIndex = MatrixIterable.this.firstColumn;
                this.centerRowIndex = (MatrixIterable.this.lastRow + MatrixIterable.this.firstRow) / 2;
                this.centerColIndex = (MatrixIterable.this.lastColumn + MatrixIterable.this.firstColumn) / 2;
                this.nextRow();
                this.hasNextChecker = range != null ? () -> {
                    if (this.currentColIndex <= (MatrixIterable.this.lastColumn + 1) / 2) {
                        while (!this.isInRange()) {
                            if (++this.currentColIndex <= MatrixIterable.this.lastColumn) continue;
                            return false;
                        }
                        return true;
                    }
                    return this.isInRange();
                } : () -> this.currentColIndex <= MatrixIterable.this.lastColumn;
                this.rangeSquare = range != null ? range * range : 0.0;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public boolean hasNext() {
                if (!this.hasNextChecker.hasNext()) ** GOTO lbl5
                return true;
lbl-1000:
                // 1 sources

                {
                    if (!this.hasNextChecker.hasNext()) continue;
                    return true;
lbl5:
                    // 2 sources

                    ** while (this.nextRow())
                }
lbl6:
                // 1 sources

                return false;
            }

            @Override
            public T next() {
                try {
                    return this.currentArray[this.currentColIndex++];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                this.currentArray[this.currentColIndex] = null;
            }

            private boolean nextRow() {
                this.currentColIndex = MatrixIterable.this.firstColumn;
                T[][] iterables = ((MatrixIterable)MatrixIterable.this).Matrix.this.data;
                int loopIndex = this.currentRowIndex;
                T[] loopIterable = null;
                while (loopIterable == null) {
                    if (++loopIndex > MatrixIterable.this.lastRow) {
                        return false;
                    }
                    loopIterable = iterables[loopIndex];
                }
                this.currentArray = loopIterable;
                this.currentRowIndex = loopIndex;
                return true;
            }
        }
    }
}

