/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.math;

public final class StaticLowRandom {
    private static final long MULTIPLIER = 25214903917L;
    private static final long ADDEND = 11L;
    private static final long MASC_BIT_SIZE = 48L;
    private static final long MASK = 0xFFFFFFFFFFFFL;
    private static long seed = (System.nanoTime() ^ 0x5DEECE66DL) & 0xFFFFFFFFFFFFL;

    private static int next(int bits) {
        long nextseed;
        long oldseed;
        while (!StaticLowRandom.compareAndSet(oldseed = seed, nextseed = oldseed * 25214903917L + 11L & 0xFFFFFFFFFFFFL)) {
        }
        return (int)(nextseed >>> (int)(48L - (long)bits));
    }

    private static boolean compareAndSet(long oldseed, long nextseed) {
        if (seed == oldseed) {
            seed = nextseed;
            return true;
        }
        return false;
    }

    public static final int nextInt(int n) {
        int val;
        int bits;
        if (n <= 0) {
            throw new IllegalArgumentException("n must be positive");
        }
        while ((bits = StaticLowRandom.next(31)) - (val = bits % n) + n - 1 < 0) {
        }
        return val;
    }

    private StaticLowRandom() {
        throw new UnsupportedOperationException();
    }
}

