/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.memory;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.function.Predicate;
import one.microstream.exceptions.InstantiationRuntimeException;
import one.microstream.functional.XFunc;
import one.microstream.memory.MemoryAccessorReversing;
import one.microstream.memory.MemoryStatistics;
import one.microstream.reflect.XReflect;

public interface MemoryAccessor {
    public void guaranteeUsability();

    public long getDirectByteBufferAddress(ByteBuffer var1);

    public boolean deallocateDirectByteBuffer(ByteBuffer var1);

    public boolean isDirectByteBuffer(ByteBuffer var1);

    public ByteBuffer guaranteeDirectByteBuffer(ByteBuffer var1);

    public long allocateMemory(long var1);

    public long reallocateMemory(long var1, long var3);

    public void freeMemory(long var1);

    public void fillMemory(long var1, long var3, byte var5);

    public byte get_byte(long var1);

    public boolean get_boolean(long var1);

    public short get_short(long var1);

    public char get_char(long var1);

    public int get_int(long var1);

    public float get_float(long var1);

    public long get_long(long var1);

    public double get_double(long var1);

    public byte get_byte(Object var1, long var2);

    public boolean get_boolean(Object var1, long var2);

    public short get_short(Object var1, long var2);

    public char get_char(Object var1, long var2);

    public int get_int(Object var1, long var2);

    public float get_float(Object var1, long var2);

    public long get_long(Object var1, long var2);

    public double get_double(Object var1, long var2);

    public Object getObject(Object var1, long var2);

    public void set_byte(long var1, byte var3);

    public void set_boolean(long var1, boolean var3);

    public void set_short(long var1, short var3);

    public void set_char(long var1, char var3);

    public void set_int(long var1, int var3);

    public void set_float(long var1, float var3);

    public void set_long(long var1, long var3);

    public void set_double(long var1, double var3);

    public void set_byte(Object var1, long var2, byte var4);

    public void set_boolean(Object var1, long var2, boolean var4);

    public void set_short(Object var1, long var2, short var4);

    public void set_char(Object var1, long var2, char var4);

    public void set_int(Object var1, long var2, int var4);

    public void set_float(Object var1, long var2, float var4);

    public void set_long(Object var1, long var2, long var4);

    public void set_double(Object var1, long var2, double var4);

    public void setObject(Object var1, long var2, Object var4);

    public void set_byteInBytes(byte[] var1, int var2, byte var3);

    public void set_booleanInBytes(byte[] var1, int var2, boolean var3);

    public void set_shortInBytes(byte[] var1, int var2, short var3);

    public void set_charInBytes(byte[] var1, int var2, char var3);

    public void set_intInBytes(byte[] var1, int var2, int var3);

    public void set_floatInBytes(byte[] var1, int var2, float var3);

    public void set_longInBytes(byte[] var1, int var2, long var3);

    public void set_doubleInBytes(byte[] var1, int var2, double var3);

    public void copyRange(long var1, long var3, long var5);

    public void copyRangeToArray(long var1, byte[] var3);

    public void copyRangeToArray(long var1, boolean[] var3);

    public void copyRangeToArray(long var1, short[] var3);

    public void copyRangeToArray(long var1, char[] var3);

    public void copyRangeToArray(long var1, int[] var3);

    public void copyRangeToArray(long var1, float[] var3);

    public void copyRangeToArray(long var1, long[] var3);

    public void copyRangeToArray(long var1, double[] var3);

    public void copyArrayToAddress(byte[] var1, long var2);

    public void copyArrayToAddress(boolean[] var1, long var2);

    public void copyArrayToAddress(short[] var1, long var2);

    public void copyArrayToAddress(char[] var1, long var2);

    public void copyArrayToAddress(int[] var1, long var2);

    public void copyArrayToAddress(float[] var1, long var2);

    public void copyArrayToAddress(long[] var1, long var2);

    public void copyArrayToAddress(double[] var1, long var2);

    default public byte[] asByteArray(long[] values) {
        byte[] array = new byte[values.length * 8];
        int i = 0;
        while (i < values.length) {
            this.set_longInBytes(array, i * 8, values[i]);
            ++i;
        }
        return array;
    }

    default public byte[] asByteArray(long value) {
        byte[] array = new byte[8];
        this.set_longInBytes(array, 0, value);
        return array;
    }

    public long objectFieldOffset(Field var1);

    public long[] objectFieldOffsets(Field ... var1);

    public long objectFieldOffset(Class<?> var1, Field var2);

    public long[] objectFieldOffsets(Class<?> var1, Field ... var2);

    default public long[] objectFieldOffsets(Class<?> objectClass) {
        return this.objectFieldOffsets(objectClass, XFunc.all());
    }

    default public long[] objectFieldOffsets(Class<?> objectClass, Predicate<? super Field> selector) {
        Field[] array = XReflect.collectInstanceFields(objectClass, selector);
        return this.objectFieldOffsets(objectClass, array);
    }

    public void ensureClassInitialized(Class<?> var1);

    default public void ensureClassInitialized(Class<?> c, Iterable<Field> usedFields) {
        this.ensureClassInitialized(c);
    }

    public <T> T instantiateBlank(Class<T> var1) throws InstantiationRuntimeException;

    public MemoryStatistics createHeapMemoryStatistics();

    public MemoryStatistics createNonHeapMemoryStatistics();

    default public boolean isReversing() {
        return false;
    }

    default public MemoryAccessor toReversing() {
        return new MemoryAccessorReversing(this);
    }
}

