/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.reference;

import one.microstream.reference.Lazy;
import one.microstream.reference.LazyClearController;
import one.microstream.reference.ObjectSwizzling;
import one.microstream.reference.Swizzling;
import one.microstream.util.logging.Logging;
import org.slf4j.Logger;

public interface ControlledLazyReference<T>
extends Lazy<T> {
    public void setLazyClearController(LazyClearController var1);

    public static final class Default<T>
    extends Lazy.Default<T>
    implements ControlledLazyReference<T> {
        private static final Logger logger = Logging.getLogger(Default.class);
        private LazyClearController lazyClearController;

        public Default(T subject, LazyClearController lazyClearController) {
            this(subject, Swizzling.toUnmappedObjectId(subject), null);
            this.lazyClearController = lazyClearController;
        }

        Default(T subject, long objectId, ObjectSwizzling loader) {
            super(subject, objectId, loader);
        }

        @Override
        public void setLazyClearController(LazyClearController lazyClearController) {
            this.lazyClearController = lazyClearController;
        }

        @Override
        public final synchronized T clear() {
            if (this.lazyClearController.allowClear()) {
                return super.clear();
            }
            logger.trace("Denied unloading Lazy reference {}", (Object)this);
            return this.peek();
        }

        @Override
        public final synchronized boolean clear(Lazy.ClearingEvaluator clearingEvaluator) {
            if (this.lazyClearController.allowClear()) {
                return super.clear(clearingEvaluator);
            }
            logger.trace("Denied unloading Lazy reference {}", (Object)this);
            return false;
        }
    }
}

