/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util;

import one.microstream.math.XMath;
import one.microstream.typing.Immutable;
import one.microstream.typing.Stateless;
import one.microstream.util.BufferSizeProvider;

public interface BufferSizeProviderIncremental
extends BufferSizeProvider {
    default public long provideIncrementalBufferSize() {
        return this.provideBufferSize();
    }

    public static BufferSizeProviderIncremental New() {
        return new Default();
    }

    public static BufferSizeProviderIncremental New(long bufferSize) {
        return BufferSizeProviderIncremental.New(bufferSize, bufferSize);
    }

    public static BufferSizeProviderIncremental New(long initialBufferSize, long incrementalBufferSize) {
        return new Sized(XMath.positive(initialBufferSize), XMath.positive(incrementalBufferSize));
    }

    public static final class Default
    implements BufferSizeProviderIncremental,
    Stateless {
    }

    public static final class Sized
    implements BufferSizeProviderIncremental,
    Immutable {
        private final long initialBufferSize;
        private final long incrementalBufferSize;

        Sized(long initialBufferSize, long incrementalBufferSize) {
            this.initialBufferSize = initialBufferSize;
            this.incrementalBufferSize = incrementalBufferSize;
        }

        @Override
        public final long provideBufferSize() {
            return this.initialBufferSize;
        }

        @Override
        public final long provideIncrementalBufferSize() {
            return this.incrementalBufferSize;
        }
    }
}

