/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.config;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.function.Consumer;
import one.microstream.X;
import one.microstream.chars.VarString;
import one.microstream.chars.XChars;
import one.microstream.chars.XCsvParserCharArray;
import one.microstream.chars._charArrayRange;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.EqHashTable;
import one.microstream.collections.types.XGettingEnum;
import one.microstream.collections.types.XGettingMap;
import one.microstream.exceptions.IORuntimeException;
import one.microstream.functional.Aggregator;
import one.microstream.io.XIO;
import one.microstream.typing.KeyValue;
import one.microstream.util.Substituter;
import one.microstream.util.config.AbstractConfig;
import one.microstream.util.config.ConfigEntry;
import one.microstream.util.config.ConfigEntryAggregator;
import one.microstream.util.config.ConfigEntryBoolean;
import one.microstream.util.config.ConfigEntryDouble;
import one.microstream.util.config.ConfigEntryInteger;
import one.microstream.util.config.ConfigEntryLong;
import one.microstream.util.config.ConfigEntryString;
import one.microstream.util.config.ConfigFile;
import one.microstream.util.config.RootConfig;
import one.microstream.util.config.SubConfig;
import one.microstream.util.xcsv.XCsvAssembler;
import one.microstream.util.xcsv.XCsvConfiguration;
import one.microstream.util.xcsv.XCsvParser;

public class CompositeConfig {
    private final String rootIdentifier;
    private final String qualifier;
    private final String filesuffix;
    private final XCsvConfiguration csvConfig;
    private final File configDirectory;
    private final Substituter<String> stringCache;
    private final EqHashTable<String, SubConfig> subConfigs = EqHashTable.New();
    private final XGettingMap<String, String> customVariables;
    private final Character variableStarter;
    private final Character variableTerminator;
    private RootConfig defaultConfig;

    public static final ConfigEntry<String> entryString(String keyName) {
        return new ConfigEntryString(keyName);
    }

    public static final ConfigEntry<Boolean> entryBoolean(String keyName) {
        return new ConfigEntryBoolean(keyName);
    }

    public static final ConfigEntry<Integer> entryInteger(String keyName) {
        return new ConfigEntryInteger(keyName);
    }

    public static final ConfigEntry<Long> entryLong(String keyName) {
        return new ConfigEntryLong(keyName);
    }

    public static final ConfigEntry<Double> entryDouble(String keyName) {
        return new ConfigEntryDouble(keyName);
    }

    ConfigEntryAggregator importConfigs(String tag, XCsvParser<_charArrayRange> parser, ConfigEntryAggregator aggregator, boolean mandatory) {
        final String fileStart = String.valueOf(this.qualifier) + '_' + tag + '_';
        final String dotSuffix = String.valueOf(XIO.fileSuffixSeparator()) + this.filesuffix;
        File[] configFiles = this.configDirectory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(fileStart) && name.endsWith(dotSuffix);
            }
        });
        if (mandatory && (configFiles == null || configFiles.length == 0)) {
            throw new RuntimeException("No suitable files for " + tag + " found in directory " + this.configDirectory);
        }
        File[] fileArray = configFiles;
        int n = configFiles.length;
        int n2 = 0;
        while (n2 < n) {
            char[] input;
            File file = fileArray[n2];
            try {
                input = XIO.readString(file.toPath(), XChars.defaultJvmCharset()).toCharArray();
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read file: " + file);
            }
            String name = file.getName().substring(fileStart.length(), file.getName().length() - dotSuffix.length());
            parser.parseCsvData(this.csvConfig, _charArrayRange.New(input), aggregator.setNewConfig(name));
            ++n2;
        }
        return aggregator;
    }

    public CompositeConfig(String rootIdentifier, String qualifier, String filesuffix, XCsvConfiguration csvConfig, File configDirectory, Substituter<String> stringCache, XGettingMap<String, String> customVariables, Character variableStarter, Character variableTerminator) {
        this.rootIdentifier = X.notNull(rootIdentifier);
        this.qualifier = X.notNull(qualifier);
        this.filesuffix = X.notNull(filesuffix);
        this.csvConfig = X.notNull(csvConfig);
        this.configDirectory = X.notNull(configDirectory);
        this.stringCache = X.notNull(stringCache);
        this.customVariables = customVariables;
        this.variableStarter = variableStarter;
        this.variableTerminator = variableTerminator;
    }

    public CompositeConfig(String rootIdentifier, String qualifier, String filesuffix, XCsvConfiguration csvConfig, File configDirectory, Substituter<String> stringCache, XGettingMap<String, String> customVariables) {
        this(rootIdentifier, qualifier, filesuffix, csvConfig, configDirectory, stringCache, customVariables, null, null);
    }

    public File directory() {
        return this.configDirectory;
    }

    private RootConfig createRootConfig() {
        XCsvParserCharArray parser = XCsvParserCharArray.New();
        ConfigEntryAggregator aggregator = ConfigEntryAggregator.New(this.stringCache);
        RootConfig defaultConfig = new RootConfig(this.rootIdentifier, this.customVariables, this.variableStarter, this.variableTerminator).updateDefaults(this.importConfigs(this.rootIdentifier, parser, aggregator, true).yield());
        return defaultConfig;
    }

    private SubConfig createSubConfig(String identifier) {
        XCsvParserCharArray parser = XCsvParserCharArray.New();
        ConfigEntryAggregator aggregator = ConfigEntryAggregator.New(this.stringCache);
        SubConfig config = new SubConfig(this.defaultConfig(), identifier, this.customVariables, this.variableStarter, this.variableTerminator).updateOverrides(this.importConfigs(identifier.toString(), parser, aggregator, false).yield());
        return config;
    }

    public synchronized void iterateConfigs(Consumer<? super AbstractConfig> iterator) {
        iterator.accept(this.defaultConfig);
        this.subConfigs.values().iterate(iterator);
    }

    public synchronized RootConfig defaultConfig() {
        if (this.defaultConfig == null) {
            this.defaultConfig = this.createRootConfig();
        }
        return this.defaultConfig;
    }

    public synchronized SubConfig subConfig(String identifier) {
        SubConfig config = this.subConfigs.get(identifier);
        if (config == null) {
            config = this.createSubConfig(identifier);
            this.defaultConfig.register(config);
            this.subConfigs.add(identifier, config);
        }
        return config;
    }

    public synchronized void export() {
        Exporter exporter = new Exporter();
        exporter.accept(this.defaultConfig);
        Object writtenFiles = this.subConfigs.values().iterate(exporter).yield();
        String fileStart = String.valueOf(this.qualifier) + '_';
        String dotSuffix = String.valueOf(XIO.fileSuffixSeparator()) + this.filesuffix;
        File[] filesToDelete = this.configDirectory.listFiles(arg_0 -> CompositeConfig.lambda$0(fileStart, dotSuffix, (XGettingEnum)writtenFiles, arg_0));
        if (filesToDelete == null) {
            return;
        }
        File[] fileArray = filesToDelete;
        int n = filesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (!file.delete()) {
                throw new RuntimeException("could not delete file: " + file);
            }
            ++n2;
        }
    }

    final File buildFile(String identifier, ConfigFile config) {
        return new File(this.configDirectory, XIO.addFileSuffix(String.valueOf(this.qualifier) + '_' + identifier + '_' + config.name, this.filesuffix));
    }

    final File exportConfigFile(String identifier, ConfigFile config) {
        File file = this.buildFile(identifier, config);
        VarString vs = VarString.New();
        final XCsvAssembler.Default assembler = XCsvAssembler.Default.New(this.csvConfig, vs, "\t", " ", "\r", "");
        config.table.iterate(new Consumer<KeyValue<String, String>>(){

            @Override
            public void accept(KeyValue<String, String> element) {
                assembler.addRowValueSimple(element.key());
                assembler.addRowValueDelimited(element.value());
                assembler.completeRow();
            }
        });
        assembler.completeRows();
        try {
            XIO.write(file.toPath(), vs.toString());
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
        return file;
    }

    final synchronized void export(AbstractConfig e, final Consumer<File> exportFileCollector) {
        final String identifier = e.identifier();
        e.configFiles.values().iterate(new Consumer<ConfigFile>(){

            @Override
            public void accept(ConfigFile e) {
                File exportFile = CompositeConfig.this.exportConfigFile(identifier, e);
                exportFileCollector.accept(exportFile);
            }
        });
    }

    private static /* synthetic */ boolean lambda$0(String string, String string2, XGettingEnum xGettingEnum, File file) {
        String filename = file.getName();
        return filename.startsWith(string) && filename.endsWith(string2) && !xGettingEnum.contains(file);
    }

    final class Exporter
    implements Aggregator<AbstractConfig, XGettingEnum<File>> {
        final EqHashEnum<File> files = EqHashEnum.New();

        Exporter() {
        }

        @Override
        public final void accept(AbstractConfig e) {
            CompositeConfig.this.export(e, this.files);
        }

        @Override
        public final XGettingEnum<File> yield() {
            return this.files;
        }
    }
}

