/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.cql;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.types.XIterable;
import one.microstream.collections.types.XSequence;
import one.microstream.functional.Aggregator;
import one.microstream.util.cql.CQL;
import one.microstream.util.cql.CqlIteration;
import one.microstream.util.cql.CqlQuery;
import one.microstream.util.cql.CqlResultor;

public interface CqlProjection<I, O>
extends CqlIteration<I, O, XSequence<O>> {
    @Override
    default public CqlProjection<I, O> skip(Number count) {
        return CqlProjection.New(this.getSource(), CQL.asLong(count), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public CqlProjection<I, O> limit(Number count) {
        return CqlProjection.New(this.getSource(), this.getSkip(), CQL.asLong(count), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    default public CqlProjection<I, O> select(Predicate<? super I> selector) {
        return CqlProjection.New(this.getSource(), this.getSkip(), this.getLimit(), selector, this.getProjector(), this.getOrder(), this.getResultor());
    }

    default public CqlProjection<I, O> orderBy(Comparator<? super O> order) {
        return CqlProjection.New(this.getSource(), this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), order, this.getResultor());
    }

    default public CqlProjection<I, O> from(XIterable<? extends I> source) {
        return CqlProjection.New(source, this.getSkip(), this.getLimit(), this.getSelector(), this.getProjector(), this.getOrder(), this.getResultor());
    }

    @Override
    default public <P extends Consumer<? super O>> P iterate(P procedure) {
        ((XSequence)this.execute()).iterate(procedure);
        return procedure;
    }

    public static <I, O> CqlProjection<I, O> New() {
        return new Default(null, null, null, null, null, null, null);
    }

    public static <I, O> CqlProjection<I, O> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator) {
        return new Default<I, O>(source, skip, limit, selector, X.notNull(projector), comparator, CqlResultor.New());
    }

    public static <I, O> CqlProjection<I, O> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, Aggregator<O, XSequence<O>> aggregator) {
        return new Default<I, O>(source, skip, limit, selector, projector, comparator, CqlResultor.NewFromAggregator(aggregator));
    }

    public static <I, O> CqlProjection<I, O> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, XSequence<O> target) {
        return new Default<I, O>(source, skip, limit, selector, projector, comparator, CqlResultor.New(target));
    }

    public static <I, O> CqlProjection<I, O> New(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, XSequence<O>> resultor) {
        return new Default<I, O>(source, skip, limit, selector, projector, comparator, resultor);
    }

    public static final class Default<I, O>
    extends CqlQuery.Abstract<I, O, XSequence<O>>
    implements CqlProjection<I, O> {
        Default(XIterable<? extends I> source, Long skip, Long limit, Predicate<? super I> selector, Function<? super I, O> projector, Comparator<? super O> comparator, CqlResultor<O, XSequence<O>> resultor) {
            super(source, skip, limit, selector, projector, comparator, resultor);
        }
    }
}

