/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.cql;

import java.util.Comparator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import one.microstream.X;
import one.microstream.collections.sorting.Sortable;
import one.microstream.collections.sorting.SortableProcedure;
import one.microstream.collections.types.XIterable;
import one.microstream.collections.types.XSequence;
import one.microstream.functional.Aggregator;
import one.microstream.util.cql.CQL;
import one.microstream.util.cql.CqlWrapperCollectorLinkingFinalizing;
import one.microstream.util.cql.CqlWrapperCollectorLinkingSorting;
import one.microstream.util.cql.CqlWrapperCollectorProcedure;
import one.microstream.util.cql.CqlWrapperCollectorSequenceSorting;

@FunctionalInterface
public interface CqlResultor<O, R> {
    public Aggregator<O, R> prepareCollector(XIterable<?> var1);

    public static <O> CqlResultor<O, XSequence<O>> New() {
        return e -> new CqlWrapperCollectorProcedure(CQL.prepareTargetCollection(e));
    }

    public static <O, T extends Consumer<O> & XIterable<O>> CqlResultor<O, T> New(T target) {
        X.notNull(target);
        return e -> new CqlWrapperCollectorProcedure(target);
    }

    public static <O, R> CqlResultor<O, R> NewFromAggregator(Aggregator<O, R> collector) {
        X.notNull(collector);
        return e -> collector;
    }

    public static <O, T extends Consumer<O>> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier) {
        return e -> new CqlWrapperCollectorProcedure((Consumer)supplier.get());
    }

    public static <O, T extends SortableProcedure<O> & XIterable<O>> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, Comparator<? super O> order) {
        X.notNull(supplier);
        return order == null ? CqlResultor.NewFromSupplier(supplier) : e -> new CqlWrapperCollectorSequenceSorting((SortableProcedure)supplier.get(), order);
    }

    public static <O, T> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, final BiConsumer<O, T> linker) {
        final T target = supplier.get();
        return new CqlResultor<O, T>(){

            @Override
            public Aggregator<O, T> prepareCollector(XIterable<?> source) {
                return new Aggregator<O, T>(){

                    @Override
                    public void accept(O element) {
                        linker.accept(element, target);
                    }

                    @Override
                    public T yield() {
                        return target;
                    }
                };
            }
        };
    }

    public static <O, T extends Sortable<O>> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, BiConsumer<O, T> linker, Comparator<? super O> order) {
        X.notNull(supplier);
        return order == null ? CqlResultor.NewFromSupplier(supplier, linker) : e -> new CqlWrapperCollectorLinkingSorting((Sortable)supplier.get(), linker, order);
    }

    public static <O, T> CqlResultor<O, T> NewFromSupplier(Supplier<T> supplier, BiConsumer<O, T> linker, Consumer<? super T> finalizer) {
        X.notNull(supplier);
        return finalizer == null ? CqlResultor.NewFromSupplier(supplier, linker) : e -> new CqlWrapperCollectorLinkingFinalizing(supplier.get(), linker, finalizer);
    }
}

