/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.similarity;

import one.microstream.X;
import one.microstream.collections.XArrays;
import one.microstream.equality.Equalator;
import one.microstream.util.similarity.MatchValidator;
import one.microstream.util.similarity.MultiMatchAssembler;
import one.microstream.util.similarity.MultiMatchResult;
import one.microstream.util.similarity.MultiMatcher;
import one.microstream.util.similarity.Similarity;
import one.microstream.util.similarity.Similator;

public interface MultiMatch<E> {
    public double similarityThreshold();

    public double singletonPrecedenceThreshold();

    public double singletonPrecedenceBonus();

    public double lowestSimilarity();

    public double averageSimilarity();

    public double highestSimilarity();

    public MultiMatchResult<E> result();

    public MultiMatchAssembler<E> assembler();

    public static <E> MultiMatch<E> New(MultiMatcher<E> matcher, E[] source, E[] target) {
        return new Default<E>(X.notNull(matcher), X.notNull(source), X.notNull(target));
    }

    public static class Default<E>
    implements MultiMatch<E> {
        private final MultiMatcher<E> matcher;
        private final MatchValidator<? super E> matchValidator;
        private final double similarityThreshold;
        private final double singletonPrecedenceThreshold;
        private final double singletonPrecedenceBonus;
        private final double noiseFactor;
        final E[] inputSource;
        final E[] inputTarget;
        final E[] source;
        final E[] target;
        final E[] linkedTargets;
        final E[] linkedSources;
        final int[] srcToTrgMap;
        final int[] trgToSrcMap;
        final int[] srcCandCount;
        final int[] trgCandCount;
        final double[][] matrix;
        final double[] linkedSourceSimilarities;
        int sourceCandidateCount;
        int targetCandidateCount;
        double averageSimilarity;
        double lowestSimilarity;
        double highestSimilarity;
        int matchCount;
        MultiMatchResult<E> result;

        public static int calculateMatchCount(int[] s2tMapping) {
            int matchCount = 0;
            int i = 0;
            while (i < s2tMapping.length) {
                if (s2tMapping[i] >= 0) {
                    ++matchCount;
                }
                ++i;
            }
            return matchCount;
        }

        public static double maxTargetQuantifier(double[] sTargets) {
            double maxQuantifier = 0.0;
            int t = 0;
            while (t < sTargets.length) {
                if (sTargets[t] > maxQuantifier) {
                    maxQuantifier = sTargets[t];
                }
                ++t;
            }
            return maxQuantifier;
        }

        public static double maxSourceQuantifier(double[][] quantifiers, int t) {
            double maxQuantifier = 0.0;
            int s = 0;
            while (s < quantifiers.length) {
                if (quantifiers[s][t] > maxQuantifier) {
                    maxQuantifier = quantifiers[s][t];
                }
                ++s;
            }
            return maxQuantifier;
        }

        protected Default(MultiMatcher<E> matcher, E[] source, E[] target) {
            this.matcher = matcher;
            this.matchValidator = matcher.validator();
            this.singletonPrecedenceThreshold = matcher.singletonPrecedenceThreshold();
            this.singletonPrecedenceBonus = matcher.singletonPrecedenceBonus();
            this.similarityThreshold = matcher.similarityThreshold();
            this.noiseFactor = matcher.noiseFactor();
            this.inputSource = source;
            this.source = (Object[])source.clone();
            this.inputTarget = target;
            this.target = (Object[])target.clone();
            this.linkedTargets = new Object[this.source.length];
            this.linkedSources = new Object[this.target.length];
            this.srcCandCount = new int[source.length];
            this.trgCandCount = new int[this.inputTarget.length];
            this.srcToTrgMap = new int[source.length];
            this.trgToSrcMap = new int[this.inputTarget.length];
            this.matrix = new double[source.length][this.inputTarget.length];
            this.linkedSourceSimilarities = new double[source.length];
        }

        @Override
        public double similarityThreshold() {
            return this.similarityThreshold;
        }

        @Override
        public double singletonPrecedenceThreshold() {
            return this.singletonPrecedenceThreshold;
        }

        @Override
        public double singletonPrecedenceBonus() {
            return this.singletonPrecedenceBonus;
        }

        @Override
        public double averageSimilarity() {
            return this.averageSimilarity;
        }

        @Override
        public double lowestSimilarity() {
            return this.lowestSimilarity;
        }

        @Override
        public double highestSimilarity() {
            return this.highestSimilarity;
        }

        protected void initializeLinkingArray() {
            XArrays.fill(this.srcToTrgMap, -1);
            XArrays.fill(this.trgToSrcMap, -1);
            System.arraycopy(this.inputSource, 0, this.source, 0, this.inputSource.length);
            System.arraycopy(this.inputTarget, 0, this.target, 0, this.inputTarget.length);
        }

        protected void initializeSimilarityArrays() {
            XArrays.fill(this.srcCandCount, 0);
            XArrays.fill(this.trgCandCount, 0);
            XArrays.fill(this.linkedSourceSimilarities, 0.0);
            int s = 0;
            while (s < this.matrix.length) {
                double[] sTargets = this.matrix[s];
                int t = 0;
                while (t < sTargets.length) {
                    sTargets[t] = 0.0;
                    ++t;
                }
                ++s;
            }
        }

        protected void buildSimilarityMatrix() {
            MultiMatcher<E> m = this.matcher;
            int s = 0;
            while (s < this.source.length) {
                if (this.source[s] != null) {
                    int t = 0;
                    while (t < this.target.length) {
                        if (this.target[t] != null) {
                            double d;
                            double sim = m.similator().evaluate(this.source[s], this.target[t]);
                            if (d >= this.similarityThreshold) {
                                this.matrix[s][t] = sim;
                                int n = s;
                                this.srcCandCount[n] = this.srcCandCount[n] + 1;
                                int n2 = t;
                                this.trgCandCount[n2] = this.trgCandCount[n2] + 1;
                            }
                        }
                        ++t;
                    }
                }
                ++s;
            }
        }

        protected void link(int s, int t) {
            this.srcToTrgMap[s] = t;
            this.linkedTargets[s] = this.inputTarget[this.srcToTrgMap[s]];
            this.trgToSrcMap[t] = s;
            this.linkedSources[t] = this.inputSource[this.trgToSrcMap[t]];
            this.target[t] = null;
            this.source[s] = null;
        }

        protected void linkOneMatched(int s, int t) {
            if (this.matchValidator != null && !this.matchValidator.isValidMatch(this.source[s], this.target[t], this.matrix[s][t], this.srcCandCount[s], this.trgCandCount[t])) {
                this.removeOne(this.srcCandCount, this.trgCandCount, s, t);
                return;
            }
            this.link(s, t);
            this.linkedSourceSimilarities[s] = this.matrix[s][t];
            double[] sourceTargets = this.matrix[s];
            int i = 0;
            while (i < sourceTargets.length) {
                if (sourceTargets[i] > 0.0) {
                    this.removeOne(this.srcCandCount, this.trgCandCount, s, i);
                }
                sourceTargets[i] = 0.0;
                ++i;
            }
            i = 0;
            while (i < this.matrix.length) {
                if (this.matrix[i][t] > 0.0) {
                    this.removeOne(this.srcCandCount, this.trgCandCount, i, t);
                }
                this.matrix[i][t] = 0.0;
                ++i;
            }
        }

        protected void linkAllEquals(Equalator<? super E> equalator) {
            if (equalator == null) {
                return;
            }
            int s = 0;
            while (s < this.source.length) {
                if (this.source[s] != null) {
                    int t = 0;
                    while (t < this.target.length) {
                        if (this.target[t] != null && equalator.equal(this.source[s], this.target[t])) {
                            this.link(s, t);
                        }
                        ++t;
                    }
                }
                ++s;
            }
        }

        protected void linkAllSimilar(Similator<? super E> similator) {
            if (similator == null) {
                return;
            }
            this.initializeSimilarityArrays();
            this.buildSimilarityMatrix();
            this.calculateCandidateCount();
            this.linkAllPerfect();
            if (this.similarityThreshold < this.noiseFactor) {
                this.removeNoise();
            }
            while (this.sourceCandidateCount > 0 && this.targetCandidateCount > 0) {
                if (this.linkAllUnconflicted() || this.resolveOneSourceSingleton() || this.resolveOneTargetSingleton()) continue;
                this.linkOneBestMatch();
            }
        }

        protected void linkAllPerfect() {
            int s = 0;
            while (s < this.source.length) {
                if (this.srcCandCount[s] != 0) {
                    double[] sTargets = this.matrix[s];
                    int t = 0;
                    while (t < this.target.length) {
                        if (sTargets[t] == 1.0) {
                            this.linkOneMatched(s, t);
                        }
                        ++t;
                    }
                }
                ++s;
            }
        }

        protected boolean linkAllUnconflicted() {
            boolean hasChanged = false;
            block0: while (true) {
                int s = 0;
                while (s < this.source.length) {
                    if (this.srcCandCount[s] == 1) {
                        double[] sTargets = this.matrix[s];
                        int t = 0;
                        while (t < sTargets.length) {
                            if (this.matrix[s][t] != 0.0 && this.trgCandCount[t] == 1) {
                                this.linkOneMatched(s, t);
                                hasChanged = true;
                                continue block0;
                            }
                            ++t;
                        }
                    }
                    ++s;
                }
                break;
            }
            return hasChanged;
        }

        protected boolean resolveOneSourceSingleton() {
            int s = 0;
            while (s < this.source.length) {
                if (this.srcCandCount[s] == 1) {
                    int t = 0;
                    while (t < this.target.length) {
                        if (this.matrix[s][t] != 0.0) {
                            int bsts = s;
                            double bestTargetSingletonQnt = this.matrix[s][t];
                            int i = s;
                            while (i < this.source.length) {
                                if (this.srcCandCount[i] == 1 && this.matrix[i][t] > bestTargetSingletonQnt) {
                                    bsts = i;
                                    bestTargetSingletonQnt = this.matrix[bsts][t];
                                }
                                ++i;
                            }
                            if (this.matrix[bsts][t] >= this.singletonPrecedenceThreshold) {
                                this.linkOneMatched(bsts, t);
                                return true;
                            }
                            int bots = bsts;
                            int i2 = 0;
                            while (i2 < this.source.length) {
                                if (this.matrix[i2][t] > bestTargetSingletonQnt) {
                                    bots = i2;
                                }
                                ++i2;
                            }
                            if (bots == bsts || this.matrix[bsts][t] * this.singletonPrecedenceBonus >= this.matrix[bots][t]) {
                                this.linkOneMatched(bsts, t);
                                return true;
                            }
                        }
                        ++t;
                    }
                }
                ++s;
            }
            return false;
        }

        protected boolean resolveOneTargetSingleton() {
            int t = 0;
            while (t < this.target.length) {
                if (this.trgCandCount[t] == 1) {
                    int s = 0;
                    while (s < this.source.length) {
                        if (this.matrix[s][t] != 0.0) {
                            int bsst = t;
                            double bestSourceSingletonQnt = this.matrix[s][t];
                            int i = t;
                            while (i < this.target.length) {
                                if (this.trgCandCount[i] == 1 && this.matrix[s][i] > bestSourceSingletonQnt) {
                                    bsst = i;
                                    bestSourceSingletonQnt = this.matrix[s][bsst];
                                }
                                ++i;
                            }
                            if (this.matrix[s][bsst] >= this.singletonPrecedenceThreshold) {
                                this.linkOneMatched(s, bsst);
                                return true;
                            }
                            int bost = bsst;
                            int i2 = 0;
                            while (i2 < this.target.length) {
                                if (this.matrix[s][i2] > bestSourceSingletonQnt) {
                                    bost = i2;
                                }
                                ++i2;
                            }
                            if (bost == bsst || this.matrix[s][bsst] * this.singletonPrecedenceBonus >= this.matrix[s][bost]) {
                                this.linkOneMatched(s, bsst);
                                return true;
                            }
                        }
                        ++s;
                    }
                }
                ++t;
            }
            return false;
        }

        protected void linkOneBestMatch() {
            int sMax = -1;
            int tMax = -1;
            double maxQuantifier = 0.0;
            int s = 0;
            while (s < this.source.length) {
                if ((double)this.srcCandCount[s] != 0.0) {
                    int t = 0;
                    while (t < this.target.length) {
                        if (this.matrix[s][t] > 0.0 && this.matrix[s][t] > maxQuantifier) {
                            sMax = s;
                            tMax = t;
                            maxQuantifier = this.matrix[sMax][tMax];
                        }
                        ++t;
                    }
                }
                ++s;
            }
            this.linkOneMatched(sMax, tMax);
        }

        protected void calculateCandidateCount() {
            int sc = 0;
            int s = 0;
            while (s < this.srcCandCount.length) {
                if (this.srcCandCount[s] > 0) {
                    ++sc;
                }
                ++s;
            }
            int tc = 0;
            int t = 0;
            while (t < this.trgCandCount.length) {
                if (this.trgCandCount[t] > 0) {
                    ++tc;
                }
                ++t;
            }
            this.sourceCandidateCount = sc;
            this.targetCandidateCount = tc;
        }

        protected void removeOne(int[] sCandCount, int[] tCandCount, int s, int t) {
            int n = t;
            tCandCount[n] = tCandCount[n] - 1;
            if (tCandCount[n] == 0) {
                --this.targetCandidateCount;
            }
            int n2 = s;
            sCandCount[n2] = sCandCount[n2] - 1;
            if (sCandCount[n2] == 0) {
                --this.sourceCandidateCount;
            }
        }

        protected void removeNoise() {
            double noiseThreshold;
            int s = 0;
            while (s < this.srcCandCount.length) {
                double[] sTargets;
                if (this.srcCandCount[s] != 0 && (noiseThreshold = Default.maxTargetQuantifier(sTargets = this.matrix[s]) * this.noiseFactor) != 0.0) {
                    int t = 0;
                    while (t < sTargets.length) {
                        if (sTargets[t] > 0.0 && sTargets[t] < noiseThreshold) {
                            this.removeOne(this.srcCandCount, this.trgCandCount, s, t);
                            sTargets[t] = 0.0;
                        }
                        ++t;
                    }
                }
                ++s;
            }
            int t = 0;
            while (t < this.trgCandCount.length) {
                if (this.trgCandCount[t] != 0 && (noiseThreshold = Default.maxSourceQuantifier(this.matrix, t) * this.noiseFactor) != 0.0) {
                    int s2 = 0;
                    while (s2 < this.matrix.length) {
                        if (this.matrix[s2][t] > 0.0 && this.matrix[s2][t] < noiseThreshold) {
                            this.removeOne(this.srcCandCount, this.trgCandCount, s2, t);
                            this.matrix[s2][t] = 0.0;
                        }
                        ++s2;
                    }
                }
                ++t;
            }
        }

        protected Default<E> match() {
            this.initializeLinkingArray();
            this.linkAllEquals(this.matcher.equalator());
            if (this.similarityThreshold > 0.0) {
                this.linkAllSimilar(this.matcher.similator());
            }
            this.calculateStatistics();
            return this;
        }

        private void calculateStatistics() {
            this.matchCount = Default.calculateMatchCount(this.srcToTrgMap);
            double lowest = Double.MAX_VALUE;
            double highest = 0.0;
            double total = 0.0;
            double[] dArray = this.linkedSourceSimilarities;
            int n = this.linkedSourceSimilarities.length;
            int n2 = 0;
            while (n2 < n) {
                double linkedSimilarity = dArray[n2];
                total += linkedSimilarity;
                if (linkedSimilarity < lowest) {
                    lowest = linkedSimilarity;
                }
                if (linkedSimilarity > highest) {
                    highest = linkedSimilarity;
                }
                ++n2;
            }
            this.averageSimilarity = this.matchCount == 0 ? 0.0 : total / (double)this.matchCount;
            this.lowestSimilarity = lowest;
            this.highestSimilarity = highest;
        }

        private MultiMatchResult<E> buildResult() {
            E[] source = this.inputSource;
            E[] target = this.inputTarget;
            int[] s2tMapping = this.srcToTrgMap;
            double[] linkedSims = this.linkedSourceSimilarities;
            Similarity<E>[] matchS = Similarity.Array(source.length);
            Similarity<E>[] matchT = Similarity.Array(target.length);
            int s = 0;
            while (s < source.length) {
                if (s2tMapping[s] >= 0) {
                    Similarity<E> item = Similarity.New(source[s], linkedSims[s], target[s2tMapping[s]]);
                    matchS[s] = item;
                    matchT[s2tMapping[s]] = matchS[s];
                }
                ++s;
            }
            return new MultiMatchResult.Default<E>(this.matchCount, X.ConstList(source), X.ConstList(target), X.ConstList(matchS), X.ConstList(matchT));
        }

        @Override
        public synchronized MultiMatchResult<E> result() {
            if (this.result == null) {
                this.result = this.buildResult();
            }
            return this.result;
        }

        @Override
        public MultiMatchAssembler<E> assembler() {
            return new MultiMatchAssembler.Default(this);
        }
    }
}

