/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.similarity;

import one.microstream.collections.BulkList;
import one.microstream.collections.ConstList;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.functional.XFunc;
import one.microstream.util.similarity.Similarity;

public interface MultiMatchResult<E> {
    public int matchCount();

    public XGettingSequence<E> inputSources();

    public XGettingSequence<E> inputTargets();

    public XGettingSequence<? extends Similarity<E>> matchesInSourceOrder();

    public XGettingSequence<? extends Similarity<E>> matchesInTargetOrder();

    public XGettingSequence<E> remainingSources();

    public XGettingSequence<E> remainingTargets();

    public XGettingSequence<E> unmatchedSources();

    public XGettingSequence<E> unmatchedTargets();

    public XGettingSequence<? extends Similarity<E>> sourceMatches();

    public XGettingSequence<? extends Similarity<E>> targetMatches();

    public XGettingList<E> matchedSources();

    public XGettingList<E> matchedTargets();

    public static class Default<E>
    implements MultiMatchResult<E> {
        final int matchCount;
        final ConstList<E> sources;
        final ConstList<E> targets;
        final ConstList<? extends Similarity<E>> matchesInSourceOrder;
        final ConstList<? extends Similarity<E>> matchesInTargetOrder;
        ConstList<E> remainingSources;
        ConstList<E> remainingTargets;
        ConstList<E> unmatchedSources;
        ConstList<E> unmatchedTargets;
        ConstList<E> matchedSources;
        ConstList<E> matchedTargets;
        ConstList<? extends Similarity<E>> sourceMatches;
        ConstList<? extends Similarity<E>> targetMatches;

        static <T> ConstList<T> collectRemaining(ConstList<T> input, ConstList<? extends Similarity<T>> matches) {
            BulkList remaining = BulkList.New(input.size());
            input.iterateIndexed((e, index) -> remaining.add(matches.at(index) == null ? e : null));
            return remaining.immure();
        }

        static <T> ConstList<T> collectUnmatched(ConstList<T> input, ConstList<? extends Similarity<T>> matches) {
            BulkList unmatched = BulkList.New(input.size());
            input.iterateIndexed((e, index) -> {
                if (matches.at(index) == null) {
                    unmatched.add(e);
                }
            });
            return unmatched.immure();
        }

        static <T> ConstList<T> collectMatched(ConstList<T> input, ConstList<? extends Similarity<T>> matches) {
            BulkList matched = BulkList.New(input.size());
            input.iterateIndexed((e, index) -> {
                if (matches.at(index) != null) {
                    matched.add(e);
                }
            });
            return matched.immure();
        }

        protected Default(int matchCount, ConstList<E> sourceInput, ConstList<E> targetInput, ConstList<? extends Similarity<E>> matchesInSourceOrder, ConstList<? extends Similarity<E>> matchesInTargetOrder) {
            this.matchCount = matchCount;
            this.sources = sourceInput;
            this.targets = targetInput;
            this.matchesInSourceOrder = matchesInSourceOrder;
            this.matchesInTargetOrder = matchesInTargetOrder;
        }

        @Override
        public int matchCount() {
            return this.matchCount;
        }

        @Override
        public XGettingSequence<E> inputSources() {
            return this.sources;
        }

        @Override
        public XGettingSequence<E> inputTargets() {
            return this.targets;
        }

        @Override
        public XGettingSequence<? extends Similarity<E>> matchesInSourceOrder() {
            return this.matchesInSourceOrder;
        }

        @Override
        public XGettingSequence<? extends Similarity<E>> matchesInTargetOrder() {
            return this.matchesInTargetOrder;
        }

        @Override
        public synchronized XGettingSequence<E> remainingSources() {
            if (this.remainingSources == null) {
                this.remainingSources = Default.collectRemaining(this.sources, this.matchesInSourceOrder);
            }
            return this.remainingSources;
        }

        @Override
        public synchronized XGettingSequence<E> remainingTargets() {
            if (this.remainingTargets == null) {
                this.remainingTargets = Default.collectRemaining(this.targets, this.matchesInTargetOrder);
            }
            return this.remainingTargets;
        }

        @Override
        public synchronized XGettingSequence<E> unmatchedSources() {
            if (this.unmatchedSources == null) {
                this.unmatchedSources = Default.collectUnmatched(this.sources, this.matchesInSourceOrder);
            }
            return this.unmatchedSources;
        }

        @Override
        public synchronized XGettingSequence<E> unmatchedTargets() {
            if (this.unmatchedTargets == null) {
                this.unmatchedTargets = Default.collectUnmatched(this.targets, this.matchesInTargetOrder);
            }
            return this.unmatchedTargets;
        }

        @Override
        public synchronized XGettingSequence<? extends Similarity<E>> sourceMatches() {
            if (this.sourceMatches == null) {
                this.sourceMatches = this.matchesInSourceOrder.filterTo(new BulkList(this.matchCount), XFunc.notNull()).immure();
            }
            return this.sourceMatches;
        }

        @Override
        public synchronized XGettingSequence<? extends Similarity<E>> targetMatches() {
            if (this.targetMatches == null) {
                this.targetMatches = this.matchesInTargetOrder.filterTo(new BulkList(this.matchCount), XFunc.notNull()).immure();
            }
            return this.targetMatches;
        }

        @Override
        public synchronized ConstList<E> matchedSources() {
            if (this.matchedSources == null) {
                this.matchedSources = Default.collectMatched(this.sources, this.matchesInSourceOrder);
            }
            return this.matchedSources;
        }

        @Override
        public synchronized ConstList<E> matchedTargets() {
            if (this.matchedTargets == null) {
                this.matchedTargets = Default.collectMatched(this.targets, this.matchesInTargetOrder);
            }
            return this.matchedTargets;
        }
    }
}

