/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.traversing;

import java.util.function.Function;
import one.microstream.chars.XChars;
import one.microstream.collections.EqHashEnum;
import one.microstream.collections.HashTable;
import one.microstream.collections.types.XGettingMap;
import one.microstream.hashing.HashEqualator;
import one.microstream.typing.KeyValue;

public final class DeduplicatorMultiType
implements Function<Object, Object> {
    private final HashTable<Class<?>, EqHashEnum<Object>> registry;

    public static DeduplicatorMultiType New(Class<?> ... types) {
        HashTable<Class<?>, EqHashEnum<Object>> registry = HashTable.New();
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            registry.add(type, EqHashEnum.New());
            ++n2;
        }
        return new DeduplicatorMultiType(registry);
    }

    public static DeduplicatorMultiType New(XGettingMap<Class<?>, HashEqualator<Object>> types) {
        HashTable<Class<?>, EqHashEnum<Object>> registry = HashTable.New();
        for (KeyValue keyValue : types) {
            registry.add((Class)keyValue.key(), EqHashEnum.New((HashEqualator)keyValue.value()));
        }
        return new DeduplicatorMultiType(registry);
    }

    DeduplicatorMultiType(HashTable<Class<?>, EqHashEnum<Object>> registry) {
        this.registry = registry;
    }

    @Override
    public final Object apply(Object instance) {
        System.out.println(XChars.systemString(instance));
        EqHashEnum<Object> typeRegistry = this.registry.get(instance.getClass());
        if (typeRegistry == null) {
            return instance;
        }
        return typeRegistry.deduplicate(instance);
    }
}

