/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.util.xcsv;

import one.microstream.chars._charArrayRange;
import one.microstream.collections.BulkList;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XSequence;
import one.microstream.exceptions.XCsvException;
import one.microstream.typing.XTypes;

public interface XCsvEntityParser<T> {
    public XGettingList<T> parse(_charArrayRange var1);

    public <C extends XSequence<? super T>> C parseInto(_charArrayRange var1, C var2);

    public static abstract class Abstract<T>
    implements XCsvEntityParser<T> {
        private static final int DEFAULT_COLLECTOR_CAPACITY = 1024;
        private final int columnCount;
        private final int collectorInitialCapacity;

        public Abstract(int columnCount) {
            this(columnCount, 1024);
        }

        public Abstract(int columnCount, int collectorInitialCapacity) {
            this.columnCount = columnCount;
            this.collectorInitialCapacity = collectorInitialCapacity;
        }

        @Override
        public BulkList<T> parse(_charArrayRange input) {
            return this.parseInto(input, this.collector());
        }

        protected BulkList<T> collector() {
            return new BulkList(this.collectorInitialCapacity);
        }

        protected int columnCount() {
            return this.columnCount;
        }

        protected void beginTable(String tableName, XGettingSequence<String> columnNames, XGettingList<String> columnTypes) {
        }

        protected void completeTable() {
        }

        protected void validateRow(BulkList<String> row) {
            if (XTypes.to_int(row.size()) == this.columnCount()) {
                return;
            }
            throw new XCsvException("Column count mismatch (" + row.size() + " != " + this.columnCount() + ")");
        }

        protected abstract T apply(BulkList<String> var1);
    }
}

