/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.wrapping.codegen;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import one.microstream.chars.VarString;
import one.microstream.exceptions.IORuntimeException;
import one.microstream.wrapping.Wrapper;

class WrapperTypeGenerator {
    private static final String JAVA_LANG_PACKAGE = "java.lang";
    final ProcessingEnvironment processingEnv;
    final TypeElement wrappedTypeElement;
    final Collection<ExecutableElement> methods;
    final String wrappedName;
    final String typeName;
    final String packageName;
    private final Map<String, String> imports = new HashMap<String, String>();
    private final VarString source = VarString.New();

    WrapperTypeGenerator(ProcessingEnvironment processingEnv, TypeElement wrappedTypeElement, Collection<ExecutableElement> methods) {
        this.processingEnv = processingEnv;
        this.wrappedTypeElement = wrappedTypeElement;
        this.methods = methods;
        this.wrappedName = wrappedTypeElement.getSimpleName().toString();
        this.typeName = "Wrapper".concat(this.wrappedName);
        this.packageName = processingEnv.getElementUtils().getPackageOf(wrappedTypeElement).getQualifiedName().toString().concat("._wrapper");
    }

    final void generateType() {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, VarString.New("Generating ").add(this.packageName).add('.').add(this.typeName).toString());
        this.generateCode();
        this.writeFile();
    }

    void generateCode() {
        this.add("public interface ").add(this.typeName).add(this.createTypeParameterDeclCode(this.wrappedTypeElement.getTypeParameters())).add(" extends ").add(this.addImport(Wrapper.class)).add("<").add(this.addImport(this.wrappedTypeElement.asType())).add(">, ").add(this.wrappedName).add(this.createTypeParameterNameCode(this.wrappedTypeElement.getTypeParameters()));
        this.newline().add("{");
        this.methods.forEach(method -> {
            ExecutableType methodType = (ExecutableType)this.processingEnv.getTypeUtils().asMemberOf((DeclaredType)this.wrappedTypeElement.asType(), (Element)method);
            if (this.hasGenericVarArgs((ExecutableElement)method, methodType)) {
                this.newline().tab().add("@SuppressWarnings(\"unchecked\")");
            }
            this.newline().tab().add("@Override").newline().tab().add("public default ");
            String typeParams = this.createTypeParameterDeclCode(method.getTypeParameters());
            if (typeParams.length() > 0) {
                this.add(typeParams).blank();
            }
            this.add(this.addImport(methodType.getReturnType())).blank().add(method.getSimpleName().toString()).add("(");
            List<? extends VariableElement> parameters = method.getParameters();
            int i = 0;
            int c = parameters.size();
            while (i < c) {
                if (i > 0) {
                    this.add(", ");
                }
                this.add("final ");
                TypeMirror paramType = methodType.getParameterTypes().get(i);
                if (i == c - 1 && method.isVarArgs()) {
                    this.add(this.addImport(((ArrayType)paramType).getComponentType())).add("...");
                } else {
                    this.add(this.addImport(paramType));
                }
                this.blank().add(parameters.get(i).getSimpleName().toString());
                ++i;
            }
            this.add(")");
            List<? extends TypeMirror> thrownTypes = methodType.getThrownTypes();
            if (thrownTypes.size() > 0) {
                this.add(" throws ").add(thrownTypes.stream().map(this::addImport).collect(Collectors.joining(", ")));
            }
            this.newline().tab().add("{").newline().tab(2);
            if (methodType.getReturnType().getKind() != TypeKind.VOID) {
                this.add("return ");
            }
            this.add("this.wrapped().").add(method.getSimpleName().toString()).add("(");
            this.add(parameters.stream().map(p -> p.getSimpleName().toString()).collect(Collectors.joining(", ")));
            this.add(");").newline();
            this.tab().add("}").newline();
        });
        this.add("}");
    }

    private boolean hasGenericVarArgs(ExecutableElement method, ExecutableType methodType) {
        return method.isVarArgs() && this.getVarArgType(method, methodType).getKind() == TypeKind.TYPEVAR;
    }

    private TypeMirror getVarArgType(ExecutableElement method, ExecutableType methodType) {
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        TypeMirror last = parameterTypes.get(parameterTypes.size() - 1);
        return ((ArrayType)last).getComponentType();
    }

    String addImport(TypeMirror type) {
        if (type.getKind() == TypeKind.ARRAY) {
            return this.addImport(((ArrayType)type).getComponentType()).concat("[]");
        }
        if (type.getKind() != TypeKind.DECLARED) {
            return type.toString();
        }
        DeclaredType declaredType = (DeclaredType)type;
        DeclaredType declaredTypeErasure = (DeclaredType)this.processingEnv.getTypeUtils().erasure(declaredType);
        TypeElement typeErasureElement = (TypeElement)declaredTypeErasure.asElement();
        String simpleName = typeErasureElement.getSimpleName().toString();
        String qualifiedName = typeErasureElement.getQualifiedName().toString();
        String packageName = this.processingEnv.getElementUtils().getPackageOf(typeErasureElement).toString();
        VarString vs = VarString.New();
        if (JAVA_LANG_PACKAGE.equals(packageName) || this.packageName.equals(packageName)) {
            vs.add(simpleName);
        } else {
            String mappedQualifiedName = this.imports.computeIfAbsent(simpleName, key -> qualifiedName);
            if (mappedQualifiedName.equals(qualifiedName)) {
                vs.add(simpleName);
            } else {
                vs.add(qualifiedName);
            }
        }
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() > 0) {
            vs.add(typeArguments.stream().map(this::addImport).collect(Collectors.joining(", ", "<", ">")));
        }
        return vs.toString();
    }

    String addImport(Class<?> type) {
        String simpleName = type.getSimpleName();
        if (JAVA_LANG_PACKAGE.equals(type.getPackage().getName())) {
            return simpleName;
        }
        String qualifiedName = type.getCanonicalName();
        String mappedQualifiedName = this.imports.computeIfAbsent(simpleName, key -> qualifiedName);
        return mappedQualifiedName.equals(qualifiedName) ? simpleName : qualifiedName;
    }

    String createTypeParameterNameCode(List<? extends TypeParameterElement> typeParameters) {
        return typeParameters.isEmpty() ? "" : typeParameters.stream().map(tp -> tp.getSimpleName().toString()).collect(Collectors.joining(", ", "<", ">"));
    }

    String createTypeParameterDeclCode(List<? extends TypeParameterElement> typeParameters) {
        return typeParameters.isEmpty() ? "" : typeParameters.stream().map(tp -> this.createTypeParameterDeclCode((TypeParameterElement)tp)).collect(Collectors.joining(", ", "<", ">"));
    }

    private String createTypeParameterDeclCode(TypeParameterElement typeParam) {
        String name = typeParam.getSimpleName().toString();
        List bounds = typeParam.getBounds().stream().filter(bound -> !((Object)bound).toString().equals(Object.class.getName())).collect(Collectors.toList());
        return bounds.isEmpty() ? name : String.valueOf(name) + bounds.stream().map(this::addImport).collect(Collectors.joining(" & ", " extends ", ""));
    }

    WrapperTypeGenerator add(String code) {
        this.source.add(code);
        return this;
    }

    WrapperTypeGenerator blank() {
        this.source.blank();
        return this;
    }

    WrapperTypeGenerator tab() {
        this.source.tab();
        return this;
    }

    WrapperTypeGenerator tab(int amount) {
        this.source.tab(amount);
        return this;
    }

    WrapperTypeGenerator newline() {
        this.source.add(System.lineSeparator());
        return this;
    }

    String getCode() {
        String lineSeparator = System.lineSeparator();
        VarString vs = VarString.New();
        vs.add("package ").add(this.packageName).add(";").add(lineSeparator);
        vs.add(lineSeparator);
        if (this.imports.size() > 0) {
            this.imports.values().forEach(path -> {
                VarString varString2 = vs.add("import ").add((String)path).add(";").add(lineSeparator);
            });
            vs.add(lineSeparator);
            vs.add(lineSeparator);
        }
        vs.add(this.source);
        return vs.toString();
    }

    private void writeFile() {
        try {
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(String.valueOf(this.packageName) + "." + this.typeName, this.wrappedTypeElement);
            Throwable throwable = null;
            Object var3_5 = null;
            try (Writer writer = file.openWriter();){
                writer.write(this.getCode());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

