/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

public final class CharView
implements CharSequence {
    final char[] data;
    final int offset;
    final int length;

    public CharView(char[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.length = length;
    }

    public final void validateIndex(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    public final void validateRange(int offset, int length) {
        this.validateIndex(offset);
        this.validateIndex(offset + length - 1);
    }

    @Override
    public final int length() {
        return this.length;
    }

    @Override
    public final char charAt(int index) {
        this.validateIndex(index);
        return this.data[this.offset + index];
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        this.validateIndex(start);
        this.validateIndex(end);
        if (start > end) {
            throw new IllegalArgumentException();
        }
        return new CharView(this.data, this.offset + start, end - start);
    }

    @Override
    public final String toString() {
        return new String(this.data, this.offset, this.length);
    }
}

