/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

import one.microstream.chars.XChars;
import one.microstream.chars._charDistance;

public final class Levenshtein {
    public static final double similiarity(String a, String b) {
        return Levenshtein.similarity(a, b, Levenshtein::charDistance);
    }

    public static final double upperCaseSimiliarity(String a, String b) {
        return Levenshtein.similarity(a.toUpperCase(), b.toUpperCase(), Levenshtein::charDistance);
    }

    public static final float charDistance(char a, char b) {
        return a == b ? 0.0f : 1.0f;
    }

    public static final double substringSimilarity(String s1, String s2) {
        char[] c2;
        char[] c1 = XChars.readChars(s1.toUpperCase());
        double minLen = c1.length < (c2 = XChars.readChars(s2.toUpperCase())).length ? c1.length : c2.length;
        return ((double)Levenshtein.max(XChars.commonSubstringLength(c1, c2) - 1, XChars.commonPrefixLength(c1, c2), XChars.commonSuffixLength(c1, c2)) / minLen + (double)Levenshtein.similarity(c1, c2)) / 2.0;
    }

    static final int max(int a, int b, int c) {
        return a >= b ? (a >= c ? a : c) : (b >= c ? b : c);
    }

    static final float min(float f1, float f2, float f3) {
        return f1 < f2 ? (f1 < f3 ? f1 : f3) : (f2 < f3 ? f2 : f3);
    }

    public static final float distance(String a, String b, _charDistance costFunction) {
        int lenA = a.length();
        if (lenA == 0) {
            return b.length();
        }
        int lenB = b.length();
        if (lenB == 0) {
            return lenA;
        }
        float[][] matrix = new float[lenA + 1][lenB + 1];
        int ia = 0;
        while (ia <= lenA) {
            matrix[ia][0] = ia;
            ++ia;
        }
        int ib = 0;
        while (ib <= lenB) {
            matrix[0][ib] = ib;
            ++ib;
        }
        ia = 0;
        while (ia < lenA) {
            int ib2 = 0;
            while (ib2 < lenB) {
                matrix[ia + 1][ib2 + 1] = Levenshtein.min(matrix[ia][ib2 + 1] + 1.0f, matrix[ia + 1][ib2] + 1.0f, matrix[ia][ib2] + costFunction.distance(a.charAt(ia), b.charAt(ib2)));
                ++ib2;
            }
            ++ia;
        }
        return matrix[lenA][lenB];
    }

    public static final float distance(CharSequence a, CharSequence b, _charDistance costFunction) {
        int lenA = a.length();
        if (lenA == 0) {
            return b.length();
        }
        int lenB = b.length();
        if (lenB == 0) {
            return lenA;
        }
        float[][] matrix = new float[lenA + 1][lenB + 1];
        int ia = 0;
        while (ia <= lenA) {
            matrix[ia][0] = ia;
            ++ia;
        }
        int ib = 0;
        while (ib <= lenB) {
            matrix[0][ib] = ib;
            ++ib;
        }
        ia = 0;
        while (ia < lenA) {
            int ib2 = 0;
            while (ib2 < lenB) {
                matrix[ia + 1][ib2 + 1] = Levenshtein.min(matrix[ia][ib2 + 1] + 1.0f, matrix[ia + 1][ib2] + 1.0f, matrix[ia][ib2] + costFunction.distance(a.charAt(ia), b.charAt(ib2)));
                ++ib2;
            }
            ++ia;
        }
        return matrix[lenA][lenB];
    }

    public static final float distance(char[] a, char[] b, _charDistance costFunction) {
        int lenA = a.length;
        if (lenA == 0) {
            return b.length;
        }
        int lenB = b.length;
        if (lenB == 0) {
            return lenA;
        }
        float[][] matrix = new float[lenA + 1][lenB + 1];
        int ia = 0;
        while (ia <= lenA) {
            matrix[ia][0] = ia;
            ++ia;
        }
        int ib = 0;
        while (ib <= lenB) {
            matrix[0][ib] = ib;
            ++ib;
        }
        ia = 0;
        while (ia < lenA) {
            int ib2 = 0;
            while (ib2 < lenB) {
                matrix[ia + 1][ib2 + 1] = Levenshtein.min(matrix[ia][ib2 + 1] + 1.0f, matrix[ia + 1][ib2] + 1.0f, matrix[ia][ib2] + costFunction.distance(a[ia], b[ib2]));
                ++ib2;
            }
            ++ia;
        }
        return matrix[lenA][lenB];
    }

    public static final float similarity(String a, String b, _charDistance costFunction) {
        if (a.isEmpty() && b.isEmpty()) {
            return 1.0f;
        }
        return 1.0f - Levenshtein.distance(a, b, costFunction) / (float)(a.length() < b.length() ? b.length() : a.length());
    }

    public static final float similarity(CharSequence a, CharSequence b, _charDistance costFunction) {
        if (a.length() == 0 && b.length() == 0) {
            return 1.0f;
        }
        return 1.0f - Levenshtein.distance(a, b, costFunction) / (float)(a.length() < b.length() ? b.length() : a.length());
    }

    public static final float similarity(char[] a, char[] b, _charDistance costFunction) {
        if (a.length == 0 && b.length == 0) {
            return 1.0f;
        }
        return 1.0f - Levenshtein.distance(a, b, costFunction) / (float)(a.length < b.length ? b.length : a.length);
    }

    public static final float similarity(String a, String b) {
        return Levenshtein.similarity(a, b, Levenshtein::charDistance);
    }

    public static final float similarity(CharSequence a, CharSequence b) {
        return Levenshtein.similarity(a, b, Levenshtein::charDistance);
    }

    public static final float similarity(char[] a, char[] b) {
        return Levenshtein.similarity(a, b, Levenshtein::charDistance);
    }

    private Levenshtein() {
        throw new UnsupportedOperationException();
    }
}

