/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

import one.microstream.chars.XChars;
import one.microstream.memory.XMemory;

public final class MemoryCharConversionIntegersUTF8 {
    private static final transient byte[] CHARS_MIN_VALUE_int = MemoryCharConversionIntegersUTF8.toSingleCharBytes(XChars.CHARS_MIN_VALUE_int);
    private static final transient byte[] CHARS_MIN_VALUE_long = MemoryCharConversionIntegersUTF8.toSingleCharBytes(XChars.CHARS_MIN_VALUE_long);
    private static final transient byte[] DECIMAL_CHAR_TABLE_10S = MemoryCharConversionIntegersUTF8.toSingleCharBytes(XChars.DECIMAL_CHAR_TABLE_10S);
    private static final transient byte[] DECIMAL_CHAR_TABLE_01S = MemoryCharConversionIntegersUTF8.toSingleCharBytes(XChars.DECIMAL_CHAR_TABLE_01S);
    private static final int V001G = 1000000000;
    private static final int V100M = 100000000;
    private static final int V010M = 10000000;
    private static final int V001M = 1000000;
    private static final int V100K = 100000;
    private static final int V010K = 10000;
    private static final int V001K = 1000;
    private static final int V100 = 100;
    private static final int V010 = 10;
    private static final long V001Z = 1000000000000000000L;
    private static final long V100P = 100000000000000000L;
    private static final long V010P = 10000000000000000L;
    private static final long V001P = 1000000000000000L;
    private static final long V100T = 100000000000000L;
    private static final long V010T = 10000000000000L;
    private static final long V001T = 1000000000000L;
    private static final long V100G = 100000000000L;
    private static final long V010G = 10000000000L;
    private static final transient int MAX_CHAR_COUNT_int = CHARS_MIN_VALUE_int.length;
    private static final transient int MAX_CHAR_COUNT_long = CHARS_MIN_VALUE_long.length;
    private static final transient int BYTE_SIZE_CHAR = XMemory.byteSize_byte();
    private static final transient int BYTE_SIZE_DOUBLECHAR = 2 * BYTE_SIZE_CHAR;
    private static final transient int MAX_BYTE_COUNT_int = BYTE_SIZE_CHAR * MAX_CHAR_COUNT_int;
    private static final transient int MAX_BYTE_COUNT_long = BYTE_SIZE_CHAR * MAX_CHAR_COUNT_long;
    private static final byte MINUS = 45;

    private static byte[] toSingleCharBytes(char[] chars) {
        byte[] bytes = new byte[chars.length];
        int i = 0;
        while (i < chars.length) {
            bytes[i] = (byte)chars[i];
            ++i;
        }
        return bytes;
    }

    public static final long put_byte(byte value, long address) {
        if (value < 0) {
            return MemoryCharConversionIntegersUTF8.put_intPositive5(-value, MemoryCharConversionIntegersUTF8.putMinus(address));
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive5(value, address);
    }

    public static final long put_short(short value, long address) {
        if (value < 0) {
            return MemoryCharConversionIntegersUTF8.put_intPositive5(-value, MemoryCharConversionIntegersUTF8.putMinus(address));
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive5(value, address);
    }

    public static final long put_int(int value, long address) {
        if (value < 0) {
            return MemoryCharConversionIntegersUTF8.put_intNegative(value, address);
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive(value, address);
    }

    public static final long put_long(long value, long address) {
        if (value < 0L) {
            return MemoryCharConversionIntegersUTF8.put_longNegative(value, address);
        }
        return MemoryCharConversionIntegersUTF8.put_longPositive(value, address);
    }

    private static long putMinus(long address) {
        XMemory.set_byte(address, (byte)45);
        return address + (long)BYTE_SIZE_CHAR;
    }

    private static long put1Char(int singleDigitValue, long address) {
        XMemory.set_byte(address, (byte)(48 + singleDigitValue));
        return address + (long)BYTE_SIZE_CHAR;
    }

    private static long put2Chars(int doubleDigitValue, long address) {
        XMemory.set_byte(address, DECIMAL_CHAR_TABLE_10S[doubleDigitValue]);
        XMemory.set_byte(address + (long)BYTE_SIZE_CHAR, DECIMAL_CHAR_TABLE_01S[doubleDigitValue]);
        return address + (long)BYTE_SIZE_DOUBLECHAR;
    }

    private static long put_longNegative(long value, long address) {
        if (value == Long.MIN_VALUE) {
            XMemory.copyArrayToAddress(CHARS_MIN_VALUE_long, address);
            return address + (long)MAX_BYTE_COUNT_long;
        }
        return MemoryCharConversionIntegersUTF8.put_longPositive(-value, MemoryCharConversionIntegersUTF8.putMinus(address));
    }

    private static long put_intNegative(int value, long address) {
        if (value == Integer.MIN_VALUE) {
            XMemory.copyArrayToAddress(CHARS_MIN_VALUE_int, address);
            return address + (long)MAX_BYTE_COUNT_int;
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive(-value, MemoryCharConversionIntegersUTF8.putMinus(address));
    }

    public static final long put_longPositive(long value, long address) {
        if (value >= 1000000000L) {
            if (value >= 1000000000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveHI(value % 1000000000000000000L, MemoryCharConversionIntegersUTF8.put1Char((int)(value / 1000000000000000000L), address));
            }
            if (value >= 100000000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveHI(value, address);
            }
            if (value >= 10000000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveFG(value % 10000000000000000L, MemoryCharConversionIntegersUTF8.put1Char((int)(value / 10000000000000000L), address));
            }
            if (value >= 1000000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveFG(value, address);
            }
            if (value >= 100000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveDE(value % 100000000000000L, MemoryCharConversionIntegersUTF8.put1Char((int)(value / 100000000000000L), address));
            }
            if (value >= 10000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveDE(value, address);
            }
            if (value >= 1000000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveBC(value % 1000000000000L, MemoryCharConversionIntegersUTF8.put1Char((int)(value / 1000000000000L), address));
            }
            if (value >= 100000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositiveBC(value, address);
            }
            if (value >= 10000000000L) {
                return MemoryCharConversionIntegersUTF8.put_longPositive9A(value % 10000000000L, MemoryCharConversionIntegersUTF8.put1Char((int)(value / 10000000000L), address));
            }
            return MemoryCharConversionIntegersUTF8.put_longPositive9A(value, address);
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive((int)value, address);
    }

    private static long put_intPositive(int value, long address) {
        if (value >= 100000) {
            if (value >= 1000000000) {
                return MemoryCharConversionIntegersUTF8.put_intPositive9m(value, address);
            }
            if (value >= 100000000) {
                return MemoryCharConversionIntegersUTF8.put_intPositive78(value % 100000000, MemoryCharConversionIntegersUTF8.put1Char(value / 100000000, address));
            }
            if (value >= 10000000) {
                return MemoryCharConversionIntegersUTF8.put_intPositive78(value, address);
            }
            if (value >= 1000000) {
                return MemoryCharConversionIntegersUTF8.put_intPositive56(value % 1000000, MemoryCharConversionIntegersUTF8.put1Char(value / 1000000, address));
            }
            return MemoryCharConversionIntegersUTF8.put_intPositive56(value, address);
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive5(value, address);
    }

    private static long put_intPositive5(int value, long address) {
        if (value >= 100) {
            if (value >= 10000) {
                return MemoryCharConversionIntegersUTF8.put_intPositive43(value % 10000, MemoryCharConversionIntegersUTF8.put1Char(value / 10000, address));
            }
            if (value >= 1000) {
                return MemoryCharConversionIntegersUTF8.put_intPositive43(value, address);
            }
            return MemoryCharConversionIntegersUTF8.put2Chars(value % 100, MemoryCharConversionIntegersUTF8.put1Char(value / 100, address));
        }
        return MemoryCharConversionIntegersUTF8.put_intPositive21(value, address);
    }

    private static long put_longPositiveHI(long value, long address) {
        return MemoryCharConversionIntegersUTF8.put_longPositiveFG(value % 10000000000000000L, MemoryCharConversionIntegersUTF8.put2Chars((int)(value / 10000000000000000L), address));
    }

    private static long put_longPositiveFG(long value, long address) {
        return MemoryCharConversionIntegersUTF8.put_longPositiveDE(value % 100000000000000L, MemoryCharConversionIntegersUTF8.put2Chars((int)(value / 100000000000000L), address));
    }

    private static long put_longPositiveDE(long value, long address) {
        return MemoryCharConversionIntegersUTF8.put_longPositiveBC(value % 1000000000000L, MemoryCharConversionIntegersUTF8.put2Chars((int)(value / 1000000000000L), address));
    }

    private static long put_longPositiveBC(long value, long address) {
        return MemoryCharConversionIntegersUTF8.put_longPositive9A(value % 10000000000L, MemoryCharConversionIntegersUTF8.put2Chars((int)(value / 10000000000L), address));
    }

    private static long put_longPositive9A(long value, long address) {
        return MemoryCharConversionIntegersUTF8.put_intPositive78((int)(value % 100000000L), MemoryCharConversionIntegersUTF8.put2Chars((int)(value / 100000000L), address));
    }

    private static long put_intPositive9m(int value, long address) {
        return MemoryCharConversionIntegersUTF8.put_intPositive78(value % 100000000, MemoryCharConversionIntegersUTF8.put2Chars(value / 100000000, address));
    }

    private static long put_intPositive78(int value, long address) {
        return MemoryCharConversionIntegersUTF8.put_intPositive56(value % 1000000, MemoryCharConversionIntegersUTF8.put2Chars(value / 1000000, address));
    }

    private static long put_intPositive56(int value, long address) {
        return MemoryCharConversionIntegersUTF8.put_intPositive43(value % 10000, MemoryCharConversionIntegersUTF8.put2Chars(value / 10000, address));
    }

    private static long put_intPositive43(int value, long address) {
        return MemoryCharConversionIntegersUTF8.put2Chars(value % 100, MemoryCharConversionIntegersUTF8.put2Chars(value / 100, address));
    }

    private static long put_intPositive21(int value, long address) {
        return value >= 10 ? MemoryCharConversionIntegersUTF8.put2Chars(value, address) : MemoryCharConversionIntegersUTF8.put1Char(value, address);
    }

    static final long put_int3(int value, long address) {
        if (value >= 100) {
            return MemoryCharConversionIntegersUTF8.put2Chars(value % 100, MemoryCharConversionIntegersUTF8.put1Char(value / 100, address));
        }
        return value >= 10 ? MemoryCharConversionIntegersUTF8.put2Chars(value, address) : MemoryCharConversionIntegersUTF8.put1Char(value, address);
    }

    private MemoryCharConversionIntegersUTF8() {
        throw new UnsupportedOperationException();
    }
}

