/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.chars;

import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import one.microstream.X;
import one.microstream.chars.XChars;
import one.microstream.collections.XArrays;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.exceptions.ArrayCapacityException;
import one.microstream.functional._charProcedure;
import one.microstream.math.XMath;

public final class VarString
implements CharSequence,
java.lang.Appendable,
Serializable {
    private static final int LITERAL_LENGTH_DUAL_CHAR = 2;
    private static final int LITERAL_LENGTH_CR_LF = 2;
    private static final int LITERAL_LENGTH_HEX_DEC_BYTE = 2;
    private static final int LITERAL_LENGTH_TRIPLE_CHAR = 3;
    private static final int LITERAL_LENGTH_NULL = 4;
    private static final int LITERAL_LENGTH_TRUE = 4;
    private static final int LITERAL_LENGTH_FALSE = 5;
    private static final int MINIMUM_CAPACITY = 4;
    private static final char BLANK = ' ';
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char TAB = '\t';
    char[] data;
    int size;

    public static final void addNonNull(VarString vs, Object object) {
        if (object == null) {
            return;
        }
        vs.add(object);
    }

    public static void commaSpace(VarString vs, Object element) {
        vs.add(element).add(',', ' ');
    }

    private static int calculateNewCapacity(int capacity, int minimumCapacity) {
        if (XMath.isGreaterThanHighestPowerOf2(minimumCapacity)) {
            return Integer.MAX_VALUE;
        }
        int c = capacity;
        while (c < minimumCapacity) {
            c <<= 1;
        }
        return c;
    }

    public static final VarString New() {
        return new VarString(4);
    }

    public static final VarString New(int initialMinimumCapacity) {
        return new VarString(VarString.calculateNewCapacity(4, initialMinimumCapacity));
    }

    public static final VarString New(String s) {
        if (s == null) {
            return VarString.New().addNull();
        }
        return VarString.New(s.length()).add(s);
    }

    VarString(int initialCapacity) {
        this.data = new char[initialCapacity];
        this.size = 0;
    }

    private void internalAdd(char c) {
        if (this.size >= this.data.length) {
            if (this.size >= Integer.MAX_VALUE) {
                throw new ArrayCapacityException();
            }
            this.data = new char[(int)((float)this.data.length * 2.0f)];
            System.arraycopy(this.data, 0, this.data, 0, this.size);
        }
        this.data[this.size++] = c;
    }

    private void internalAdd(String s) {
        this.ensureFreeCapacity(s.length());
        this.size = XChars.put(s, this.data, this.size);
    }

    public final void add(char[] chars, int offset, int length) {
        this.ensureFreeCapacity(length);
        System.arraycopy(chars, offset, this.data, this.size, length);
        this.size += length;
    }

    private void internalAdd(char[] chars) {
        this.ensureFreeCapacity(chars.length);
        System.arraycopy(chars, 0, this.data, this.size, chars.length);
        this.size += chars.length;
    }

    private void internalAddNull() {
        this.ensureFreeCapacity(4);
        this.size = XChars.putNull(this.data, this.size);
    }

    private void internalAddTrue() {
        this.ensureFreeCapacity(4);
        this.size = XChars.putTrue(this.data, this.size);
    }

    private void internalAddFalse() {
        this.ensureFreeCapacity(5);
        this.size = XChars.putFalse(this.data, this.size);
    }

    private void internalAddObject(Object object) {
        if (object == null) {
            this.internalAddNull();
            return;
        }
        if (object instanceof CharSequence) {
            this.internalAdd((CharSequence)object);
            return;
        }
        this.internalAdd(object.toString());
    }

    private void internalAdd(CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return;
        }
        if (charSequence instanceof VarString) {
            this.add(((VarString)charSequence).data, 0, ((VarString)charSequence).size);
            return;
        }
        if (charSequence instanceof StringBuilder) {
            StringBuilder sb = (StringBuilder)charSequence;
            sb.getChars(0, charSequence.length(), this.data, this.size);
            this.size += charSequence.length();
            return;
        }
        if (charSequence instanceof StringBuffer) {
            StringBuffer sb = (StringBuffer)charSequence;
            sb.getChars(0, charSequence.length(), this.data, this.size);
            this.size += charSequence.length();
            return;
        }
        this.internalAdd(charSequence.toString());
    }

    private void rebuild(int newCapacity) {
        this.data = new char[newCapacity];
        System.arraycopy(this.data, 0, this.data, 0, this.size);
    }

    public final void validateIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new StringIndexOutOfBoundsException(index);
        }
    }

    public final void validateRange(int offset, int length) {
        this.validateIndex(offset);
        if (length != 0) {
            this.validateIndex(offset + length - 1);
        }
    }

    public final char last() {
        this.validateIndex(0);
        return this.data[this.size - 1];
    }

    public final char first() {
        this.validateIndex(0);
        return this.data[0];
    }

    public final VarString add(char c) {
        this.internalAdd(c);
        return this;
    }

    public final VarString add(Character c) {
        if (c == null) {
            this.internalAddNull();
        } else {
            this.internalAdd(c.charValue());
        }
        return this;
    }

    public final VarString add(char c1, char c2) {
        this.ensureFreeCapacity(2);
        this.data[this.size] = c1;
        this.data[this.size + 1] = c2;
        this.size += 2;
        return this;
    }

    public final VarString add(char c1, char c2, char c3) {
        this.ensureFreeCapacity(3);
        this.data[this.size] = c1;
        this.data[this.size + 1] = c2;
        this.data[this.size + 2] = c3;
        this.size += 3;
        return this;
    }

    public final VarString add(byte value) {
        this.ensureFreeCapacity(XChars.maxCharCount_byte());
        this.size = XChars.put(value, this.data, this.size);
        return this;
    }

    public final VarString add(boolean value) {
        if (value) {
            this.internalAddTrue();
        } else {
            this.internalAddFalse();
        }
        return this;
    }

    public final VarString addMapped(boolean value, String trueValue, String falseValue) {
        return this.add(value ? trueValue : falseValue);
    }

    public final VarString addMapped(Boolean value, String trueValue, String falseValue) {
        return value != null ? this.add(value != false ? trueValue : falseValue) : this;
    }

    public final VarString add(short value) {
        this.ensureFreeCapacity(XChars.maxCharCount_short());
        this.size = XChars.put(value, this.data, this.size);
        return this;
    }

    public final VarString add(int value) {
        this.ensureFreeCapacity(XChars.maxCharCount_int());
        this.size = XChars.put(value, this.data, this.size);
        return this;
    }

    public final VarString add(float value) {
        this.ensureFreeCapacity(XChars.maxCharCount_float());
        this.size = XChars.put(value, this.data, this.size);
        return this;
    }

    public final VarString add(long value) {
        this.ensureFreeCapacity(XChars.maxCharCount_long());
        this.size = XChars.put(value, this.data, this.size);
        return this;
    }

    public final VarString add(double value) {
        this.ensureFreeCapacity(XChars.maxCharCount_double());
        this.size = XChars.put(value, this.data, this.size);
        return this;
    }

    public final VarString add(char[] chars) {
        this.internalAdd(chars);
        return this;
    }

    public final VarString add(String s) {
        if (s == null) {
            this.internalAddNull();
        } else {
            this.internalAdd(s);
        }
        return this;
    }

    public final VarString add(VarString vs) {
        if (vs == null) {
            this.internalAddNull();
        } else {
            this.add(vs.data, 0, vs.size);
        }
        return this;
    }

    public final VarString add(CharSequence cs) {
        if (cs == null) {
            this.internalAddNull();
        } else {
            this.internalAdd(cs);
        }
        return this;
    }

    public final VarString add(Object o) {
        this.internalAddObject(o);
        return this;
    }

    public final VarString addHexDec(byte value) {
        this.ensureFreeCapacity(2);
        this.size = XChars.putHexDec(value, this.data, this.size);
        return this;
    }

    public final VarString addHexDec(byte ... bytes) {
        this.ensureFreeCapacity(bytes.length << 1);
        int size = this.size;
        char[] data = this.data;
        int i = 0;
        while (i < bytes.length) {
            size = XChars.putHexDec(bytes[i], data, size);
            ++i;
        }
        this.size = size;
        return this;
    }

    public final VarString addObjects(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.add(o);
            ++n2;
        }
        return this;
    }

    public final void ensureFreeCapacity(int minimumFreeCapacity) {
        if (Integer.MAX_VALUE - minimumFreeCapacity < this.size && minimumFreeCapacity > 0) {
            throw new ArrayCapacityException(Integer.MAX_VALUE + (long)minimumFreeCapacity);
        }
        this.ensureCapacity(this.size + minimumFreeCapacity);
    }

    public final void ensureCapacity(int minimumCapacity) {
        if (this.data.length >= minimumCapacity) {
            return;
        }
        this.rebuild(VarString.calculateNewCapacity(this.data.length, minimumCapacity));
    }

    public final VarString addChars(char ... chars) {
        this.add(chars, 0, chars.length);
        return this;
    }

    public final VarString addCharSequences(CharSequence ... csqs) {
        CharSequence[] charSequenceArray = csqs;
        int n = csqs.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence csq = charSequenceArray[n2];
            this.add(csq);
            ++n2;
        }
        return this;
    }

    public final VarString addNull() {
        this.internalAddNull();
        return this;
    }

    public final VarString addTrue() {
        this.internalAddTrue();
        return this;
    }

    public final VarString addFalse() {
        this.internalAddFalse();
        return this;
    }

    public final VarString append(Appendable appendable) {
        if (appendable == null) {
            this.internalAddNull();
        } else {
            appendable.appendTo(this);
        }
        return this;
    }

    public final <E> VarString add(E element, BiConsumer<VarString, ? super E> joiner) {
        joiner.accept(this, element);
        return this;
    }

    public final <E> VarString addAll(E[] elements, BiConsumer<VarString, ? super E> joiner) {
        this.uncheckedAddAll(elements, 0, elements.length, joiner);
        return this;
    }

    public final <E> VarString addAll(E[] elements, int offset, int length, BiConsumer<VarString, ? super E> joiner) {
        XArrays.validateArrayRange(elements, offset, length);
        this.uncheckedAddAll(elements, offset, length, joiner);
        return this;
    }

    private <E> void uncheckedAddAll(E[] elements, int offset, int length, BiConsumer<VarString, ? super E> joiner) {
        int bound = offset + length;
        int i = offset;
        while (i < bound) {
            joiner.accept(this, elements[i]);
            ++i;
        }
    }

    public final <E> VarString addAll(Iterable<? extends E> elements, BiConsumer<VarString, ? super E> joiner) {
        for (E element : elements) {
            joiner.accept(this, element);
        }
        return this;
    }

    public final VarString set(int index, char c) {
        this.validateIndex(index);
        this.data[index] = c;
        return this;
    }

    public final VarString setChars(int index, char ... c) {
        this.validateIndex(index + c.length - 1);
        System.arraycopy(c, 0, this.data, index, c.length);
        return this;
    }

    public final VarString setLast(char c) {
        this.validateIndex(0);
        this.data[this.size - 1] = c;
        return this;
    }

    public final VarString reverse() {
        XChars.uncheckedReverse(this.data, this.size);
        return this;
    }

    @Deprecated
    public final VarString surrogateCharReverse() {
        return this.reverse();
    }

    public final int indexOf(char c) {
        return XChars.uncheckedIndexOf(this.data, this.size, 0, c);
    }

    public final int indexOf(char c, int offset) {
        this.validateIndex(offset);
        return XChars.uncheckedIndexOf(this.data, this.size, offset, c);
    }

    public final int indexOf(char[] chars) {
        return XChars.uncheckedIndexOf(this.data, this.size, chars);
    }

    public final int indexOf(char[] chars, int offset) {
        this.validateIndex(offset);
        return XChars.indexOf(chars, offset, this.size - offset, chars);
    }

    public final int indexOf(String s) {
        return XChars.indexOf(this.data, 0, this.size, XChars.readChars(s), 0, s.length(), 0);
    }

    public final int indexOf(String s, int offset) {
        return XChars.indexOf(this.data, 0, this.size, XChars.readChars(s), 0, s.length(), offset);
    }

    public final int indexOf(VarString vc) {
        return XChars.indexOf(this.data, this.size, vc.data, vc.size, 0);
    }

    public final int indexOf(VarString vc, int offset) {
        return XChars.indexOf(this.data, this.size, vc.data, vc.size, offset);
    }

    public final boolean contains(char c) {
        return XChars.uncheckedContains(this.data, 0, this.size, c);
    }

    public final boolean contains(char[] chars) {
        return XChars.uncheckedIndexOf(this.data, this.size, chars) != -1;
    }

    public final boolean contains(String s) {
        return XChars.uncheckedIndexOf(this.data, this.size, XChars.readChars(s)) != -1;
    }

    public final boolean contains(VarString vc) {
        return XChars.indexOf(this.data, this.size, vc.data, vc.size, 0) != -1;
    }

    public final int lastIndexOf(char c) {
        return XChars.uncheckedLastIndexOf(this.data, this.size, c);
    }

    public final int lastIndexOf(char c, int offset) {
        this.validateIndex(offset);
        return XChars.uncheckedLastIndexOf(this.data, offset, c);
    }

    public final int count(char c) {
        return XChars.count(this.data, 0, this.size, c);
    }

    public final int count(char[] chars) {
        return XChars.count(this.data, 0, this.size, chars, 0, chars.length);
    }

    public final int count(String s) {
        return XChars.count(this.data, 0, this.size, XChars.readChars(s), 0, s.length());
    }

    public final int count(VarString vc) {
        return XChars.count(this.data, 0, this.size, vc.data, 0, vc.size);
    }

    public final VarString deleteAt(int index) {
        this.validateIndex(index);
        System.arraycopy(this.data, index + 1, this.data, index, this.size - index);
        --this.size;
        return this;
    }

    public final VarString deleteLast() {
        this.validateIndex(0);
        --this.size;
        return this;
    }

    public final VarString deleteLast(int n) {
        if (n != 0) {
            this.validateIndex(this.size - n);
            this.size -= n;
        }
        return this;
    }

    public final VarString shrinkTo(int n) {
        this.validateIndex(n - 1);
        this.size = n;
        return this;
    }

    public final char[] toArray() {
        char[] chars = new char[this.size];
        System.arraycopy(this.data, 0, chars, 0, this.size);
        return chars;
    }

    public final VarString copyTo(char[] target, int targetOffset) {
        System.arraycopy(this.data, 0, target, targetOffset, this.size);
        return this;
    }

    public final VarString copyTo(int offset, char[] target, int targetOffset, int length) {
        this.validateRange(offset, length);
        System.arraycopy(this.data, offset, target, targetOffset, length);
        return this;
    }

    @Override
    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final VarString consolidate() {
        int requiredCapacity = VarString.calculateNewCapacity(1, this.size);
        if (requiredCapacity < this.data.length) {
            this.rebuild(requiredCapacity);
        }
        return this;
    }

    public final VarString trim() {
        int size = this.size;
        int start = 0;
        char[] data = this.data;
        while (start < size && data[start] <= ' ') {
            ++start;
        }
        while (start < size && data[size - 1] <= ' ') {
            --size;
        }
        if (start != 0) {
            System.arraycopy(data, start, data, 0, size - start);
        }
        this.size = size - start;
        return this;
    }

    public final VarString truncateTo(int newLength) {
        this.validateIndex(newLength - 1);
        this.size = newLength;
        return this;
    }

    public final VarString subsequence(int beginIndex, int endIndex) {
        this.validateIndex(beginIndex);
        this.validateIndex(endIndex);
        int length = endIndex - beginIndex;
        this.validateIndex(length);
        VarString subsequence = VarString.New(length);
        System.arraycopy(this.data, beginIndex, subsequence.data, 0, length);
        subsequence.size = length;
        return subsequence;
    }

    public final String substring(int beginIndex, int endIndex) {
        this.validateIndex(beginIndex);
        this.validateIndex(endIndex);
        this.validateIndex(endIndex - beginIndex);
        return new String(this.data, beginIndex, endIndex - beginIndex);
    }

    public final void iterate(_charProcedure iterator) {
        XChars.iterate(this.data, 0, this.size, iterator);
    }

    public final VarString list(String separator, XGettingCollection<?> listElements) {
        if (X.hasNoContent(listElements)) {
            return this;
        }
        char[] sepChars = XChars.readChars(separator);
        for (Object e : listElements) {
            this.internalAddObject(e);
            this.internalAdd(sepChars);
        }
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, Object ... listElements) {
        if (XArrays.hasNoContent(listElements)) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * separator.length());
        char[] sepChars = XChars.readChars(separator);
        Object[] objectArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            this.internalAddObject(e);
            this.internalAdd(sepChars);
            ++n2;
        }
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, String ... listElements) {
        if (XArrays.hasNoContent(listElements)) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * separator.length());
        char[] sepChars = XChars.readChars(separator);
        String[] stringArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (e == null) {
                this.internalAddNull();
            } else {
                this.internalAdd(e);
            }
            this.internalAdd(sepChars);
            ++n2;
        }
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, VarString ... listElements) {
        if (XArrays.hasNoContent(listElements)) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * separator.length());
        char[] sepChars = XChars.readChars(separator);
        VarString[] varStringArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            VarString e = varStringArray[n2];
            if (e == null) {
                this.internalAddNull();
            } else {
                this.internalAdd(e);
            }
            this.internalAdd(sepChars);
            ++n2;
        }
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, Appendable ... listElements) {
        if (XArrays.hasNoContent(listElements)) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * separator.length());
        char[] sepChars = XChars.readChars(separator);
        Appendable[] appendableArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            Appendable e = appendableArray[n2];
            if (e == null) {
                this.addNull();
            } else {
                e.appendTo(this);
            }
            this.add(sepChars);
            ++n2;
        }
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, boolean ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_boolean() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        boolean[] blArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            boolean e = blArray[n2];
            size = XChars.put(sepChars, data, e ? XChars.putTrue(data, size) : XChars.putFalse(data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, byte ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_byte() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        byte[] byArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            byte e = byArray[n2];
            size = XChars.put(sepChars, data, XChars.put(e, data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, short ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_short() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        short[] sArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            short e = sArray[n2];
            size = XChars.put(sepChars, data, XChars.put(e, data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, int ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_int() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        int[] nArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            size = XChars.put(sepChars, data, XChars.put(e, data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, long ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_long() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        long[] lArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            size = XChars.put(sepChars, data, XChars.put(e, data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, float ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_float() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        float[] fArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            float e = fArray[n2];
            size = XChars.put(sepChars, data, XChars.put(e, data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, double ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (XChars.maxCharCount_double() + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        double[] dArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            size = XChars.put(sepChars, data, XChars.put(e, data, size));
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString list(String separator, char ... listElements) {
        if (listElements == null || listElements.length == 0) {
            return this;
        }
        this.ensureFreeCapacity(listElements.length * (1 + separator.length()));
        char[] sepChars = XChars.readChars(separator);
        char[] data = this.data;
        int size = this.size;
        char[] cArray = listElements;
        int n = listElements.length;
        int n2 = 0;
        while (n2 < n) {
            char e;
            data[size] = e = cArray[n2];
            size = XChars.put(sepChars, data, size + 1);
            ++n2;
        }
        this.size = size;
        return this.deleteLast(sepChars.length);
    }

    public final VarString clear() {
        char[] data = this.data;
        int length = data.length;
        int i = 0;
        while (i < length) {
            data[i] = '\u0000';
            ++i;
        }
        this.size = 0;
        return this;
    }

    public final VarString reset() {
        this.size = 0;
        return this;
    }

    public final VarString blank() {
        this.internalAdd(' ');
        return this;
    }

    public final VarString blank(int amount) {
        return this.repeat(amount, ' ');
    }

    public final VarString tab() {
        this.internalAdd('\t');
        return this;
    }

    public final VarString tab(int amount) {
        return this.repeat(amount, '\t');
    }

    public final VarString cr() {
        this.internalAdd('\r');
        return this;
    }

    public final VarString cr(int amount) {
        return this.repeat(amount, '\r');
    }

    public final VarString lf() {
        this.internalAdd('\n');
        return this;
    }

    public final VarString lf(int amount) {
        return this.repeat(amount, '\n');
    }

    public final VarString crlf() {
        this.ensureFreeCapacity(2);
        this.data[this.size] = 13;
        this.data[this.size + 1] = 10;
        this.size += 2;
        return this;
    }

    public final VarString repeat(int amount, char c) {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Negative amount is invalid.");
            }
            return this;
        }
        this.ensureFreeCapacity(amount);
        XChars.uncheckedRepeat(this.data, this.size, amount, c);
        this.size += amount;
        return this;
    }

    public final VarString repeat(int amount, String string) {
        this.repeat(amount, XChars.readChars(string));
        return this;
    }

    public final VarString repeat(int amount, char[] chars) {
        if (amount <= 0) {
            if (amount < 0) {
                throw new IllegalArgumentException("Negative amount is invalid.");
            }
            return this;
        }
        this.ensureFreeCapacity(amount * chars.length);
        XChars.uncheckedRepeat(this.data, this.size, amount, chars);
        this.size += amount * chars.length;
        return this;
    }

    public final VarString apply(Consumer<? super VarString> procedure) {
        procedure.accept(this);
        return this;
    }

    public final boolean equalsAt(int index, char[] chars, int charsOffset, int charsLength) {
        if (charsLength == 0 && index <= this.size) {
            return true;
        }
        this.validateRange(index, charsLength);
        XChars.validateRange(chars, charsOffset, charsLength);
        return XChars.uncheckedEquals(this.data, index, chars, charsOffset, charsLength);
    }

    public final boolean endsWith(char c) {
        this.validateIndex(0);
        return this.data[this.size - 1] == c;
    }

    public final boolean endsWith(char[] chars) {
        return this.size >= chars.length && this.equalsAt(this.size - chars.length, chars, 0, chars.length);
    }

    public final boolean endsWith(String string) {
        return this.endsWith(XChars.readChars(string));
    }

    private static int calculatePaddingCount(String s, int totalLength) {
        return Math.max(totalLength - s.length(), 0);
    }

    public final VarString padLeft(String s, int totalLength, char paddingChar) {
        return this.repeat(VarString.calculatePaddingCount(s, totalLength), paddingChar).add(s);
    }

    public final VarString padRight(String s, int totalLength, char paddingChar) {
        return this.add(s).repeat(VarString.calculatePaddingCount(s, totalLength), paddingChar);
    }

    public final VarString replaceFirst(char sample, char replacement) {
        XChars.uncheckedReplaceFirst(this.data, 0, this.size, sample, replacement);
        return this;
    }

    public final VarString replaceFirst(char sample, char replacement, int offset) {
        this.validateIndex(offset);
        XChars.uncheckedReplaceFirst(this.data, offset, this.size - offset, sample, replacement);
        return this;
    }

    public final VarString replaceFirst(char sample, char replacement, int offset, int length) {
        this.validateRange(offset, length);
        XChars.uncheckedReplaceFirst(this.data, offset, length, sample, replacement);
        return this;
    }

    public final VarString replaceAll(char sample, char replacement) {
        XChars.uncheckedReplaceAll(this.data, 0, this.size, sample, replacement);
        return this;
    }

    public final VarString replaceAll(char sample, char replacement, int offset) {
        this.validateIndex(offset);
        XChars.uncheckedReplaceAll(this.data, offset, this.size - offset, sample, replacement);
        return this;
    }

    public final VarString replaceAll(char sample, char replacement, int offset, int length) {
        this.validateRange(offset, length);
        XChars.uncheckedReplaceAll(this.data, offset, length, sample, replacement);
        return this;
    }

    public String replaceFirst(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceFirst(replacement);
    }

    public final String replaceAll(String regex, String replacement) {
        return Pattern.compile(regex).matcher(this).replaceAll(replacement);
    }

    public final String replace(CharSequence target, CharSequence replacement) {
        return Pattern.compile(target.toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(replacement.toString()));
    }

    public final String[] split(String regex, int limit) {
        return Pattern.compile(regex).split(this, limit);
    }

    public final String[] split(String regex) {
        return this.split(regex, 0);
    }

    public final byte[] encode() {
        return this.encodeBy(XChars.standardCharset());
    }

    public final byte[] encodeBy(Charset charset) {
        return this.toString().getBytes(charset);
    }

    @Override
    public final char charAt(int index) {
        this.validateIndex(index);
        return this.data[index];
    }

    @Override
    public final int length() {
        return this.size;
    }

    @Override
    public final VarString subSequence(int start, int end) {
        VarString subSequence = VarString.New(end - start);
        System.arraycopy(this.data, start, subSequence.data, 0, end - start);
        return subSequence;
    }

    @Override
    public final VarString append(CharSequence csq) {
        if (csq == null) {
            this.internalAddNull();
            return this;
        }
        return this.add(csq.toString());
    }

    @Override
    public final VarString append(char c) {
        return this.add(c);
    }

    @Override
    public final VarString append(CharSequence csq, int start, int end) {
        if (csq == null) {
            this.internalAddNull();
            return this;
        }
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public final String toString() {
        return new String(this.data, 0, this.size);
    }

    public static interface Appendable {
        public VarString appendTo(VarString var1);
    }
}

