/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.function.Consumer;
import one.microstream.collections.BulkList;
import one.microstream.collections.interfaces.OptimizableCollection;
import one.microstream.collections.types.XList;
import one.microstream.equality.IdentityEqualityLogic;
import one.microstream.functional._longProcedure;
import one.microstream.math.XMath;
import one.microstream.typing.Composition;
import one.microstream.typing.KeyValue;

public final class HashMapObjectId<T>
implements OptimizableCollection,
Composition,
IdentityEqualityLogic {
    private Entry<T>[] hashSlots;
    private int hashRange;
    private int size;

    private static <T> Entry<T>[] newHashSlots(int length) {
        return new Entry[length];
    }

    public static final <T> HashMapObjectId<T> New() {
        return new HashMapObjectId<T>(1);
    }

    public static final <T> HashMapObjectId<T> New(int initialSlotLength) {
        return new HashMapObjectId<T>(XMath.pow2BoundCapped(initialSlotLength));
    }

    HashMapObjectId(int initialSlotLength) {
        this.hashSlots = HashMapObjectId.newHashSlots(initialSlotLength);
        this.hashRange = initialSlotLength - 1;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private void rebuild(int newCapacity) {
        Entry[] newSlots = new Entry[newCapacity];
        int newSlotCountMinusOne = newCapacity - 1;
        Entry<T>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry = entryArray[n2];
            while (entry != null) {
                Entry next = entry.next;
                int index = System.identityHashCode(entry.ref) & newSlotCountMinusOne;
                entry.next = newSlots[index];
                newSlots[index] = entry;
                entry = next;
            }
            ++n2;
        }
        this.hashSlots = newSlots;
        this.hashRange = newSlotCountMinusOne;
    }

    public boolean add(T object, long id) {
        int index = System.identityHashCode(object) & this.hashRange;
        Entry<T> head = this.hashSlots[index];
        if (head == null) {
            this.hashSlots[index] = new Entry<T>(id, object);
            if (this.size++ >= this.hashRange) {
                this.rebuild(this.hashRange + 1 << 1);
            }
            return true;
        }
        if (head.ref == object) {
            return false;
        }
        Entry entry = head.next;
        while (entry != null) {
            if (entry.ref == object) {
                return false;
            }
            entry = entry.next;
        }
        this.hashSlots[index] = new Entry<T>(id, object, head);
        if (this.size++ >= this.hashRange) {
            this.rebuild(this.hashRange + 1 << 1);
        }
        return true;
    }

    public boolean put(T object, long id) {
        int index = System.identityHashCode(object) & this.hashRange;
        Entry<T> head = this.hashSlots[index];
        if (head == null) {
            this.hashSlots[index] = new Entry<T>(id, object);
            if (this.size++ >= this.hashRange) {
                this.rebuild(this.hashRange + 1 << 1);
            }
            return true;
        }
        if (head.ref == object) {
            head.id = id;
            return false;
        }
        Entry entry = head.next;
        while (entry != null) {
            if (entry.ref == object) {
                entry.id = id;
                return false;
            }
            entry = entry.next;
        }
        this.hashSlots[index] = new Entry<T>(id, object, head);
        if (this.size++ >= this.hashRange) {
            this.rebuild(this.hashRange + 1 << 1);
        }
        return true;
    }

    public long putGet(T object, long id, long noOldIdValue) {
        int index = System.identityHashCode(object) & this.hashRange;
        Entry<T> head = this.hashSlots[index];
        if (head == null) {
            this.hashSlots[index] = new Entry<T>(id, object);
            if (this.size++ >= this.hashRange) {
                this.rebuild(this.hashRange + 1 << 1);
            }
            return noOldIdValue;
        }
        if (head.ref == object) {
            long oldId = head.id;
            head.id = id;
            return oldId;
        }
        Entry entry = head.next;
        while (entry != null) {
            if (entry.ref == object) {
                long oldId = entry.id;
                entry.id = id;
                return oldId;
            }
            entry = entry.next;
        }
        this.hashSlots[index] = new Entry<T>(id, object, head);
        if (this.size++ >= this.hashRange) {
            this.rebuild(this.hashRange + 1 << 1);
        }
        return noOldIdValue;
    }

    public long get(T object, long notFoundId) {
        if (object == null) {
            throw new NullPointerException();
        }
        Entry<T> entry = this.hashSlots[System.identityHashCode(object) & this.hashRange];
        while (entry != null) {
            if (entry.ref == object) {
                return entry.id;
            }
            entry = entry.next;
        }
        return notFoundId;
    }

    public XList<T> getObjects() {
        BulkList list = new BulkList(this.size);
        Entry<T>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry = entryArray[n2];
            while (entry != null) {
                list.add(entry.ref);
                entry = entry.next;
            }
            ++n2;
        }
        return list;
    }

    public XList<Long> getIds() {
        BulkList<Long> list = new BulkList<Long>(this.size);
        Entry<T>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry = entryArray[n2];
            while (entry != null) {
                list.add(entry.id);
                entry = entry.next;
            }
            ++n2;
        }
        return list;
    }

    public int iterateObjects(Consumer<? super T> procedure) {
        Entry<T>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.ref);
                entry = entry.next;
            }
            ++n2;
        }
        return this.size;
    }

    @Override
    public long optimize() {
        int newCapacity = XMath.pow2BoundCapped(this.size);
        if (newCapacity != this.hashSlots.length) {
            this.rebuild(newCapacity);
        }
        return this.size;
    }

    public int iterateIds(Consumer<? super Long> procedure) {
        Entry<T>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept((Long)entry.id);
                entry = entry.next;
            }
            ++n2;
        }
        return this.size;
    }

    public int iterateIds(_longProcedure procedure) {
        Entry<T>[] entryArray = this.hashSlots;
        int n = this.hashSlots.length;
        int n2 = 0;
        while (n2 < n) {
            Entry<T> entry = entryArray[n2];
            while (entry != null) {
                procedure.accept(entry.id);
                entry = entry.next;
            }
            ++n2;
        }
        return this.size;
    }

    public void clear() {
        Entry<T>[] slots = this.hashSlots;
        int i = 0;
        int len = slots.length;
        while (i < len) {
            slots[i] = null;
            ++i;
        }
        this.size = 0;
    }

    static final class Entry<T>
    implements KeyValue<T, Long>,
    Composition {
        long id;
        final T ref;
        Entry<T> next;

        Entry(long id, T object, Entry<T> next) {
            this.id = id;
            this.ref = object;
            this.next = next;
        }

        Entry(long id, T object) {
            this.id = id;
            this.ref = object;
            this.next = null;
        }

        @Override
        public T key() {
            return this.ref;
        }

        @Override
        public Long value() {
            return this.id;
        }
    }
}

