/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.View;
import one.microstream.collections.old.BridgeXCollection;
import one.microstream.collections.types.XCollection;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XImmutableCollection;
import one.microstream.concurrency.Synchronized;
import one.microstream.equality.Equalator;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.SynchronizedIterator;

public final class LockedCollection<E>
implements XCollection<E>,
Synchronized {
    private final XCollection<E> subject;
    private final Object lock;

    public LockedCollection(XCollection<E> collection) {
        this.subject = collection;
        this.lock = collection;
    }

    public LockedCollection(XCollection<E> collection, Object lock) {
        this.subject = collection;
        this.lock = lock;
    }

    @Override
    public final E get() {
        return this.subject.get();
    }

    @Override
    public final Equalator<? super E> equality() {
        return this.subject.equality();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedCollection<E> addAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll((Object[])elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullAdd() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullAdd();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean add(E e) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> addAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll((Object[])elements, offset, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> addAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.addAll((XGettingCollection)elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullPut() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullPut();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void accept(E e) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.accept(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean put(E e) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.put(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SafeVarargs
    public final LockedCollection<E> putAll(E ... elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.putAll((Object[])elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> putAll(E[] elements, int offset, int length) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.putAll((Object[])elements, offset, length);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> putAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.putAll((XGettingCollection)elements);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsSearched(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.containsSearched(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean applies(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.applies(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.subject.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long consolidate() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.consolidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean contains(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.contains(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsAll(XGettingCollection<? extends E> elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.containsAll(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean containsId(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.containsId(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.filterTo(target, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C copyTo(C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.copyTo(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long count(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.count(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long countBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.countBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.distinct(target, equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C distinct(C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.distinct(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> ensureFreeCapacity(long minimalFreeCapacity) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.ensureFreeCapacity(minimalFreeCapacity);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> ensureCapacity(long minimalCapacity) {
        Object object = this.lock;
        synchronized (object) {
            this.subject.ensureCapacity(minimalCapacity);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final boolean equals(Object o) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.equals(o);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.equals(this.subject, equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.equalsContent(this.subject, equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.except(other, equalator, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.iterate(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.join(joiner, aggregate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public final int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasVolatileElements() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.hasVolatileElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.intersect(other, equalator, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return new SynchronizedIterator(this.subject.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E max(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E min(Comparator<? super E> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.moveTo(target, predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.process(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E fetch() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.fetch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E pinch() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.pinch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E retrieve(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.retrieve(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E retrieveBy(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.retrieveBy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeOne(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeOne(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long remove(E element) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeAll(XGettingCollection<? extends E> samples) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeAll(this.subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeDuplicates(Equalator<? super E> equalator) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeDuplicates(equalator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long removeDuplicates() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.removeDuplicates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long retainAll(XGettingCollection<? extends E> samples) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.retainAll(this.subject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E seek(E sample) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.seek(sample);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E search(Predicate<? super E> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.search(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long optimize() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.optimize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size() {
        Object object = this.lock;
        synchronized (object) {
            return XTypes.to_int(this.subject.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final E[] toArray(Class<E> type) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.toArray(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void truncate() {
        Object object = this.lock;
        synchronized (object) {
            this.subject.truncate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.union(other, equalator, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long currentCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.currentCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long maximumCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.maximumCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isFull() {
        Object object = this.lock;
        synchronized (object) {
            return (long)XTypes.to_int(this.subject.size()) >= this.subject.maximumCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long remainingCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.remainingCapacity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullAllowed() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullAllowed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean nullContained() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullContained();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long nullRemove() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.nullRemove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LockedCollection<E> copy() {
        Object object = this.lock;
        synchronized (object) {
            return new LockedCollection<E>(this.subject.copy(), new Object());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final XImmutableCollection<E> immure() {
        Object object = this.lock;
        synchronized (object) {
            return this.subject.immure();
        }
    }

    @Override
    public final View<E> view() {
        return new View(this);
    }

    @Override
    public final OldMutexCollection<E> old() {
        return new OldMutexCollection(this);
    }

    public static final class OldMutexCollection<E>
    extends BridgeXCollection<E> {
        OldMutexCollection(LockedCollection<E> set) {
            super(set);
        }

        @Override
        public final LockedCollection<E> parent() {
            return (LockedCollection)super.parent();
        }
    }
}

