/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.X;
import one.microstream.collections.IndexExceededException;
import one.microstream.collections.old.OldList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XList;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;

public class MappedList<E, S>
implements XGettingList<E> {
    final XGettingList<S> subject;
    final Function<S, E> mapper;
    final Equalator<? super E> equality;

    public MappedList(XGettingList<S> subject, Function<S, E> mapper, Equalator<? super E> equality) {
        this.subject = X.notNull(subject);
        this.mapper = X.notNull(mapper);
        this.equality = X.notNull(equality);
    }

    public MappedList(XList<S> subject, Function<S, E> mapper) {
        this(subject, mapper, Equalator.identity());
    }

    private Comparator<S> mapComparator(final Comparator<? super E> comparator) {
        return new Comparator<S>(){

            @Override
            public int compare(S o1, S o2) {
                return comparator.compare(MappedList.this.mapper.apply(o1), MappedList.this.mapper.apply(o2));
            }
        };
    }

    private Predicate<S> mapPredicate(final Predicate<? super E> predicate) {
        return new Predicate<S>(){

            @Override
            public boolean test(S e) {
                return predicate.test(MappedList.this.mapper.apply(e));
            }
        };
    }

    private Predicate<S> mapIsEqual(final E element) {
        return new Predicate<S>(){

            @Override
            public boolean test(S e) {
                return MappedList.this.equality.equal(element, MappedList.this.mapper.apply(e));
            }
        };
    }

    @Override
    public E at(long index) {
        return this.mapper.apply(this.subject.at(index));
    }

    @Override
    public E get() {
        return this.mapper.apply(this.subject.get());
    }

    @Override
    public E first() {
        return this.mapper.apply(this.subject.first());
    }

    @Override
    public E last() {
        return this.mapper.apply(this.subject.last());
    }

    @Override
    public E poll() {
        return this.mapper.apply(this.subject.poll());
    }

    @Override
    public E peek() {
        return this.mapper.apply(this.subject.peek());
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return this.subject.maxIndex(this.mapComparator(comparator));
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return this.subject.minIndex(this.mapComparator(comparator));
    }

    @Override
    public long indexOf(E element) {
        return this.subject.indexBy(this.mapIsEqual(element));
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return this.subject.indexBy(this.mapPredicate(predicate));
    }

    @Override
    public long lastIndexOf(E element) {
        return this.subject.lastIndexBy(this.mapIsEqual(element));
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return this.subject.lastIndexBy(this.mapPredicate(predicate));
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return this.subject.scan(this.mapPredicate(predicate));
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return this.subject.isSorted(this.mapComparator(comparator));
    }

    @Override
    public <T extends Consumer<? super E>> T copySelection(T target, long ... indices) {
        int length = indices.length;
        int size = XTypes.to_int(this.subject.size());
        int i = 0;
        while (i < length) {
            if (indices[i] < 0L || indices[i] >= (long)size) {
                throw new IndexExceededException(size, indices[i]);
            }
            ++i;
        }
        XGettingList<S> subject = this.subject;
        Function<S, E> mapper = this.mapper;
        int i2 = 0;
        while (i2 < length) {
            target.accept(mapper.apply(subject.at(indices[i2])));
            ++i2;
        }
        return (T)target;
    }

    @Override
    public Iterator<E> iterator() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public Equalator<? super E> equality() {
        throw new NotImplementedYetError();
    }

    @Override
    public E[] toArray(Class<E> type) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public boolean containsId(final E element) {
        return this.subject.containsSearched(new Predicate<S>(){

            @Override
            public boolean test(S e) {
                return MappedList.this.mapper.apply(e) == element;
            }
        });
    }

    @Override
    public boolean contains(E element) {
        return this.subject.containsSearched(this.mapIsEqual(element));
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(this.mapPredicate(predicate));
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(this.mapPredicate(predicate));
    }

    @Override
    public long count(E element) {
        return this.subject.countBy(this.mapIsEqual(element));
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(this.mapPredicate(predicate));
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public E seek(E sample) {
        throw new NotImplementedYetError();
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T distinct(T target, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T copyTo(T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T filterTo(T target, Predicate<? super E> predicate) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public <T extends Consumer<? super E>> T except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, T target) {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean nullAllowed() {
        throw new NotImplementedYetError();
    }

    @Override
    public long maximumCapacity() {
        throw new NotImplementedYetError();
    }

    @Override
    public long remainingCapacity() {
        throw new NotImplementedYetError();
    }

    @Override
    public boolean isFull() {
        throw new NotImplementedYetError();
    }

    @Override
    public XImmutableList<E> immure() {
        throw new NotImplementedYetError();
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new NotImplementedYetError();
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        throw new NotImplementedYetError();
    }

    @Override
    public OldList<E> old() {
        throw new NotImplementedYetError();
    }

    @Override
    public XGettingList<E> copy() {
        throw new NotImplementedYetError();
    }

    @Override
    public XGettingList<E> toReversed() {
        throw new NotImplementedYetError();
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        throw new NotImplementedYetError();
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        throw new NotImplementedYetError();
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        throw new NotImplementedYetError();
    }

    @Override
    public XGettingList<E> view() {
        throw new NotImplementedYetError();
    }

    @Override
    public XGettingList<E> view(long lowIndex, long highIndex) {
        throw new NotImplementedYetError();
    }

    @Override
    public XGettingList<E> range(long fromIndex, long toIndex) {
        throw new NotImplementedYetError();
    }
}

