/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.collections.AbstractExtendedCollection;
import one.microstream.collections.ConstList;
import one.microstream.collections.SubList;
import one.microstream.collections.XUtilsCollection;
import one.microstream.collections.old.AbstractOldGettingList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingList;
import one.microstream.collections.types.XImmutableList;
import one.microstream.equality.Equalator;
import one.microstream.exceptions.IndexBoundsException;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.meta.NotImplementedYetError;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.ReadOnlyListIterator;

public class SubListView<E>
implements XGettingList<E> {
    final XGettingList<E> list;
    long startIndex;
    long size;
    long length;
    int d;

    static final <E> IndexedAcceptor<E> offset(final IndexedAcceptor<? super E> procedure, final long startIndex, final int d) {
        return new IndexedAcceptor<E>(){

            @Override
            public void accept(E e, long index) {
                procedure.accept(e, (index - startIndex) * (long)d);
            }
        };
    }

    public SubListView(XGettingList<E> list, long fromIndex, long toIndex) {
        long length;
        long size;
        if (fromIndex <= toIndex) {
            length = size = toIndex - fromIndex + 1L;
            if (fromIndex < 0L || toIndex >= (long)XTypes.to_int(list.size())) {
                throw new IndexOutOfBoundsException(this.exceptionStringRange(fromIndex, size));
            }
        } else {
            size = fromIndex - toIndex + 1L;
            length = -size;
            if (toIndex < 0L || fromIndex >= (long)XTypes.to_int(list.size())) {
                throw new IndexOutOfBoundsException(this.exceptionStringRange(toIndex, size));
            }
        }
        this.list = list;
        this.startIndex = fromIndex;
        this.size = size;
        this.length = length;
        this.d = length < 0L ? -1 : 1;
    }

    String exceptionStringRange(long startIndex, long length) {
        return "Range [" + startIndex + ';' + (startIndex + length - 1L) + "] not in [0;" + (this.size - 1L) + "]";
    }

    String exceptionStringRange2(long startIndex, long endIndex) {
        return "Range [" + startIndex + ';' + endIndex + "] not in [0;" + (this.size - 1L) + "]";
    }

    void checkIndex(long index) {
        if (index < 0L || index >= this.size) {
            throw new IndexBoundsException(this.size, index);
        }
    }

    void checkVector(long startIndex, long length) {
        if (length >= 0L ? startIndex < 0L || startIndex + length > this.size : startIndex + length < -1L || startIndex >= this.size) {
            throw new IndexOutOfBoundsException(this.exceptionStringRange(startIndex, length));
        }
    }

    void checkRange(long startIndex, long endIndex) {
        if (startIndex < 0L || endIndex >= this.size) {
            throw new IndexOutOfBoundsException(this.exceptionStringRange2(startIndex, endIndex));
        }
    }

    @Override
    public Equalator<? super E> equality() {
        return this.list.equality();
    }

    @Override
    public boolean containsSearched(Predicate<? super E> predicate) {
        return XUtilsCollection.rngApplies(this.list, this.startIndex, this.length, predicate);
    }

    @Override
    public boolean applies(Predicate<? super E> predicate) {
        return XUtilsCollection.rngAppliesAll(this.list, this.startIndex, this.length, predicate);
    }

    @Override
    public boolean nullAllowed() {
        return this.list.nullAllowed();
    }

    @Override
    public boolean nullContained() {
        return XUtilsCollection.rngContainsNull(this.list, this.startIndex, this.length);
    }

    @Override
    public long countBy(Predicate<? super E> predicate) {
        return XUtilsCollection.rngCount(this.list, this.startIndex, this.length, predicate);
    }

    @Override
    public boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        if (samples == null || (long)XTypes.to_int(samples.size()) != this.size || !(samples instanceof SubList)) {
            return false;
        }
        if (samples == this) {
            return true;
        }
        return XUtilsCollection.rngEqualsContent(this.list, this.startIndex, this.length, (SubList)samples, equalator);
    }

    @Override
    public <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return XUtilsCollection.rngExcept(this.list, this.startIndex, this.length, other, equalator, target);
    }

    @Override
    public boolean contains(E element) {
        return XUtilsCollection.rngContains(this.list, this.startIndex, this.length, element);
    }

    @Override
    public long count(E element) {
        return XUtilsCollection.rngCount(this.list, this.startIndex, this.length, element);
    }

    @Override
    public <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return XUtilsCollection.rngIntersect(this.list, this.startIndex, this.length, other, equalator, target);
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public E max(Comparator<? super E> comparator) {
        return XUtilsCollection.rngMax(this.list, this.startIndex, this.length, comparator);
    }

    @Override
    public E min(Comparator<? super E> comparator) {
        return XUtilsCollection.rngMin(this.list, this.startIndex, this.length, comparator);
    }

    @Override
    public SubListView<E> copy() {
        return new SubListView<E>(this.list, this.startIndex, this.getEndIndex());
    }

    protected long[] shiftIndices(long[] indices) {
        long startIndex = this.startIndex;
        int len = indices.length;
        long[] shifted = new long[len];
        long min = Long.MAX_VALUE;
        long max = 0L;
        int i = 0;
        while (i < len) {
            long idx = indices[i];
            if (idx < min) {
                min = idx;
            }
            if (idx > max) {
                max = idx;
            }
            shifted[i] = idx + startIndex;
            ++i;
        }
        this.checkRange(min, max);
        return shifted;
    }

    public long getEndIndex() {
        return this.startIndex + this.length - (long)this.d;
    }

    @Override
    public <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return this.list.copySelection(target, this.shiftIndices(indices));
    }

    @Override
    public E at(long index) {
        this.checkIndex(index);
        return this.list.at(this.startIndex + index - (long)this.d);
    }

    @Override
    public E get() {
        return this.list.at(this.startIndex);
    }

    @Override
    public E first() {
        return this.list.at(this.startIndex);
    }

    @Override
    public E last() {
        return this.list.at(this.getEndIndex());
    }

    @Override
    public E poll() {
        return this.size == 0L ? null : (E)this.list.at(this.startIndex);
    }

    @Override
    public E peek() {
        return this.size == 0L ? null : (E)this.list.at(this.getEndIndex());
    }

    @Override
    public long indexOf(E element) {
        return XUtilsCollection.rngIndexOF(this.list, this.startIndex, this.length, element);
    }

    @Override
    public long indexBy(Predicate<? super E> predicate) {
        return XUtilsCollection.rngIndexOf(this.list, this.startIndex, this.length, predicate);
    }

    @Override
    public boolean isSorted(Comparator<? super E> comparator) {
        return XUtilsCollection.rngIsSorted(this.list, this.startIndex, this.length, comparator);
    }

    @Override
    public long lastIndexOf(E element) {
        return XUtilsCollection.rngIndexOF(this.list, this.getEndIndex(), -this.length, element);
    }

    @Override
    public long lastIndexBy(Predicate<? super E> predicate) {
        return XUtilsCollection.rngIndexOf(this.list, this.getEndIndex(), -this.length, predicate);
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ReadOnlyListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(long index) {
        AbstractExtendedCollection.validateIndex(this.list.size(), index);
        return new ReadOnlyListIterator(this, (int)index);
    }

    @Override
    public long maxIndex(Comparator<? super E> comparator) {
        return XUtilsCollection.rngMaxIndex(this.list, this.startIndex, this.length, comparator);
    }

    @Override
    public long minIndex(Comparator<? super E> comparator) {
        return XUtilsCollection.rngMinIndex(this.list, this.startIndex, this.length, comparator);
    }

    @Override
    public long scan(Predicate<? super E> predicate) {
        return XUtilsCollection.rngScan(this.list, this.startIndex, this.length, predicate);
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public long maximumCapacity() {
        return this.list.maximumCapacity() - (long)XTypes.to_int(this.list.size()) + this.size;
    }

    @Override
    public boolean isFull() {
        return this.list.isFull();
    }

    @Override
    public long remainingCapacity() {
        return this.list.remainingCapacity();
    }

    @Override
    public SubListView<E> view() {
        return this;
    }

    @Override
    public SubListView<E> view(long lowIndex, long highIndex) {
        this.checkRange(lowIndex, highIndex);
        return new SubListView<E>(this.list, this.startIndex + lowIndex * (long)this.d, this.startIndex + highIndex * (long)this.d);
    }

    @Override
    public SubListView<E> range(long lowIndex, long highIndex) {
        this.checkRange(lowIndex, highIndex);
        return new SubListView<E>(this.list, this.startIndex + lowIndex * (long)this.d, this.startIndex + highIndex * (long)this.d);
    }

    @Override
    public Object[] toArray() {
        throw new NotImplementedYetError();
    }

    @Override
    public XImmutableList<E> immure() {
        return ConstList.New(this);
    }

    @Override
    public SubListView<E> toReversed() {
        return new SubListView<E>(this.list, this.getEndIndex(), this.startIndex);
    }

    @Override
    public boolean containsAll(XGettingCollection<? extends E> elements) {
        return XUtilsCollection.rngContainsAll(this.list, this.startIndex, this.length, elements);
    }

    @Override
    public boolean containsId(E element) {
        return XUtilsCollection.rngContainsId(this.list, this.startIndex, this.length, element);
    }

    @Override
    public <C extends Consumer<? super E>> C copyTo(C target) {
        return XUtilsCollection.rngCopyTo(this.list, this.startIndex, this.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return XUtilsCollection.rngCopyTo(this.list, this.startIndex, this.length, target, predicate);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target) {
        return XUtilsCollection.rngDistinct(this.list, this.startIndex, this.length, target);
    }

    @Override
    public <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return XUtilsCollection.rngDistinct(this.list, this.startIndex, this.length, target, equalator);
    }

    @Override
    public boolean hasVolatileElements() {
        return this.list.hasVolatileElements();
    }

    @Override
    public E seek(E sample) {
        return XUtilsCollection.rngGet(this.list, this.startIndex, this.length, sample, this.list.equality());
    }

    @Override
    public E search(Predicate<? super E> predicate) {
        return XUtilsCollection.rngSearch(this.list, this.startIndex, this.length, predicate);
    }

    @Override
    public E[] toArray(Class<E> type) {
        throw new NotImplementedYetError();
    }

    @Override
    public <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return XUtilsCollection.rngUnion(this.list, this.startIndex, this.length, other, equalator, target);
    }

    @Override
    public final <P extends Consumer<? super E>> P iterate(P procedure) {
        XUtilsCollection.rngIterate(this.list, this.startIndex, this.length, procedure);
        return procedure;
    }

    @Override
    public final <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        XUtilsCollection.rngIterate(this.list, this.startIndex, this.length, SubListView.offset(procedure, this.startIndex, this.d));
        return procedure;
    }

    @Override
    public final <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        XUtilsCollection.rngJoin(this.list, this.startIndex, this.length, joiner, aggregate);
        return aggregate;
    }

    @Override
    public boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        throw new NotImplementedYetError();
    }

    @Override
    public OldSubListView<E> old() {
        return new OldSubListView(this);
    }

    static class OldSubListView<E>
    extends AbstractOldGettingList<E> {
        OldSubListView(SubListView<E> list) {
            super(list);
        }

        @Override
        public SubListView<E> parent() {
            return (SubListView)super.parent();
        }
    }
}

