/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import one.microstream.collections.ListView;
import one.microstream.collections.SubListView;
import one.microstream.collections.old.AbstractBridgeXList;
import one.microstream.collections.types.XGettingCollection;
import one.microstream.collections.types.XGettingSequence;
import one.microstream.collections.types.XImmutableList;
import one.microstream.collections.types.XList;
import one.microstream.concurrency.Synchronized;
import one.microstream.equality.Equalator;
import one.microstream.functional.IndexedAcceptor;
import one.microstream.typing.XTypes;
import one.microstream.util.iterables.SynchronizedIterator;
import one.microstream.util.iterables.SynchronizedListIterator;

public final class SynchList<E>
implements XList<E>,
Synchronized {
    private final XList<E> subject;

    public SynchList(XList<E> list) {
        this.subject = list;
    }

    @Override
    public final synchronized Equalator<? super E> equality() {
        return this.subject.equality();
    }

    @Override
    public final synchronized void accept(E e) {
        this.subject.accept(e);
    }

    @Override
    @SafeVarargs
    public final synchronized SynchList<E> addAll(E ... elements) {
        this.subject.addAll((Object[])elements);
        return this;
    }

    @Override
    public final synchronized boolean add(E e) {
        return this.subject.add(e);
    }

    @Override
    public final synchronized SynchList<E> addAll(E[] elements, int offset, int length) {
        this.subject.addAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> addAll(XGettingCollection<? extends E> elements) {
        this.subject.addAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public final synchronized boolean nullAdd() {
        return this.subject.nullAdd();
    }

    @Override
    public final synchronized boolean put(E e) {
        return this.subject.put(e);
    }

    @Override
    @SafeVarargs
    public final synchronized SynchList<E> putAll(E ... elements) {
        this.subject.putAll((Object[])elements);
        return this;
    }

    @Override
    public final synchronized SynchList<E> putAll(XGettingCollection<? extends E> elements) {
        this.subject.putAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public final synchronized SynchList<E> putAll(E[] elements, int offset, int length) {
        this.subject.putAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public final synchronized boolean nullPut() {
        return this.subject.nullPut();
    }

    @Override
    public final synchronized boolean prepend(E element) {
        return this.subject.prepend(element);
    }

    @Override
    @SafeVarargs
    public final synchronized SynchList<E> prependAll(E ... elements) {
        this.subject.prependAll((Object[])elements);
        return this;
    }

    @Override
    public final synchronized SynchList<E> prependAll(E[] elements, int offset, int length) {
        this.subject.prependAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> prependAll(XGettingCollection<? extends E> elements) {
        this.subject.prependAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public final synchronized boolean nullPrepend() {
        return this.subject.nullPrepend();
    }

    @Override
    public final synchronized boolean preput(E element) {
        return this.subject.preput(element);
    }

    @Override
    @SafeVarargs
    public final synchronized SynchList<E> preputAll(E ... elements) {
        this.subject.preputAll((Object[])elements);
        return this;
    }

    @Override
    public final synchronized SynchList<E> preputAll(E[] elements, int offset, int length) {
        this.subject.preputAll((Object[])elements, offset, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> preputAll(XGettingCollection<? extends E> elements) {
        this.subject.preputAll((XGettingCollection)elements);
        return this;
    }

    @Override
    public final synchronized boolean nullPreput() {
        return this.subject.nullPreput();
    }

    @Override
    public final synchronized boolean insert(long index, E element) {
        return this.subject.insert(index, element);
    }

    @Override
    @SafeVarargs
    public final synchronized long insertAll(long index, E ... elements) {
        return this.subject.insertAll(index, elements);
    }

    @Override
    public final synchronized long insertAll(long index, E[] elements, int offset, int length) {
        return this.subject.insertAll(index, elements, offset, length);
    }

    @Override
    public final synchronized long insertAll(long index, XGettingCollection<? extends E> elements) {
        return this.subject.insertAll(index, elements);
    }

    @Override
    public final synchronized boolean nullInsert(long index) {
        return this.subject.nullInsert(index);
    }

    @Override
    public final synchronized boolean input(long index, E element) {
        return this.subject.input(index, element);
    }

    @Override
    @SafeVarargs
    public final synchronized long inputAll(long index, E ... elements) {
        return this.subject.inputAll(index, elements);
    }

    @Override
    public final synchronized long inputAll(long index, E[] elements, int offset, int length) {
        return this.subject.inputAll(index, elements, offset, length);
    }

    @Override
    public final synchronized long inputAll(long index, XGettingCollection<? extends E> elements) {
        return this.subject.inputAll(index, elements);
    }

    @Override
    public final synchronized boolean nullInput(long index) {
        return this.subject.nullInput(index);
    }

    @Override
    public final synchronized boolean containsSearched(Predicate<? super E> predicate) {
        return this.subject.containsSearched(predicate);
    }

    @Override
    public final synchronized boolean applies(Predicate<? super E> predicate) {
        return this.subject.applies(predicate);
    }

    @Override
    public final synchronized void clear() {
        this.subject.clear();
    }

    @Override
    public final synchronized long consolidate() {
        return this.subject.consolidate();
    }

    @Override
    public final synchronized boolean contains(E element) {
        return this.subject.contains(element);
    }

    @Override
    public final synchronized boolean containsAll(XGettingCollection<? extends E> elements) {
        return this.subject.containsAll(elements);
    }

    @Override
    public final synchronized boolean containsId(E element) {
        return this.subject.containsId(element);
    }

    @Override
    public final synchronized SynchList<E> copy() {
        return new SynchList<E>(this.subject);
    }

    @Override
    public final synchronized XImmutableList<E> immure() {
        return this.subject.immure();
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C copySelection(C target, long ... indices) {
        return this.subject.copySelection(target, indices);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C filterTo(C target, Predicate<? super E> predicate) {
        return this.subject.filterTo(target, predicate);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C copyTo(C target) {
        return this.subject.copyTo(target);
    }

    @Override
    public final synchronized long count(E element) {
        return this.subject.count(element);
    }

    @Override
    public final synchronized long countBy(Predicate<? super E> predicate) {
        return this.subject.countBy(predicate);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C distinct(C target, Equalator<? super E> equalator) {
        return this.subject.distinct(target, equalator);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C distinct(C target) {
        return this.subject.distinct(target);
    }

    @Override
    public final synchronized SynchList<E> ensureFreeCapacity(long minimalFreeCapacity) {
        this.subject.ensureFreeCapacity(minimalFreeCapacity);
        return this;
    }

    @Override
    public final synchronized SynchList<E> ensureCapacity(long minimalCapacity) {
        this.subject.ensureCapacity(minimalCapacity);
        return this;
    }

    @Override
    @Deprecated
    public final synchronized boolean equals(Object o) {
        return this.subject.equals(o);
    }

    @Override
    public final synchronized boolean equals(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equals(samples, equalator);
    }

    @Override
    public final synchronized boolean equalsContent(XGettingCollection<? extends E> samples, Equalator<? super E> equalator) {
        return this.subject.equalsContent(samples, equalator);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C except(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.except(other, equalator, target);
    }

    @Override
    public final synchronized <P extends Consumer<? super E>> P iterate(P procedure) {
        this.subject.iterate(procedure);
        return procedure;
    }

    @Override
    public final synchronized <P extends IndexedAcceptor<? super E>> P iterateIndexed(P procedure) {
        this.subject.iterateIndexed(procedure);
        return procedure;
    }

    @Override
    public final synchronized <A> A join(BiConsumer<? super E, ? super A> joiner, A aggregate) {
        return this.subject.join(joiner, aggregate);
    }

    @Override
    public final synchronized SynchList<E> fill(long offset, long length, E element) {
        this.subject.fill(offset, length, (Object)element);
        return this;
    }

    @Override
    public final synchronized E at(long index) {
        return this.subject.at(index);
    }

    @Override
    public final synchronized E get() {
        return this.subject.get();
    }

    @Override
    public final synchronized E first() {
        return this.subject.first();
    }

    @Override
    public final synchronized E last() {
        return this.subject.last();
    }

    @Override
    public final synchronized E poll() {
        return this.subject.poll();
    }

    @Override
    public final synchronized E peek() {
        return this.subject.peek();
    }

    @Override
    @Deprecated
    public final synchronized int hashCode() {
        return this.subject.hashCode();
    }

    @Override
    public final synchronized boolean hasVolatileElements() {
        return this.subject.hasVolatileElements();
    }

    @Override
    public final synchronized long indexOf(E element) {
        return this.subject.indexOf(element);
    }

    @Override
    public final synchronized long indexBy(Predicate<? super E> predicate) {
        return this.subject.indexBy(predicate);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C intersect(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.intersect(other, equalator, target);
    }

    @Override
    public final synchronized boolean isEmpty() {
        return this.subject.isEmpty();
    }

    @Override
    public final synchronized boolean isSorted(Comparator<? super E> comparator) {
        return this.subject.isSorted(comparator);
    }

    @Override
    public final synchronized Iterator<E> iterator() {
        return new SynchronizedIterator(this.subject.iterator());
    }

    @Override
    public final synchronized long lastIndexBy(Predicate<? super E> predicate) {
        return this.subject.lastIndexBy(predicate);
    }

    @Override
    public final synchronized long lastIndexOf(E element) {
        return this.subject.lastIndexOf(element);
    }

    @Override
    public final synchronized ListIterator<E> listIterator() {
        return new SynchronizedListIterator(this.subject.listIterator());
    }

    @Override
    public final synchronized ListIterator<E> listIterator(long index) {
        return new SynchronizedListIterator(this.subject.listIterator(index));
    }

    @Override
    public final synchronized E max(Comparator<? super E> comparator) {
        return this.subject.max(comparator);
    }

    @Override
    public final synchronized long maxIndex(Comparator<? super E> comparator) {
        return this.subject.maxIndex(comparator);
    }

    @Override
    public final synchronized E min(Comparator<? super E> comparator) {
        return this.subject.min(comparator);
    }

    @Override
    public final synchronized long minIndex(Comparator<? super E> comparator) {
        return this.subject.minIndex(comparator);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C moveSelection(C target, long ... indices) {
        return this.subject.moveSelection(target, indices);
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C moveTo(C target, Predicate<? super E> predicate) {
        return this.subject.moveTo(target, predicate);
    }

    @Override
    public final <P extends Consumer<? super E>> P process(P procedure) {
        return this.subject.process(procedure);
    }

    @Override
    public final synchronized long removeBy(Predicate<? super E> predicate) {
        return this.subject.removeBy(predicate);
    }

    @Override
    public final synchronized long remove(E element) {
        return this.subject.remove(element);
    }

    @Override
    public final synchronized E removeAt(long index) {
        return this.subject.removeAt(index);
    }

    @Override
    public final synchronized long removeAll(XGettingCollection<? extends E> elements) {
        return this.subject.removeAll(elements);
    }

    @Override
    public final synchronized long removeDuplicates(Equalator<? super E> equalator) {
        return this.subject.removeDuplicates(equalator);
    }

    @Override
    public final synchronized long removeDuplicates() {
        return this.subject.removeDuplicates();
    }

    @Override
    public final synchronized E fetch() {
        return this.subject.fetch();
    }

    @Override
    public final synchronized E pop() {
        return this.subject.pop();
    }

    @Override
    public final synchronized E pinch() {
        return this.subject.pinch();
    }

    @Override
    public final synchronized E pick() {
        return this.subject.pick();
    }

    @Override
    public final synchronized boolean removeOne(E element) {
        return this.subject.removeOne(element);
    }

    @Override
    public final synchronized E retrieve(E element) {
        return this.subject.retrieve(element);
    }

    @Override
    public final synchronized E retrieveBy(Predicate<? super E> predicate) {
        return this.subject.retrieveBy(predicate);
    }

    @Override
    public final synchronized SynchList<E> removeRange(long startIndex, long length) {
        this.subject.removeRange(startIndex, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> retainRange(long startIndex, long length) {
        this.subject.retainRange(startIndex, length);
        return this;
    }

    @Override
    public final synchronized long removeSelection(long[] indices) {
        return this.subject.removeSelection(indices);
    }

    @Override
    public final synchronized long replace(E element, E replacement) {
        return this.subject.replace(element, replacement);
    }

    @Override
    public final synchronized long replace(Predicate<? super E> predicate, E substitute) {
        return this.subject.replace(predicate, (E)substitute);
    }

    @Override
    public final synchronized long substitute(Function<? super E, ? extends E> mapper) {
        return this.subject.substitute(mapper);
    }

    @Override
    public final long substitute(Predicate<? super E> predicate, Function<E, E> mapper) {
        return this.subject.substitute(predicate, mapper);
    }

    @Override
    public final synchronized long replaceAll(XGettingCollection<? extends E> elements, E replacement) {
        return this.subject.replaceAll(elements, (E)replacement);
    }

    @Override
    public final synchronized boolean replaceOne(E element, E replacement) {
        return this.subject.replaceOne(element, replacement);
    }

    @Override
    public final synchronized boolean replaceOne(Predicate<? super E> predicate, E substitute) {
        return this.subject.replaceOne(predicate, (E)substitute);
    }

    @Override
    public final synchronized long retainAll(XGettingCollection<? extends E> elements) {
        return this.subject.retainAll(elements);
    }

    @Override
    public final synchronized SynchList<E> reverse() {
        this.subject.reverse();
        return this;
    }

    @Override
    public final synchronized long scan(Predicate<? super E> predicate) {
        return this.subject.scan(predicate);
    }

    @Override
    public final synchronized E seek(E sample) {
        return this.subject.seek(sample);
    }

    @Override
    public final synchronized E search(Predicate<? super E> predicate) {
        return this.subject.search(predicate);
    }

    @Override
    @SafeVarargs
    public final synchronized SynchList<E> setAll(long offset, E ... elements) {
        this.subject.setAll(offset, (Object[])elements);
        return this;
    }

    @Override
    public final synchronized boolean set(long index, E element) {
        return this.subject.set(index, element);
    }

    @Override
    public final synchronized E setGet(long index, E element) {
        return this.subject.setGet(index, element);
    }

    @Override
    public final synchronized SynchList<E> set(long offset, E[] src, int srcIndex, int srcLength) {
        this.subject.set(offset, (Object[])src, srcIndex, srcLength);
        return this;
    }

    @Override
    public final synchronized SynchList<E> set(long offset, XGettingSequence<? extends E> elements, long elementsOffset, long elementsLength) {
        this.subject.set(offset, (XGettingSequence)elements, elementsOffset, elementsLength);
        return this;
    }

    @Override
    public final synchronized void setFirst(E element) {
        this.subject.setFirst(element);
    }

    @Override
    public final synchronized void setLast(E element) {
        this.subject.setLast(element);
    }

    @Override
    public final synchronized long optimize() {
        return this.subject.optimize();
    }

    @Override
    public final synchronized long size() {
        return XTypes.to_int(this.subject.size());
    }

    @Override
    public final synchronized SynchList<E> sort(Comparator<? super E> comparator) {
        this.subject.sort(comparator);
        return this;
    }

    @Override
    public final synchronized XList<E> range(long fromIndex, long toIndex) {
        return new SynchList<E>(this.subject.range(fromIndex, toIndex));
    }

    @Override
    public final synchronized SynchList<E> shiftTo(long sourceIndex, long targetIndex) {
        this.subject.shiftTo(sourceIndex, targetIndex);
        return this;
    }

    @Override
    public final synchronized SynchList<E> shiftTo(long sourceIndex, long targetIndex, long length) {
        this.subject.shiftTo(sourceIndex, targetIndex, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> shiftBy(long sourceIndex, long distance) {
        this.subject.shiftTo(sourceIndex, distance);
        return this;
    }

    @Override
    public final synchronized SynchList<E> shiftBy(long sourceIndex, long distance, long length) {
        this.subject.shiftTo(sourceIndex, distance, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> swap(long indexA, long indexB, long length) {
        this.subject.swap(indexA, indexB, length);
        return this;
    }

    @Override
    public final synchronized SynchList<E> swap(long indexA, long indexB) {
        this.subject.swap(indexA, indexB);
        return this;
    }

    @Override
    public final synchronized Object[] toArray() {
        return this.subject.toArray();
    }

    @Override
    public final synchronized E[] toArray(Class<E> type) {
        return this.subject.toArray(type);
    }

    @Override
    public final synchronized SynchList<E> toReversed() {
        this.subject.toReversed();
        return this;
    }

    @Override
    public final synchronized void truncate() {
        this.subject.truncate();
    }

    @Override
    public final synchronized <C extends Consumer<? super E>> C union(XGettingCollection<? extends E> other, Equalator<? super E> equalator, C target) {
        return this.subject.union(other, equalator, target);
    }

    @Override
    public final synchronized long currentCapacity() {
        return this.subject.currentCapacity();
    }

    @Override
    public final synchronized long maximumCapacity() {
        return this.subject.maximumCapacity();
    }

    @Override
    public final synchronized boolean isFull() {
        return this.subject.isFull();
    }

    @Override
    public final synchronized long remainingCapacity() {
        return this.subject.remainingCapacity();
    }

    @Override
    public final synchronized boolean nullAllowed() {
        return this.subject.nullAllowed();
    }

    @Override
    public final synchronized boolean nullContained() {
        return this.subject.nullContained();
    }

    @Override
    public final synchronized long nullRemove() {
        return this.subject.nullRemove();
    }

    @Override
    public final synchronized ListView<E> view() {
        return new ListView(this);
    }

    @Override
    public final synchronized SubListView<E> view(long fromIndex, long toIndex) {
        return new SubListView(this, fromIndex, toIndex);
    }

    @Override
    public final OldSynchList<E> old() {
        return new OldSynchList(this);
    }

    public static final class OldSynchList<E>
    extends AbstractBridgeXList<E> {
        OldSynchList(SynchList<E> list) {
            super(list);
        }

        @Override
        public final SynchList<E> parent() {
            return (SynchList)super.parent();
        }
    }
}

