/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections.lazy;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.function.Predicate;
import one.microstream.branching.ThrowBreak;
import one.microstream.collections.AbstractExtendedCollection;
import one.microstream.collections.lazy.LazyList;
import one.microstream.collections.lazy.LazySegment;
import one.microstream.collections.lazy.LazySegmentUnloader;
import one.microstream.math.XMath;
import one.microstream.reference.ControlledLazyReference;
import one.microstream.reference.Lazy;
import one.microstream.reference.LazyClearController;

public final class LazyArrayList<E>
extends AbstractList<E>
implements LazyList<E>,
RandomAccess {
    private static final int MAX_SEGMENT_SIZE_DEFAULT = 1000;
    private final int maxSegmentSize;
    private final ArrayList<Segment> segments;
    private int size;
    private final LazySegmentUnloader unloader;

    public LazyArrayList() {
        this.maxSegmentSize = 1000;
        this.segments = new ArrayList();
        this.unloader = new LazySegmentUnloader.Default();
    }

    public LazyArrayList(int maxSegmentSize) {
        this.maxSegmentSize = XMath.positive(maxSegmentSize);
        this.segments = new ArrayList();
        this.unloader = new LazySegmentUnloader.Default();
    }

    public LazyArrayList(int maxSegmentSize, LazySegmentUnloader lazySegmentUnloader) {
        this.maxSegmentSize = XMath.positive(maxSegmentSize);
        this.segments = new ArrayList();
        this.unloader = lazySegmentUnloader;
    }

    public LazyArrayList(LazyArrayList<E> list) {
        this.maxSegmentSize = list.maxSegmentSize;
        this.segments = new ArrayList();
        this.unloader = list.unloader.copy();
        this.addAll(list);
    }

    public long getSegmentCount() {
        return this.segments.size();
    }

    public Iterable<? extends Segment> segments() {
        return this.segments;
    }

    public int getMaxSegmentSize() {
        return this.maxSegmentSize;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void tryUnload(boolean unloadAll) {
        this.unloader.unload(unloadAll);
    }

    @Override
    public boolean contains(Object element) {
        return this.indexOf(element) >= 0;
    }

    @Override
    public int indexOf(Object element) {
        return this.indexOfRange(element, 0, this.size);
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.lastIndexOfRange(element, 0, this.size);
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size];
        this.copySegmentsToArray(array);
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.size) {
            Object[] newArray = this.createNewArray(array.getClass(), this.size);
            this.copySegmentsToArray(newArray);
            return newArray;
        }
        this.copySegmentsToArray(array);
        if (array.length > this.size) {
            array[this.size] = null;
        }
        return array;
    }

    private <T> T[] createNewArray(Class<? extends T[]> newType, int newLength) {
        return newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
    }

    private void copySegmentsToArray(Object[] array) {
        for (Segment segment : this.segments) {
            Object[] segmentArray = ((ArrayList)segment.getData()).toArray();
            System.arraycopy(segmentArray, 0, array, segment.offset, segment.segmentSize);
            this.unloader.unload(segment);
        }
    }

    @Override
    public E get(int index) {
        AbstractExtendedCollection.validateIndex(this.size, index);
        Segment segment = this.segmentForIndex(index);
        return ((ArrayList)segment.getData()).get(index - segment.offset);
    }

    @Override
    public E set(int index, E element) {
        AbstractExtendedCollection.validateIndex(this.size, index);
        Segment segment = this.segmentForIndex(index);
        return segment.set(index - segment.offset, element);
    }

    @Override
    public boolean add(E element) {
        ++this.modCount;
        Segment segment = this.ensureSlots();
        segment.add(element);
        ++this.size;
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> elements) {
        int newElementsSize = elements.size();
        if (newElementsSize == 0) {
            return false;
        }
        ++this.modCount;
        Segment segment = null;
        for (E element : elements) {
            if (segment == null || segment.segmentSize >= this.maxSegmentSize) {
                segment = this.ensureSlots();
            }
            segment.add(element);
        }
        this.size += newElementsSize;
        this.updateOffsets();
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.add(element);
            return;
        }
        AbstractExtendedCollection.validateIndex(this.size + 1, index);
        ++this.modCount;
        Segment segment = this.segmentForIndex(index);
        if (segment.segmentSize < this.maxSegmentSize) {
            segment.add(index - segment.offset, element);
        } else {
            Segment next = this.segmentForIndex(index + 1);
            if (next == null || next.segmentSize >= this.maxSegmentSize) {
                int newSegmentIndex = this.segments.indexOf(segment) + 1;
                next = this.createSegment();
                this.segments.add(newSegmentIndex, next);
            }
            next.add(0, segment.remove(segment.segmentSize - 1));
            segment.add(index - segment.offset, element);
        }
        ++this.size;
        this.updateOffsets();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        if (index == this.size) {
            return this.addAll(elements);
        }
        AbstractExtendedCollection.validateIndex(this.size + 1, index);
        ++this.modCount;
        int newElementsSize = elements.size();
        if (newElementsSize == 0) {
            return false;
        }
        Segment segment = this.segmentForIndex(index);
        if (segment.segmentSize + newElementsSize <= this.maxSegmentSize) {
            segment.addAll(index - segment.offset, elements);
        } else if (index == 0) {
            this.addSegments(0, elements.iterator());
        } else {
            int indexInSegment = index - segment.offset;
            Object segmentData = segment.getData();
            ArrayList newElements = new ArrayList(elements.size() + segment.segmentSize);
            newElements.addAll(elements);
            newElements.addAll(((ArrayList)segmentData).subList(indexInSegment, segment.segmentSize));
            while (((ArrayList)segmentData).size() > indexInSegment) {
                segment.remove(segment.segmentSize - 1);
            }
            Iterator iterator = newElements.iterator();
            while (iterator.hasNext() && segment.segmentSize < this.maxSegmentSize) {
                segment.add(iterator.next());
            }
            this.addSegments(this.segments.indexOf(segment) + 1, iterator);
        }
        this.size += newElementsSize;
        this.updateOffsets();
        return true;
    }

    @Override
    public E remove(int index) {
        AbstractExtendedCollection.validateIndex(this.size, index);
        ++this.modCount;
        Segment segment = this.segmentForIndex(index);
        Object element = segment.remove(index - segment.offset);
        this.removeSegmentIfEmpty(segment);
        --this.size;
        this.updateOffsets();
        return element;
    }

    @Override
    public boolean remove(Object element) {
        Segment changedSegment = null;
        for (Segment segment : this.segments) {
            if (!segment.remove(element)) continue;
            ++this.modCount;
            changedSegment = segment;
            break;
        }
        if (changedSegment != null) {
            this.removeSegmentIfEmpty(changedSegment);
            --this.size;
            this.updateOffsets();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        return this.batchUpdate(segment -> segment.removeAll(elements));
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        return this.batchUpdate(segment -> segment.removeIf(filter));
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        return this.batchUpdate(segment -> segment.retainAll(elements));
    }

    @Override
    public boolean consolidate() {
        int segmentsSize = this.segments.size();
        if (segmentsSize <= 1) {
            return false;
        }
        int firstSegmentWithGaps = -1;
        int i = 0;
        while (i < segmentsSize - 1) {
            Segment segment = this.segments.get(i);
            if (segment.segmentSize < this.maxSegmentSize) {
                firstSegmentWithGaps = i;
                break;
            }
            ++i;
        }
        if (firstSegmentWithGaps < 0) {
            return false;
        }
        ++this.modCount;
        ArrayList<Segment> consolidatedSegments = new ArrayList<Segment>();
        if (firstSegmentWithGaps > 0) {
            consolidatedSegments.addAll(this.segments.subList(0, firstSegmentWithGaps));
        }
        Segment newSegment = null;
        int i2 = firstSegmentWithGaps;
        while (i2 < segmentsSize) {
            Iterator iterator = ((ArrayList)this.segments.get(i2).getData()).iterator();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (newSegment == null || newSegment.segmentSize >= this.maxSegmentSize) {
                    newSegment = this.createSegment();
                    consolidatedSegments.add(newSegment);
                }
                newSegment.add(element);
            }
            ++i2;
        }
        this.clear();
        this.segments.addAll(consolidatedSegments);
        consolidatedSegments.clear();
        this.updateOffsets();
        return true;
    }

    @Override
    public <P extends Consumer<Lazy<?>>> P iterateLazyReferences(P procedure) {
        try {
            for (Segment segment : this.segments) {
                procedure.accept(segment.data);
            }
        }
        catch (ThrowBreak throwBreak) {
            // empty catch block
        }
        return procedure;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (Segment segment : this.segments) {
            ArrayList data = (ArrayList)segment.data.peek();
            if (data != null) {
                data.clear();
            }
            this.unloader.remove(segment);
        }
        this.segments.clear();
        this.size = 0;
    }

    private boolean removeSegmentIfEmpty(Segment segment) {
        if (segment.segmentSize == 0) {
            this.segments.remove(segment);
            this.unloader.remove(segment);
            return true;
        }
        return false;
    }

    private <R> R iterateForward(int startInclusive, int endExclusive, IterationLogic<E, R> logic) {
        for (Segment segment : this.segments) {
            if (segment.offset >= endExclusive) break;
            if (!segment.intersectsRange(startInclusive, endExclusive)) continue;
            Object data = segment.getData();
            int segmentStartInclusive = Math.max(0, startInclusive - segment.offset);
            int segmentEndExclusive = Math.min(segment.segmentSize, endExclusive - segment.offset);
            int i = segmentStartInclusive;
            while (i < segmentEndExclusive) {
                R result = logic.apply(((ArrayList)data).get(i), i + segment.offset);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return null;
    }

    private <R> R iterateBackward(int startInclusive, int endExclusive, IterationLogic<E, R> logic) {
        int si = this.segments.size();
        while (--si >= 0) {
            Segment segment = this.segments.get(si);
            if (segment.offset + segment.segmentSize - 1 < startInclusive) break;
            if (!segment.intersectsRange(startInclusive, endExclusive)) continue;
            Object data = segment.getData();
            int segmentStartInclusive = Math.max(0, startInclusive - segment.offset);
            int segmentEndExclusive = Math.min(segment.segmentSize, endExclusive - segment.offset);
            int i = segmentEndExclusive - 1;
            while (i >= segmentStartInclusive) {
                R result = logic.apply(((ArrayList)data).get(i), i + segment.offset);
                if (result != null) {
                    return result;
                }
                --i;
            }
            this.unloader.unload(segment);
        }
        return null;
    }

    private int indexOfRange(Object element, int startInclusive, int endExclusive) {
        IterationLogic<Object, Integer> logic = element == null ? (e, index) -> e == null ? Integer.valueOf(index) : null : (e, index) -> e.equals(element) ? Integer.valueOf(index) : null;
        Integer index2 = this.iterateForward(startInclusive, endExclusive, logic);
        return index2 != null ? index2 : -1;
    }

    private int lastIndexOfRange(Object element, int startInclusive, int endExclusive) {
        IterationLogic<Object, Integer> logic = element == null ? (e, index) -> e == null ? Integer.valueOf(index) : null : (e, index) -> e.equals(element) ? Integer.valueOf(index) : null;
        Integer index2 = this.iterateBackward(startInclusive, endExclusive, logic);
        return index2 != null ? index2 : -1;
    }

    private Segment segmentForIndex(int index) {
        int firstGuess = index / this.maxSegmentSize;
        if (this.segments.size() > firstGuess) {
            Segment segment = this.segments.get(firstGuess);
            if (segment.containsIndex(index)) {
                return segment;
            }
            if (index >= segment.offset + segment.segmentSize) {
                return this.segmentForIndex(index, firstGuess + 1, this.segments.size());
            }
            if (index < segment.offset) {
                return this.segmentForIndex(index, 0, firstGuess - 1);
            }
        }
        throw new NoSuchElementException("Index " + index + "not found!");
    }

    private Segment segmentForIndex(int index, int lowSegmentIndex, int highSegmentIndex) {
        int hi = highSegmentIndex;
        int lo = lowSegmentIndex;
        while (lo <= hi) {
            int mid = lo + (hi - lo) / 2;
            Segment midSegment = this.segments.get(mid);
            if (index >= midSegment.offset + midSegment.segmentSize) {
                lo = mid + 1;
                continue;
            }
            if (index < midSegment.offset) {
                hi = mid - 1;
                continue;
            }
            return midSegment;
        }
        return null;
    }

    private Segment ensureSlots() {
        Segment segment;
        if (this.segments.isEmpty()) {
            segment = this.createSegment();
            this.segments.add(segment);
        } else {
            segment = this.segments.get(this.segments.size() - 1);
            if (segment.segmentSize >= this.maxSegmentSize) {
                segment = this.createSegment();
                segment.offset = this.size;
                this.segments.add(segment);
            }
        }
        return segment;
    }

    private void addSegments(int index, Iterator<? extends E> elements) {
        int newSegmentIndex = index;
        Segment newSegment = null;
        while (elements.hasNext()) {
            if (newSegment == null || newSegment.segmentSize >= this.maxSegmentSize) {
                newSegment = this.createSegment();
                this.segments.add(newSegmentIndex++, newSegment);
            }
            newSegment.add(elements.next());
        }
    }

    private boolean batchUpdate(Predicate<Segment> segmentOperation) {
        boolean changed = false;
        for (Segment segment2 : this.segments) {
            int oldSize = segment2.segmentSize;
            if (!segmentOperation.test(segment2)) continue;
            ++this.modCount;
            this.size -= oldSize - segment2.segmentSize;
            changed = true;
        }
        if (changed) {
            this.segments.removeIf(segment -> {
                if (segment.segmentSize == 0) {
                    this.unloader.remove((LazySegment<?>)segment);
                    return true;
                }
                return false;
            });
            this.updateOffsets();
        }
        return changed;
    }

    private void updateOffsets() {
        int offset = 0;
        for (Segment segment : this.segments) {
            if (segment.offset != offset) {
                segment.setOffset(offset);
            }
            offset += segment.segmentSize;
        }
    }

    private E removeFromSegment(Segment segment, int index) {
        Object element = segment.remove(index);
        this.removeSegmentIfEmpty(segment);
        --this.size;
        this.updateOffsets();
        return element;
    }

    private Segment createSegment() {
        return new Segment(this.maxSegmentSize);
    }

    private void addSegment(int segmentOffset, int segmentSize, Object data) {
        this.segments.add(new Segment(segmentOffset, segmentSize, (ControlledLazyReference)data));
    }

    private int modCount() {
        return this.modCount;
    }

    @Override
    public Spliterator<E> spliterator() {
        return this.segmentSpliterator();
    }

    public Spliterator<E> segmentSpliterator() {
        return new SegmentSpliterator(0, -1, 0);
    }

    public Iterator<E> loadedFirstIterator() {
        return new LoadedFirstIterator();
    }

    private static interface IterationLogic<E, R> {
        public R apply(E var1, int var2);
    }

    private class LoadedFirstIterator
    implements Iterator<E> {
        int segmentIndexCursor = 0;
        int totalCursor = 0;
        int expectedModCount;
        Segment currentSegment;
        final Stack<Segment> loadedSegments;
        final Stack<Segment> unloadedSegments;
        int lastRet;
        Segment lastSegment;

        public LoadedFirstIterator() {
            this.expectedModCount = LazyArrayList.this.modCount();
            this.currentSegment = null;
            this.lastRet = -1;
            this.lastSegment = null;
            this.loadedSegments = new Stack();
            this.unloadedSegments = new Stack();
        }

        @Override
        public boolean hasNext() {
            return this.totalCursor < LazyArrayList.this.size();
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new IndexOutOfBoundsException(this.totalCursor);
            }
            if (LazyArrayList.this.modCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.currentSegment == null) {
                this.init();
                this.currentSegment = this.nextSegment();
            }
            Object next = ((ArrayList)this.currentSegment.getData()).get(this.segmentIndexCursor);
            ++this.totalCursor;
            this.lastRet = this.segmentIndexCursor++;
            this.lastSegment = this.currentSegment;
            if (this.segmentIndexCursor >= this.currentSegment.segmentSize) {
                this.segmentIndexCursor = 0;
                this.currentSegment = this.nextSegment();
            }
            return next;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            if (LazyArrayList.this.modCount() != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            LazyArrayList.this.removeFromSegment(this.lastSegment, this.lastRet);
            this.expectedModCount = LazyArrayList.this.modCount();
            if (this.lastRet < this.totalCursor) {
                --this.totalCursor;
                if (this.segmentIndexCursor > 0) {
                    --this.segmentIndexCursor;
                }
            }
            this.lastRet = -1;
        }

        private void init() {
            for (Segment segment : LazyArrayList.this.segments) {
                if (segment.isLoaded()) {
                    this.loadedSegments.push(segment);
                    continue;
                }
                this.unloadedSegments.push(segment);
            }
        }

        private Segment nextSegment() {
            if (!this.loadedSegments.empty()) {
                return this.loadedSegments.pop();
            }
            if (!this.unloadedSegments.empty()) {
                return this.unloadedSegments.pop();
            }
            return null;
        }
    }

    public final class Segment
    implements LazyClearController,
    LazySegment<ArrayList<E>> {
        private int offset;
        private int segmentSize;
        private transient boolean modified;
        private final ControlledLazyReference<ArrayList<E>> data;
        private boolean allowUnloading = true;

        Segment(int initialCapacity) {
            this.offset = 0;
            this.segmentSize = 0;
            this.data = Lazy.register(new ControlledLazyReference.Default(new ArrayList(initialCapacity), this));
        }

        private Segment(int offset, int size, ControlledLazyReference<ArrayList<E>> data) {
            this.offset = offset;
            this.segmentSize = size;
            this.data = data;
            this.data.setLazyClearController(this);
        }

        @Override
        public int size() {
            return this.segmentSize;
        }

        @Override
        public void allowUnload(boolean allow) {
            this.allowUnloading = allow;
        }

        @Override
        public boolean unloadAllowed() {
            return this.allowUnloading;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getSize() {
            return this.segmentSize;
        }

        @Override
        public boolean isLoaded() {
            return this.data.isLoaded();
        }

        @Override
        public boolean isModified() {
            return this.modified;
        }

        @Override
        public void unloadSegment() {
            this.data.clear();
            this.allowUnloading = true;
        }

        @Override
        public boolean allowClear() {
            return !this.modified;
        }

        private void cleanModified() {
            this.modified = false;
        }

        private void setOffset(int offset) {
            this.offset = offset;
        }

        private Lazy<ArrayList<E>> getLazy() {
            return this.data;
        }

        private boolean retainAll(Collection<?> elements) {
            if (((ArrayList)this.getData()).retainAll(elements)) {
                this.segmentSize = ((ArrayList)this.getData()).size();
                this.modified = true;
                return true;
            }
            return false;
        }

        private boolean removeIf(Predicate<? super E> filter) {
            if (((ArrayList)this.getData()).removeIf(filter)) {
                this.segmentSize = ((ArrayList)this.getData()).size();
                this.modified = true;
                return true;
            }
            return false;
        }

        private boolean removeAll(Collection<?> elements) {
            if (((ArrayList)this.getData()).removeAll(elements)) {
                this.segmentSize = ((ArrayList)this.getData()).size();
                this.modified = true;
                return true;
            }
            return false;
        }

        private boolean remove(Object element) {
            if (((ArrayList)this.getData()).remove(element)) {
                this.modified = true;
                --this.segmentSize;
                return true;
            }
            return false;
        }

        private E remove(int index) {
            Object element = ((ArrayList)this.getData()).remove(index);
            this.modified = true;
            --this.segmentSize;
            return element;
        }

        private boolean addAll(int index, Collection<? extends E> elements) {
            if (((ArrayList)this.getData()).addAll(index, elements)) {
                this.segmentSize = ((ArrayList)this.getData()).size();
                this.modified = true;
                return true;
            }
            return false;
        }

        private boolean add(E element) {
            ((ArrayList)this.getData()).add(element);
            this.modified = true;
            ++this.segmentSize;
            return true;
        }

        private void add(int index, E element) {
            ((ArrayList)this.getData()).add(index, element);
            this.modified = true;
            ++this.segmentSize;
        }

        private E set(int index, E element) {
            Object previous = ((ArrayList)this.getData()).set(index, element);
            this.modified = true;
            return previous;
        }

        @Override
        public ArrayList<E> getData() {
            LazyArrayList.this.unloader.unload(this);
            return (ArrayList)this.data.get();
        }

        private ArrayList<E> getLazyData() {
            return (ArrayList)this.data.get();
        }

        private boolean containsIndex(int index) {
            return index >= this.offset && index < this.offset + this.segmentSize;
        }

        private boolean intersectsRange(int startInclusive, int endExclusive) {
            int startOffset = this.offset;
            int endOffset = this.offset + this.segmentSize - 1;
            return startOffset >= startInclusive && startOffset < endExclusive || endOffset >= startInclusive && endOffset < endExclusive;
        }

        public String toString() {
            return "Segment [offset=" + this.offset + ", size=" + this.segmentSize + ", modified=" + this.modified + ", data=" + this.data + "]";
        }
    }

    final class SegmentSpliterator
    implements Spliterator<E> {
        private int fence;
        private int index;
        private int expectedModCount;
        private Segment lastSegment = null;

        public SegmentSpliterator(int index, int fence, int expectedModCount) {
            this.index = index;
            this.fence = fence;
            this.expectedModCount = expectedModCount;
        }

        private int getFence() {
            int hi = this.fence;
            if (hi < 0) {
                this.expectedModCount = LazyArrayList.this.modCount;
                hi = this.fence = LazyArrayList.this.size;
            }
            return hi;
        }

        @Override
        public boolean tryAdvance(Consumer<? super E> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            int i = this.index;
            int hi = this.getFence();
            if (i < hi) {
                this.index = i + 1;
                Segment nextSegment = LazyArrayList.this.segmentForIndex(i);
                nextSegment.allowUnload(false);
                if (this.lastSegment != nextSegment) {
                    if (this.lastSegment != null) {
                        this.lastSegment.allowUnload(true);
                    }
                    this.lastSegment = nextSegment;
                    this.lastSegment.allowUnload(false);
                }
                action.accept(LazyArrayList.this.get(i));
                if (LazyArrayList.this.modCount != this.expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                return true;
            }
            if (this.lastSegment != null) {
                this.lastSegment.allowUnload(true);
            }
            return false;
        }

        public SegmentSpliterator trySplit() {
            int hi = this.getFence();
            int lo = this.index;
            int mid = lo + hi >>> 1;
            Segment midSegment = LazyArrayList.this.segmentForIndex(mid);
            if (hi <= midSegment.offset + midSegment.segmentSize && lo >= midSegment.offset) {
                return null;
            }
            int dist_lo = mid - midSegment.offset;
            int dist_hi = midSegment.offset + midSegment.segmentSize - mid;
            int splitIndex = dist_lo < dist_hi ? midSegment.offset : midSegment.offset + midSegment.segmentSize;
            this.index = splitIndex;
            return new SegmentSpliterator(lo, this.index, this.expectedModCount);
        }

        @Override
        public long estimateSize() {
            return this.getFence() - this.index;
        }

        @Override
        public int characteristics() {
            return 16464;
        }
    }
}

