/*
 * Decompiled with CFR 0.152.
 */
package one.microstream.collections.lazy;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.stream.Stream;
import one.microstream.reference.Lazy;

public interface LazyCollection<E>
extends Collection<E> {
    public <P extends Consumer<Lazy<?>>> P iterateLazyReferences(P var1);

    public boolean consolidate();

    public void tryUnload(boolean var1);

    @Override
    default public Stream<E> stream() {
        return (Stream)Collection.super.stream().onClose(Static.createLazyStreamCloseHandler(this));
    }

    @Override
    default public Stream<E> parallelStream() {
        return (Stream)Collection.super.parallelStream().onClose(Static.createLazyStreamCloseHandler(this));
    }

    public static final class Static {
        static Runnable createLazyStreamCloseHandler(LazyCollection<?> collection) {
            HashSet unloadedLazyReferences = new HashSet();
            collection.iterateLazyReferences(lazy -> {
                if (!lazy.isLoaded()) {
                    unloadedLazyReferences.add(lazy);
                }
            });
            return () -> unloadedLazyReferences.forEach(lazy -> {
                if (lazy.isLoaded() && lazy.isStored()) {
                    lazy.clear();
                }
            });
        }
    }
}

